#include "Arduino.h"
#include <display.h>
#include <SSPanel.h>

#include <Wire.h>
#include <LiquidCrystal_I2C.h>
#include "DigitLedDisplay.h"

LiquidCrystal_I2C lcd(0x27,16,2); // set the LCD address to 0x27 for a 20 chars and 4 line display
DigitLedDisplay ld = DigitLedDisplay(SEG_DIN, SEG_CS, SEG_CLK);


Display::Display() { 

}
void Display::init(){
  lcd.init(); //initialize the lcd
  lcd.backlight(); //open the backlight 
  lcd.clear();
  lcd.setCursor(0,0);
  
  /* Set the brightness min:1, max:15 */
  ld.setBright(1);
  /* Set the digit count */
  ld.setDigitLimit(8);
}  
void Display::clear(){
	lcd.clear();
}
void Display::createChar(uint8_t location, uint8_t charmap[]){
	lcd.createChar(location, charmap);
}
void Display::setCursor(uint8_t x, uint8_t y){
	lcd.setCursor(x, y);
}
void Display::print(char c){
	lcd.print(c);
}
void Display::print(char* c){
	lcd.print(c);
}
void Display::print(const char* c){
	lcd.print(c);
}
void Display::backlight(){
	lcd.backlight();
}
void Display::noBacklight(){
	lcd.noBacklight();
}
void Display::segmentSetDigit(byte digit, byte number, bool leadZero, byte dotDigit){
	
	String s = "";
	if (number<10) {
		if (leadZero) { 
			s = "0";
		} else {
			s = " ";
		}
	}
	s = s + String(number %100);
	
	// byte offset = 6;
	// if (!leadZero && number < 10) { offset = 7; }		// left justifies the number
	ld.printString(s,6 - (digit % 4) * 2, dotDigit % 3);
}
void Display::segmentClear(){
	ld.clear();
}
void Display::printChr(byte position, byte chrIdx){
	ld.printChr(position, chrIdx);
}






  