/*
 * Panel API for SS1 sequencer
 */

#ifndef panel_h
#define panel_h

#include "Arduino.h"
#include <Rotary.h>
#include <display.h>

// define pins for SS1 on DUE
#define CLOCKIN     3
#define PORTOUT0    4
#define PORTOUT1    5
#define PORTOUT2    6
#define PORTOUT3    7

#define ADDR_BTN_SELECT_1_8       50
#define ADDR_BTN_SELECT_9_16      48
#define ADDR_BTN_AUXBANK          44
#define ADDR_BTN_CTRLS            46
#define DATA_BTN_1    36
#define DATA_BTN_2    34
#define DATA_BTN_3    32
#define DATA_BTN_4    30
#define DATA_BTN_5    28
#define DATA_BTN_6    26
#define DATA_BTN_7    24
#define DATA_BTN_8    22

#define ADDR_LED_1_8_GRN    23
#define ADDR_LED_1_8_RED    25
#define ADDR_LED_1_8_YLW    31
#define ADDR_LED_9_16_GRN   33
#define ADDR_LED_9_16_RED   35
#define ADDR_LED_9_16_YLW   37
#define ADDR_LED_AUXBANK    29
#define ADDR_LED_CTRLS      27        
#define DATA_LED_1    39
#define DATA_LED_2    41
#define DATA_LED_3    43
#define DATA_LED_4    45
#define DATA_LED_5    47
#define DATA_LED_6    49
#define DATA_LED_7    51
#define DATA_LED_8    53

#define TRIG0_BTN      9
#define TRIG1_BTN      10

#define KNOB_BTN      42
#define KNOB_A        38
#define KNOB_B        40

#define BUZZ          52

#define SEG_DIN       13
#define SEG_CS        12
#define SEG_CLK       11

// Constants
#define GRNBTNLED			5
#define REDBTNLED			4
#define BLU1BTNLEN			0
#define BLU2BTNLEN			1
#define BLU3BTNLEN			2
#define BLU4BTNLEN			3

#define LEFT				false
#define RIGHT				true

#define EXCL		true
#define NOTEXCL		false

#define ON			true
#define OFF			false

#define INSHIFT 	true
#define OUTSHIFT	false
#define NOBUTTON	0xFF
#define NOSHIFT		0
#define SHIFTDOWN	1
#define SHIFTUP     2

#define TRIGBTN0 	0
#define TRIGBTN1 	1
#define GRNBTN		3
#define REDBTN 		4
#define BLKBTN		2

#define NODIALOG		0
#define ONEOPTDIALOG	1
#define TWOOPTDIALOG	2

#define SOLID 				0
#define BLINK 				1
#define FASTBLINK			2
#define INVERSE				3
#define DOUBLEBLINK			4

#define FADELENGTH			3

#define ROW_GRN 			0
#define ROW_RED 			1
#define ROW_YLW 			2
#define ROW_CTRLS		 	3
#define ROW_BANKAUX			4

	typedef void (*hSelectButton)(byte, byte, bool); 			// NOBUTTON | 0x00 - 0x0F (select) or 0x10 - 0x13 (bank), NOBUTTON | 0x00-0x07, INSHIFT|OUTSHIFT
	typedef void (*hShiftButton)(bool);						    // raised when only SHIFT button is pressed
	typedef void (*hTrigButton)(byte, bool, bool);				// TRIGBTN0 | TRIGBTN1
	typedef void (*hAuxButton)(byte, bool);						// 0-2, INSHIFT|OUTSHIFT
	typedef void (*hKnobButton)(bool,bool);						// INSHIFT|OUTSHIFT
	typedef void (*hKnobRotate)(int, bool);  				    // signed int for delta change of steps, inShift
	typedef void (*hExtIn)();
	typedef void (*hFinishInit)();
	typedef void (*hShowMainDialog)(bool);
	typedef void (*hReturnFromPopup)();

class SSPanel
{
  public:
    SSPanel();
	Display display;

	void begin();
	void handlePanelTimerInterrupt();
	void handlePanelKnobInterrupt();
	void handlePanelTrig0Interrupt();
	void handlePanelTrig1Interrupt();
	void fadePoint(byte row, byte index);
	void setLEDBits(byte row, byte type, uint16_t ledbits);
	void setPoint(byte row, byte type, byte index, bool on, bool excl);
	void setPoint(byte row, byte type, byte index, bool on);
	void setBar(byte row, byte type, byte index);
	void clearAll();
	void clearRow(byte row);
	void clearPoint(byte row, byte index);
	void inverse(byte row);
	void normal(byte row);
	void slideLeft(byte row);
	void slideRight(byte row);
	void processPanel();
	void showOptionDialog(byte type, const char c[], const char y[], const char n[]);
	void showPopupMessage(const char a[],const char b[],byte delay);
	// void showOptionDialog(byte type, String c, String y, String n);
	// void showPopupMessage(String a,String b,byte delay);
	void clearDialog();
	void showToolTip(const char c[]);
	void clearToolTip();
	void setClick(bool b);
	void DEBUG_printLEDState(byte row);
	void togglePort(byte p);
	
	void setHandlerSelectButtonEvent(hSelectButton);
	void setHandlerShiftButtonEvent(hShiftButton);
	void setHandlerTrigButtonEvent(hTrigButton);	
	void setHandlerAuxButtonEvent(hAuxButton);
	void setHandlerKnobButtonEvent(hKnobButton);
	void setHandlerKnobRotateEvent(hKnobRotate);
	void setHandlerExtInEvent(hExtIn);
	void setHandlerFinishInit(hFinishInit);
	void setHandlerShowMainDialog(hShowMainDialog);	
	void setHandlerReturnFromPopup(hReturnFromPopup);

  private:
  	
    byte mLEDS[8][5];
    byte mTempLEDS[8];
	byte mFadeCount[3][16];
	bool mSkipScan;
	int  mScanLEDAddrIndex;
	byte mLEDAddrArray[8] = {ADDR_LED_1_8_GRN,ADDR_LED_9_16_GRN,ADDR_LED_1_8_RED,ADDR_LED_9_16_RED,ADDR_LED_1_8_YLW,ADDR_LED_9_16_YLW,ADDR_LED_CTRLS,ADDR_LED_AUXBANK};
	byte mLEDDataArray[8] = {DATA_LED_1,DATA_LED_2,DATA_LED_3,DATA_LED_4,DATA_LED_5,DATA_LED_6,DATA_LED_7,DATA_LED_8};
	bool mInShift = false;
	bool mInRedBtn = false;
	bool mInGrnBtn = false;
	bool mInBlkBtn = false;
	byte mInCtrlBtn = NOBUTTON;
	byte mInSelectBtn = NOBUTTON;
	bool mInKnobBtn = false;
	volatile int  mDebounceTrig0;
	volatile int  mDebounceTrig1;
	bool mInTrig0;
	bool mInTrig1;
	int mDebounceKnobBtn;
	int mDebounceRedBtn;
	int mDebounceGrnBtn;
	int mDebounceBlkBtn;
	int mDebounceShiftBtn;
	int mDebounceCtrlBtn;
	int mDebounceSlctBtn;
	Display mDisplay;
	byte mInDialog = NODIALOG;
	int  mRotaryDelta;
	bool mBuzz = false;
	bool mClickOn = false;
	bool mInSlide = false;
	byte mSlideRow;
	bool mSlideDirection = LEFT;
	uint16_t mSlideState;
	uint16_t mSlideCounter = 0;
	uint16_t mPopupDelayCounter = 0;
	uint32_t mPopupDelay = 0;
	bool 	 mThrowPopupEvent = false;
	bool mPortState[4];
	byte clearCount = 0;
	
	
	void scanButtons();
	void handleTimerInterupt();
	void scanLEDs();
	void rotateInterupt();
	void updateRotary();
	void trigBtn0Interupt();
	void trigBtn1Interupt();
	byte scanBankAuxBtn();
	byte scanCtrlBtns();
	byte scanSelectButtons();
	void scanKnobBtn();
	void handleDialogEvent(byte,byte);
	void processClick();
	void processPopupDelay();
	void fadeLEDS(int counter);
	void clearPorts();
	
	hSelectButton 	raiseSelectButtonEvent;
	hShiftButton    raiseShiftButtonEvent;
	hTrigButton 	raiseTrigButtonEvent;	
	hAuxButton 		raiseAuxButtonEvent;
	hKnobButton 	raiseKnobButtonEvent;
	hKnobRotate 	raiseKnobRotateEvent;
	hExtIn 			raiseExtInEvent;
	hFinishInit 	raiseFinishInit;
	hShowMainDialog	raiseShowMainDialog;
	hReturnFromPopup raiseReturnFromPopup;

};

#endif


