#include "Arduino.h"
#include <Rotary.h>
#include <display.h>
#include <DueTimer.h>
#include "SSPanel.h"

#define HALF_STEP
#define THRESHOLD 20   // non-giga
Rotary rotary = Rotary(KNOB_A, KNOB_B);

SSPanel::SSPanel() { 
	// constructor - do nothing
}

void SSPanel::begin(){

  
  // set up pin IO
  pinMode(DATA_BTN_1   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_2   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_3   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_4   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_5   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_6   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_7   ,   INPUT_PULLUP); 
  pinMode(DATA_BTN_8   ,   INPUT_PULLUP); 
  
  pinMode(DATA_LED_1   ,   OUTPUT);
  pinMode(DATA_LED_2   ,   OUTPUT);
  pinMode(DATA_LED_3   ,   OUTPUT);
  pinMode(DATA_LED_4   ,   OUTPUT);
  pinMode(DATA_LED_5   ,   OUTPUT);
  pinMode(DATA_LED_6   ,   OUTPUT);
  pinMode(DATA_LED_7   ,   OUTPUT);
  pinMode(DATA_LED_8   ,   OUTPUT);

  pinMode(ADDR_BTN_SELECT_1_8      	,   OUTPUT);
  pinMode(ADDR_BTN_SELECT_9_16     	,   OUTPUT);
  pinMode(ADDR_BTN_AUXBANK         	,   OUTPUT);
  pinMode(ADDR_BTN_CTRLS           	,   OUTPUT);
  pinMode(ADDR_LED_1_8_GRN  		,   OUTPUT);
  pinMode(ADDR_LED_1_8_RED  		,   OUTPUT);
  pinMode(ADDR_LED_1_8_YLW  		,   OUTPUT);
  pinMode(ADDR_LED_9_16_GRN 		,   OUTPUT);
  pinMode(ADDR_LED_9_16_RED 		,   OUTPUT);
  pinMode(ADDR_LED_9_16_YLW 		,   OUTPUT);
  pinMode(ADDR_LED_AUXBANK         	,   OUTPUT);
  pinMode(ADDR_LED_CTRLS           	,   OUTPUT);

  digitalWrite(ADDR_BTN_SELECT_1_8       , LOW);
  digitalWrite(ADDR_BTN_SELECT_9_16      , LOW);
  digitalWrite(ADDR_BTN_AUXBANK          , LOW);
  digitalWrite(ADDR_BTN_CTRLS            , LOW);

  pinMode(TRIG0_BTN		,   INPUT_PULLUP);
  pinMode(TRIG1_BTN     ,   INPUT_PULLUP);
  pinMode(KNOB_BTN      ,   INPUT_PULLUP);
  pinMode(KNOB_A        ,   INPUT_PULLUP);
  pinMode(KNOB_B        ,   INPUT_PULLUP);

  pinMode(BUZZ          ,   OUTPUT);

  pinMode(CLOCKIN   	,    INPUT_PULLUP);         // if pullup is for testing to ground
  
  for (byte p=0;p<4;p++){
	  mPortState[p] = false;
	  pinMode(PORTOUT0 + p,  OUTPUT);
	  digitalWrite(PORTOUT0 + p,  LOW);
  }
 
  Timer1.setPeriod(500);
  Timer1.start();
   
  display.init();
  mDisplay = display;
  
  clearAll();
  
  if (raiseFinishInit != NULL) { raiseFinishInit(); }
  
   // DEBUG stuff
 
}
void SSPanel::handlePanelTimerInterrupt(){ 
	handleTimerInterupt(); 
}
void SSPanel::handlePanelKnobInterrupt(){
	rotateInterupt();
}
void SSPanel::handlePanelTrig0Interrupt(){
	trigBtn0Interupt();
}
void SSPanel::handlePanelTrig1Interrupt(){
	trigBtn1Interupt();
}
void SSPanel::showToolTip(const char c[]){
	mDisplay.setCursor(0,1);
	mDisplay.print("[");
	mDisplay.print(c);
	mDisplay.print("]");
}
void SSPanel::clearToolTip(){
	mDisplay.setCursor(1,1);
	mDisplay.print("              ");
}
void SSPanel::showOptionDialog(byte type, const char c[], const char y[], const char n[]){
	mDisplay.clear();
	mDisplay.setCursor(0,0);
	mDisplay.print(c);
	mDisplay.setCursor(0,1);
	mDisplay.print(y);
	clearPoint(ROW_BANKAUX,GRNBTNLED);
	clearPoint(ROW_BANKAUX,REDBTNLED);
	setPoint(ROW_BANKAUX,FASTBLINK,GRNBTNLED,ON,EXCL);
	if (type == TWOOPTDIALOG) {
		mDisplay.setCursor(8,1);
		mDisplay.print(n);
		setPoint(ROW_BANKAUX,SOLID,REDBTNLED,ON,NOTEXCL);			// turning on SOLID and FASTBLINK will make it outphase phase (alternate) with the GRN FASTBLINK
		setPoint(ROW_BANKAUX,FASTBLINK,REDBTNLED,ON,NOTEXCL);
	}
	mInDialog = type;
	
}
void SSPanel::clearDialog(){
	mInDialog = NODIALOG;
	mDisplay.clear();
	setPoint(ROW_BANKAUX,FASTBLINK,GRNBTNLED,OFF,NOTEXCL);
	setPoint(ROW_BANKAUX,FASTBLINK,REDBTNLED,OFF,NOTEXCL);
	setPoint(ROW_BANKAUX,SOLID,REDBTNLED,OFF,NOTEXCL);
}
void SSPanel::showPopupMessage(const char a[],const char b[],byte delay){
	if (a[0] != '\0'){
		mDisplay.clear();
		mDisplay.setCursor(0,0);
		mDisplay.print(a);
	}
	mDisplay.setCursor(0,1);
	mDisplay.print(b);	
	mPopupDelay = (uint32_t)delay * 500;
}
void SSPanel::processPopupDelay(){
	if (mPopupDelay > 0){
		mPopupDelay--;
		if (mPopupDelay % 700 == 0) {
			mDisplay.setCursor(15,0);
			mDisplay.print('^');
		}
		if (mPopupDelay % 700 == 175) {
			mDisplay.setCursor(15,0);
			mDisplay.print('>');
		}
		if (mPopupDelay % 700 == 350) {
			mDisplay.setCursor(15,0);
			mDisplay.print('v');
		}
		if (mPopupDelay % 700 == 525) {
			mDisplay.setCursor(15,0);
			mDisplay.print('<');
		}
		if (mPopupDelay == 0) {
			mDisplay.setCursor(15,0);
			mDisplay.print(" ");
			mThrowPopupEvent = true;					// this is an interupt call; get out and make it so the event is thrown in SSPanel::processPanel
		}
	}
}

void SSPanel::handleDialogEvent(byte dialog, byte btn){
	switch(dialog){
		case ONEOPTDIALOG:
			if (btn == GRNBTN) {
				if (raiseShowMainDialog != NULL) { raiseShowMainDialog(true); }
				clearDialog();
			}
		break;
		case TWOOPTDIALOG:
			if (btn == GRNBTN) {
				clearDialog();
				if (raiseShowMainDialog != NULL) { raiseShowMainDialog(true); }
			} else if (btn == REDBTN) {
				clearDialog();
				if (raiseShowMainDialog != NULL) { raiseShowMainDialog(false); }				
			}
		break;
	}
}

void SSPanel::processPanel(){
	if (mThrowPopupEvent) {
		if (raiseReturnFromPopup != NULL) { raiseReturnFromPopup(); }
		mThrowPopupEvent = false;
	}
	updateRotary();
	scanButtons();
}
void SSPanel::setClick(bool b){
	mClickOn = b;
}
void SSPanel::scanButtons(){
	
	byte raiseShift = NOSHIFT;
	byte bankAuxBtn =  scanBankAuxBtn();		// return status bits for each button
	
    if (!(bankAuxBtn & 0b10000000) && mInShift && (millis() > mDebounceShiftBtn + THRESHOLD)) {   // process SHIFT first
		raiseShift = SHIFTUP; 
		mInShift = OUTSHIFT; 
		mDebounceShiftBtn = millis(); 
	}
	if ((bankAuxBtn & 0b10000000) && !mInShift && (millis() > mDebounceShiftBtn + THRESHOLD)) { 
		raiseShift = SHIFTDOWN; 
		mInShift = INSHIFT; 
		mDebounceShiftBtn = millis(); 
	}

	trigBtn0Interupt();
	trigBtn1Interupt();
	scanKnobBtn();
	
	if (bankAuxBtn & 0b00010000) { 
		if (!mInRedBtn) { 
			mInRedBtn = true;
			mDebounceRedBtn = millis();
			if (mInDialog == NODIALOG){
				if (raiseAuxButtonEvent != NULL) { raiseAuxButtonEvent(REDBTN, mInShift); }
			} else {
				handleDialogEvent(mInDialog, REDBTN);
			}
		} 
	} else if (millis() > mDebounceRedBtn + THRESHOLD) { mInRedBtn = false; }
	
	if (bankAuxBtn & 0b00100000) { 
		if (!mInGrnBtn) { 
			mInGrnBtn = true;
			mDebounceGrnBtn = millis();			
			if (mInDialog == NODIALOG){
				if (raiseAuxButtonEvent != NULL) { raiseAuxButtonEvent(GRNBTN, mInShift); }
			} else {
				handleDialogEvent(mInDialog, GRNBTN);				
			}
		}
	} else if (millis() > mDebounceGrnBtn + THRESHOLD) { mInGrnBtn = false; }
	
	if (bankAuxBtn & 0b01000000) { 
		if (!mInBlkBtn) { 
			mInBlkBtn = true;
			mDebounceBlkBtn = millis();			
			if (raiseAuxButtonEvent != NULL) { raiseAuxButtonEvent(BLKBTN, mInShift); }
		} 
	} else if (millis() > mDebounceBlkBtn + THRESHOLD) { mInBlkBtn = false; }
	
	byte selectBtn;		
	switch (bankAuxBtn & 0x0F) {
		case 0b1000:
			selectBtn = 0x10;
			break;
		case 0b0100:
			selectBtn = 0x11;
			break;
		case 0b0010:
			selectBtn = 0x12;
			break;
		case 0b0001:
			selectBtn = 0x13;
			break;
		default:
			selectBtn = NOBUTTON;
			break;
	}

	bool raiseEvent = false;
	byte ctrlBtn = NOBUTTON;
	
	ctrlBtn = scanCtrlBtns();				// return a byte for one button

	if (ctrlBtn != mInCtrlBtn && millis() > mDebounceCtrlBtn + THRESHOLD) {
		raiseEvent = true;						// this special case raises event on Ctrl Btn DOWN *and* UP
		mInCtrlBtn = ctrlBtn;
		mDebounceCtrlBtn = millis();
	} 
	
	if (selectBtn == NOBUTTON) { selectBtn = scanSelectButtons(); }		// got through the blue buttons with no value so scan the select buttons; return a byte for one button

	if (selectBtn != mInSelectBtn && millis() > mDebounceSlctBtn + THRESHOLD) {
		raiseEvent = true;
		mInSelectBtn = selectBtn;
		mDebounceSlctBtn = millis();
	} 

	if (raiseEvent) {
		if (raiseSelectButtonEvent != NULL) { raiseSelectButtonEvent(mInSelectBtn, mInCtrlBtn, mInShift); }
	} else {
		switch (raiseShift){
			case SHIFTDOWN:
				if (raiseShiftButtonEvent != NULL) { raiseShiftButtonEvent(INSHIFT); }
				break;
			case SHIFTUP:
				if (raiseShiftButtonEvent != NULL) { raiseShiftButtonEvent(OUTSHIFT); }
				break;
		}
	}
}
void SSPanel::scanKnobBtn(){
	if (!digitalRead(KNOB_BTN) && !mInKnobBtn && (millis() > mDebounceKnobBtn + THRESHOLD)) { 
		if (raiseKnobButtonEvent != NULL) { raiseKnobButtonEvent(true,mInShift); } 
		mInKnobBtn = true; 
		mDebounceKnobBtn = millis(); 
	}
	if (digitalRead(KNOB_BTN) && mInKnobBtn && (millis() > mDebounceKnobBtn + THRESHOLD)) { 
		if (raiseKnobButtonEvent != NULL) { raiseKnobButtonEvent(false,mInShift); } 
		mInKnobBtn = false; 
		mDebounceKnobBtn = millis(); 
	}
}
byte SSPanel::scanBankAuxBtn(){ 		// return status bits for each button
	byte rtnBits = 0;
    digitalWrite(ADDR_BTN_AUXBANK   , LOW);
    if (!digitalRead(DATA_BTN_1)) { rtnBits = rtnBits | 0b10000000 ; }
    if (!digitalRead(DATA_BTN_2)) { rtnBits = rtnBits | 0b01000000 ; }
    if (!digitalRead(DATA_BTN_3)) { rtnBits = rtnBits | 0b00100000 ; }
    if (!digitalRead(DATA_BTN_4)) { rtnBits = rtnBits | 0b00010000 ; }
    if (!digitalRead(DATA_BTN_5)) { rtnBits = rtnBits | 0b00001000 ; }
    if (!digitalRead(DATA_BTN_6)) { rtnBits = rtnBits | 0b00000100 ; }
    if (!digitalRead(DATA_BTN_7)) { rtnBits = rtnBits | 0b00000010 ; }
    if (!digitalRead(DATA_BTN_8)) { rtnBits = rtnBits | 0b00000001 ; }
    digitalWrite(ADDR_BTN_AUXBANK   , HIGH); 
	return rtnBits;
}		
byte SSPanel::scanCtrlBtns(){		// return 0-7 or NOBUTTON
	byte rtnValue = NOBUTTON;
    digitalWrite(ADDR_BTN_CTRLS   , LOW);
    if (!digitalRead(DATA_BTN_1)) { rtnValue = 0; }
    if (!digitalRead(DATA_BTN_2)) { rtnValue = 1; }
    if (!digitalRead(DATA_BTN_3)) { rtnValue = 2; }
    if (!digitalRead(DATA_BTN_4)) { rtnValue = 3; }
    if (!digitalRead(DATA_BTN_5)) { rtnValue = 4; }
    if (!digitalRead(DATA_BTN_6)) { rtnValue = 5; }
    if (!digitalRead(DATA_BTN_7)) { rtnValue = 6; }
    if (!digitalRead(DATA_BTN_8)) { rtnValue = 7; }
    digitalWrite(ADDR_BTN_CTRLS   , HIGH); 
	return rtnValue;
}		
byte SSPanel::scanSelectButtons(){	// return 0x00 - 0x13 or NOBUTTON
	byte rtnValue = NOBUTTON;
    digitalWrite(ADDR_BTN_SELECT_1_8   , LOW);
    if (!digitalRead(DATA_BTN_1)) { rtnValue = 0; }
    if (!digitalRead(DATA_BTN_2)) { rtnValue = 1; }
    if (!digitalRead(DATA_BTN_3)) { rtnValue = 2; }
    if (!digitalRead(DATA_BTN_4)) { rtnValue = 3; }
    if (!digitalRead(DATA_BTN_5)) { rtnValue = 4; }
    if (!digitalRead(DATA_BTN_6)) { rtnValue = 5; }
    if (!digitalRead(DATA_BTN_7)) { rtnValue = 6; }
    if (!digitalRead(DATA_BTN_8)) { rtnValue = 7; }
    digitalWrite(ADDR_BTN_SELECT_1_8   , HIGH); 
    digitalWrite(ADDR_BTN_SELECT_9_16   , LOW);
    if (!digitalRead(DATA_BTN_1)) { rtnValue = 8; }
    if (!digitalRead(DATA_BTN_2)) { rtnValue = 9; }
    if (!digitalRead(DATA_BTN_3)) { rtnValue = 10; }
    if (!digitalRead(DATA_BTN_4)) { rtnValue = 11; }
    if (!digitalRead(DATA_BTN_5)) { rtnValue = 12; }
    if (!digitalRead(DATA_BTN_6)) { rtnValue = 13; }
    if (!digitalRead(DATA_BTN_7)) { rtnValue = 14; }
    if (!digitalRead(DATA_BTN_8)) { rtnValue = 15; }
    digitalWrite(ADDR_BTN_SELECT_9_16   , HIGH); 
	return rtnValue;
}

void SSPanel::setLEDBits(byte row, byte type, uint16_t ledbits){
	for (byte t=0;t<5;t++){
		if (row < ROW_CTRLS) {
			mLEDS[row * 2][type] = ledbits >> 8;			// moves high bits, drops low bits
			mLEDS[row * 2 + 1][type] = ledbits & 0xFF;		
		} else {
			mLEDS[row + 3][type] = ledbits & 0xFF;
		}
	}
}
void SSPanel::setBar(byte row, byte type, byte index){
	if (row < ROW_CTRLS) {
		int t = 0xFFFF << (16 - index);
		mLEDS[row * 2][type] = t >> 8;			// moves high bits, drops low bits
		mLEDS[row * 2 + 1][type] = t & 0xFF;			
	}
}
void SSPanel::setPoint(byte row, byte type, byte index, bool on, bool excl){
	uint16_t bit = 0b1000000000000000 >> index;
	if (row > ROW_YLW) {
		bit = bit >> 8;
		if (excl){
			if (on) {
				setLEDBits(row, type, bit);
			} else {
				setLEDBits(row, type, 0x0);
			}
		} else {
			if (on) {
				bit = bit | mLEDS[row + 3][type];										// non-excl - OR the new bit with the existing bits
				setLEDBits(row, type, bit);												// then replace it
			} else {
				bit = (~bit) & mLEDS[row + 3][type];
				setLEDBits(row, type, bit);
			}
		}			
	} else {		// 16 LED row
		if (excl){
			if (on) {
				setLEDBits(row, type, bit);												// excl - replace entire row with one bit
			} else {
				setLEDBits(row, type, 0x0);
			}
		} else {
			if (on) {
				bit = bit | (mLEDS[row * 2][type] << 8) | mLEDS[row * 2 + 1][type];		// non-excl - OR the new bit with the existing bits
				setLEDBits(row, type, bit);												// then replace it
			} else {
				bit = (~bit) & ((mLEDS[row * 2][type] << 8) | mLEDS[row * 2 + 1][type]);
				setLEDBits(row, type, bit);
			}
		}
	}
}
void SSPanel::setPoint(byte row, byte type, byte index, bool on){
	//Serial.print("setPoint:r:");Serial.print(row);Serial.print("t:");Serial.print(type);Serial.print("i:");Serial.print(index);Serial.print("on:");Serial.println(on);
	setPoint(row, type, index, on, NOTEXCL);
}
void SSPanel::fadePoint(byte row, byte index){
	setPoint(row, SOLID, index, ON);
	mFadeCount[row][index] = FADELENGTH;
}
void SSPanel::clearAll(){
  for (byte r=0;r<8;r++){
	  clearRow(r);
  }	
}	
void SSPanel::clearRow(byte row){
	for (byte t=0;t<5;t++){
		if (t != INVERSE){
			setLEDBits(row, t, 0x0);
		}
	}
}
void SSPanel::clearPoint(byte row, byte index){
	for (byte t=0;t<5;t++){
		setPoint(row, t, index, OFF);
	}
}
void SSPanel::inverse(byte row){
	setLEDBits(row,INVERSE,0xFFFF);
}
void SSPanel::normal(byte row){
	setLEDBits(row,INVERSE,0x00);
}
void SSPanel::slideLeft(byte row){
	normal(row);
	mSlideRow = row;
	mSlideDirection = LEFT;
	mSlideState = 0x0001;
	mSlideCounter = 0;
	mInSlide = true;
}
void SSPanel::slideRight(byte row){
	normal(row);
	mSlideRow = row;
	mSlideDirection = RIGHT;
	mSlideState = 0XFFFF;
	mSlideCounter = 0;
	mInSlide = true;
}


void SSPanel::setHandlerSelectButtonEvent(hSelectButton p){
	raiseSelectButtonEvent = p;
}
void SSPanel::setHandlerShiftButtonEvent(hShiftButton p){
	raiseShiftButtonEvent = p;
}
void SSPanel::setHandlerTrigButtonEvent(hTrigButton p){
	raiseTrigButtonEvent = p;
}
void SSPanel::setHandlerAuxButtonEvent(hAuxButton p){
	raiseAuxButtonEvent = p;
}
void SSPanel::setHandlerKnobButtonEvent(hKnobButton p){
	raiseKnobButtonEvent = p;
}
void SSPanel::setHandlerKnobRotateEvent(hKnobRotate p){
	raiseKnobRotateEvent = p;
}
void SSPanel::setHandlerExtInEvent(hExtIn p){
	raiseExtInEvent = p;
}
void SSPanel::setHandlerFinishInit(hFinishInit p){
	raiseFinishInit = p;
}
void SSPanel::setHandlerShowMainDialog(hShowMainDialog p){
	raiseShowMainDialog = p;
}
void SSPanel::setHandlerReturnFromPopup(hReturnFromPopup p){
	raiseReturnFromPopup = p;
}


void SSPanel::rotateInterupt() {
	unsigned char r = rotary.process();
	if (r != DIR_NONE) { 
		if (r == DIR_CW) {
		 mRotaryDelta++;
		} else {
		 mRotaryDelta--;
		}
	}
}
void SSPanel::updateRotary(){
	if (mRotaryDelta != 0){
		if (raiseKnobRotateEvent != NULL) { raiseKnobRotateEvent(mRotaryDelta, mInShift); }
		mRotaryDelta = 0;
	}
}
void SSPanel::trigBtn0Interupt(){
	if (millis() > mDebounceTrig0 + THRESHOLD){
		if (digitalRead(TRIG0_BTN) == HIGH && mInTrig0) { 
			mInTrig0 = false; 
			mDebounceTrig0 = millis();
			if (raiseTrigButtonEvent != NULL) { raiseTrigButtonEvent(TRIGBTN0,OFF,mInShift); }
		}
		if (digitalRead(TRIG0_BTN) == LOW && !mInTrig0){
			mDebounceTrig0 = millis();
			mInTrig0 = true;
			if (raiseTrigButtonEvent != NULL) { raiseTrigButtonEvent(TRIGBTN0,ON,mInShift); }
		}
	}
}
void SSPanel::trigBtn1Interupt(){
	if (millis() > mDebounceTrig1 + THRESHOLD){
		if (digitalRead(TRIG1_BTN) == HIGH && mInTrig1) { 
			mInTrig1 = false; 
			mDebounceTrig1 = millis();
			if (raiseTrigButtonEvent != NULL) { raiseTrigButtonEvent(TRIGBTN1,OFF,mInShift); }
		}
		if (digitalRead(TRIG1_BTN) == LOW && !mInTrig1){
			mDebounceTrig1 = millis();
			mInTrig1 = true;
			if (raiseTrigButtonEvent != NULL) { raiseTrigButtonEvent(TRIGBTN1,ON,mInShift); }
		}
	}
}

void SSPanel::scanLEDs(){

	fadeLEDS(mScanLEDAddrIndex);
	
	digitalWrite(mLEDAddrArray[mScanLEDAddrIndex % 8],LOW);
		
	mScanLEDAddrIndex++; 

	byte lb;
	byte bb;
	byte fb;
	byte ib;
	byte db;
	byte rb;

	lb = mLEDS[mScanLEDAddrIndex % 8][SOLID];
	
	if (mInSlide && ((mScanLEDAddrIndex % 8 == mSlideRow * 2) || (mScanLEDAddrIndex % 8 == mSlideRow * 2 + 1))) {  // merge the slide into the LEDs if doing the slideRow
		if (mSlideDirection) {
			lb = lb >> 1;
		} else {
			lb = lb << 1;
		}
		lb = lb ^ mTempLEDS[mScanLEDAddrIndex % 8];
	}
	bb = mLEDS[mScanLEDAddrIndex % 8][BLINK];
	fb = mLEDS[mScanLEDAddrIndex % 8][FASTBLINK];
	ib = mLEDS[mScanLEDAddrIndex % 8][INVERSE];
	db = mLEDS[mScanLEDAddrIndex % 8][DOUBLEBLINK];
	
	if (mScanLEDAddrIndex / 200 % 2 == 0) { lb = lb ^ bb; }
	if (mScanLEDAddrIndex / 100 % 2 == 0) { lb = lb ^ fb; }
	if (mScanLEDAddrIndex / 100 % 8 == 0 || mScanLEDAddrIndex / 100 % 8 == 3) { lb = lb ^ db; }
	lb = lb ^ ib;

	byte i = 0b10000000;

	for (byte n=0;n<8;n++){		
		digitalWrite(mLEDDataArray[n]  , !(lb & i));  
		i = i >> 1;
	}
	digitalWrite(mLEDAddrArray[mScanLEDAddrIndex % 8],HIGH);
}
void SSPanel::fadeLEDS(int counter){
	byte r = (counter / 16) % 3;
	byte c = counter % 16;
	if (mFadeCount[r][c] > 0){
		mFadeCount[r][c]--;
		if (mFadeCount[r][c] == 1) {
			clearPoint(r,c);
		}
	}
}
void SSPanel::processClick(){
	if (mClickOn) {                                               // turns the piezo on/off to make the buzz sound for the metronome
		mBuzz = !mBuzz;
	} else {
		mBuzz = false;
	}
	digitalWrite(BUZZ,mBuzz);	
}
void SSPanel::handleTimerInterupt(){
  
	processClick();
  
	mSkipScan = !mSkipScan;     // skip the LED scan every other time. This allows the Interupt Timer to run twice as fast than LEDs need and have the metronome tone be at a good pitch
	if (mSkipScan) { 
		if (mInSlide){
			if (mSlideCounter % 20 == 0) {
				mTempLEDS[mSlideRow * 2] = mSlideState >> 8;			// moves high bits, drops low bits
				mTempLEDS[mSlideRow * 2 + 1] = mSlideState & 0xFF;	
				if (mSlideDirection){
					mSlideState = mSlideState >> 1;
				} else {
					mSlideState = (mSlideState << 1) + 1;
				}
			}
			mSlideCounter++;
			if (mSlideCounter == 320) {
				if (mSlideDirection) {
					normal(mSlideRow);
				} else {
					inverse(mSlideRow);
				}
				mInSlide = false; 
			}
		}
		scanLEDs();
	} else {
		processPopupDelay();
		clearPorts();	
	}
}
void SSPanel::DEBUG_printLEDState(byte row){
	for (byte t=0;t<5;t++){
		Serial.print(F("t:"));Serial.print(t);Serial.print(F("\t"));
		Serial.print(mLEDS[row][t],BIN);Serial.print(F("\t"));
	}
	Serial.println();
}
void SSPanel::togglePort(byte p){
  mPortState[p] = true;
  digitalWrite(PORTOUT0 + p,  HIGH);	
}
void SSPanel::clearPorts(){
	clearCount++;
	if (clearCount == 5) { 
		clearCount = 0; 
		for (byte p=0;p<4;p++){
			if (mPortState[p]){
				mPortState[p] = false;
				digitalWrite(PORTOUT0 + p,  LOW);
			}
		}
	}
}
	
	
	