// **********************************************
// *
// *    UI event handlers 
// *
// **********************************************
void ssUIHandler_handleShiftButton(bool shiftDown){
  _inShift = shiftDown;
}
void ssUIHandler_handleSelectButton(byte select, byte ctrl, bool inShift) {
  //DEBUG_showSelectButtonEvent(select,ctrl,inShift);

  switch (_panelPage){

  // *******************************
  // *
  // *  DEFAULT ACTIONS
  // *
  // *******************************
  case DEFAULT:             // these are all the default actions
  
// **
// ** SELECT BUTTONS
// **  
    processDefaultSelectBtns(select, ctrl, inShift);

// **
// ** SHIFT + SELECT BUTTONS
// **
    // handle SHIFT+Select_0 = toggle metro
    if (inShift && NOCTRLBTN && select == 0) { 
      ssPanel.setClick(false); // turn off metro sound
      _metro = !_metro; 
    }
    // handle SHIFT+Select_1 = clock reset
    if (inShift && NOCTRLBTN && select == 1){
      ssMidiHelper_killAllOutNotes(SEQ);
      ssClockHelper_resetSequencerStep();
    }
    // handle SHIFT+Select_2 = _inRatchet
    if (inShift && NOCTRLBTN && select == 2){
      _inRatchet = true;
    }
    // handle SHIFT+Select_4 = midi panic 
    if (inShift && NOCTRLBTN && select == 4){
      ssMidiHelper_panic();
    }  
    // handle SHIFT+Select_7 = _inRatchet
    if (inShift && NOCTRLBTN && select == 7){
      _inKeyboard = true;
      ssDisplay_enterKeyboard();
    }    
// **
// ** SELECT SLIDES
// **
    processDefaultSelectSlides(select, ctrl, inShift);

// **
// ** SELECT BANK BUTTONS
// **  
    processDefaultBankButtons(select, ctrl, inShift);

// **
// ** SOLO ctrl buttons
// **
    // handle solo = show solo tool tip
    if (!inShift && ctrl == 0 && NOSELBTN){
      ssDisplayUI_loadPanelPage(SOLOPAGE);
    }   
    // handle SHIFT+Solo = lock solo
    if (inShift && ctrl == 0 && NOSELBTN){
      if (_inLock == SOLOLOCK){  // leave solo lock
        ssDisplayUI_gotoLock(NOLOCK);
        ssDisplayUI_loadPanelPage(DEFAULT);
      } else if (_inLock == NOLOCK) {
        ssDisplayUI_gotoLock(SOLOLOCK); 
        ssDisplayUI_loadPanelPage(SOLOPAGE);  // goto solo lock
      }
    }

// **
// ** MUTE ctrl buttons
// **
    // handle Mute = show mute tool tip
    if (!inShift && ctrl == 1 && NOSELBTN){
      ssDisplayUI_loadPanelPage(MUTEPAGE);
    }   
    // handle SHIFT+Mute = lock solo
    if (inShift && ctrl == 1 && NOSELBTN){
      if (_inLock == MUTELOCK){  // leave mute lock
        ssDisplayUI_gotoLock(NOLOCK);
        ssDisplayUI_loadPanelPage(DEFAULT);
      } else if (_inLock == NOLOCK) {
        ssDisplayUI_gotoLock(MUTELOCK); 
        ssDisplayUI_loadPanelPage(MUTEPAGE);  // goto mute lock
      }
    }
    
// **
// ** BAR ctrl buttons
// **
    // handle Bar = show jump tool tip
    if (!inShift && ctrl == 2 && NOSELBTN){
      ssDisplayUI_loadPanelPage(BARJUMP);
    }   
    // handle SHIFT+Bar = show length
    if (inShift && ctrl == 2 && NOSELBTN){
      ssDisplayUI_loadPanelPage(BARLENGTH); 
    }

// **
// ** STEP ctrl buttons
// **

    // handle solo = show solo tool tip
    if (!inShift && ctrl == 3 && NOSELBTN){
      ssDisplayUI_loadPanelPage(STEPJUMP);
    }   
    // handle SHIFT+Solo = lock solo
    if (inShift && ctrl == 3 && NOSELBTN){
      if (_inLock == STEPLOCK){  // leave step edit lock
        ssStepEdit_leaveStepEditPage();
        ssDisplayUI_gotoLock(NOLOCK);
        ssDisplayUI_loadPanelPage(DEFAULT);
      } else if (_inLock == NOLOCK) {
        ssDisplayUI_gotoLock(STEPLOCK); 
        ssDisplayUI_loadPanelPage(STEPEDIT);  // goto stepedit lock
      }
    }

// **
// ** MIDI ctrl buttons
// **
    // handle Midi = show selected MIDI channel for track
    if (!inShift && ctrl == 5 && NOSELBTN){
      ssDisplayUI_loadPanelPage(NOTEMIDIMAP);
    }
    // handle SHIFT+Midi -> inTrigger =  show selected drum map; "in  Track" = show patch bank option  
    if (inShift && ctrl == 5 && NOSELBTN){
      if (_inLock == PATCHLOCK){                    // leave patch lock
        ssDisplayUI_gotoLock(NOLOCK);
        ssDisplayUI_loadPanelPage(DEFAULT);
      } else if (_inLock == NOLOCK) {
        if (_inTrigger){
          ssDisplayUI_loadPanelPage(DMAPSELECT);
        } else {
          ssDisplayUI_gotoLock(PATCHLOCK); 
          ssDisplayUI_loadPanelPage(PATCHSELECT);  // goto patch lock
        }
      }
    }
    
// **
// ** YELLOW FUNC ctrl buttons - ctrl == 4
// **
    // handle YFunc+Select_0 = New
    if (!inShift && ctrl == 4 && select == 0){
      if (ssFileHelper_fileDirty()){
        ssDisplayUI_showYesNoDialog(CLEARNEW, str_NEWSAVEFIRST_QUESTION);  
      } else {
        ssDisplayUI_showYesNoDialog(CLEARNEW, str_NEWPROJECT_QUESTION);  
      }
    }
    // handle YFunc+Select_1 = Save
    if (!inShift && ctrl == 4 && select == 1){
      ssClockHelper_setPlayTransport(false);
      ssMidiHelper_killAllOutNotes(SEQ);
      ssFileHelper_saveProject();
    }
    // handle SHIFT+YFunc+Select_1 = Save New
    if (inShift && ctrl == 4 && select == 1){
      ssClockHelper_setPlayTransport(false);
      ssMidiHelper_killAllOutNotes(SEQ);
      ssFileHelper_saveAsNewProject();
    }
    // handle YFunc+Select_2 = Load
    if (!inShift && ctrl == 4 && select == 2){
      ssClockHelper_stopTransport();
      ssMidiHelper_killAllOutNotes(SEQ);
      ssDisplayUI_loadPanelPage(FILEPAGE);
    }
    // handle YFunc+Select_3 = Restore
    if (!inShift && ctrl == 4 && select == 3){
      ssClockHelper_stopTransport();
      ssMidiHelper_killAllOutNotes(SEQ);
      ssDisplayUI_loadPanelPage(RESTOREPAGE);
    }    
    // handle SHIFT+YFunc+Select_2 = Reload
    if (inShift && ctrl == 4 && select == 2){
      ssFileHelper_reloadProject();
    }
    // handle YFunc+Select_4 = Mark Patch
    if (!inShift && ctrl == 4 && select == 4){
      ssMidiHelper_markPatch();
    }
    // handle YFunc+Select_7 == mark tempo
    if (!inShift && ctrl == 4 && select == 7){
      ssSequencer_markTempo(_currentBank,_currentStep);
      ssFileHelper_makeFileDirty(23);      
    }       
    // handle SHIFT+YFunc+Select_7 == clear tempo
    if (inShift && ctrl == 4 && select == 7){
      ssNoteData.clearCmdForBank(_currentBank,6);      // CMD 6 = tempo
      ssFileHelper_makeFileDirty(23);      
    }    
    // handle SHIFT+YFunc+Select_4 = clear Patch
    if (inShift && ctrl == 4 && select == 4){
      if (!_inTrigger) {
        ssNoteData.clearCmdForTrack(_currentBank,_currentNoteTrack,4);
        ssFileHelper_makeFileDirty(23);      
      }
    }
    // handle SHIFT+YFunc+Select_5 = clear CC
    if (inShift && ctrl == 4 && select == 5){
      if (!_inTrigger) {
        ssNoteData.clearCmdForTrack(_currentBank,_currentNoteTrack,5);  
        ssFileHelper_makeFileDirty(24);    
      }
    }
    // handle SHIFT+YFunc+Select_6 = clear Pitch
    if (inShift && ctrl == 4 && select == 6){
      if (!_inTrigger) {
        ssNoteData.clearCmdForTrack(_currentBank,_currentNoteTrack,3);
        ssFileHelper_makeFileDirty(25);      
      }
    }
  
    // handle SHIFT+YFunc+Select_12 = erase
    if (inShift && ctrl == 4 && select == 12){
      _inErase = true;
    }
    // handle SHIFT+YFunc+Select_8 = clear track
    if (inShift && ctrl == 4 && select == 8){
      ssDisplayUI_showYesNoDialog(CLEARTRACK, str_CLEARTRACK_QUESTION);
    }
    // handle SHIFT+YFunc+Select_9 = clear drums
    if (inShift && ctrl == 4 && select == 9){
      ssDisplayUI_showYesNoDialog(CLEARDRUMS, str_CLEARDRUMS_QUESTION);
    }
    // handle SHIFT+YFunc+Select_10 = clear bank
    if (inShift && ctrl == 4 && select == 10){
      ssDisplayUI_showYesNoDialog(CLEARBANK, str_CLEARBANK_QUESTION);
    }
    // handle SHIFT+YFunc+Select_11 = clear all data
    if (inShift && ctrl == 4 && select == 11){
      ssDisplayUI_showYesNoDialog(CLEARALL, str_CLEARALLDATA_QUESTION);
    }

    //
    // DRUM MAPS
    //
    // handle YFunc+Select_12 = Save DrumMap
    if (!inShift && ctrl == 4 && select == 12){
      ssClockHelper_setPlayTransport(false);
      ssDisplayUI_loadPanelPage(SAVEDMAP);
    }
    // handle YFunc+Select_13 = Make Maps Default
    if (!inShift && ctrl == 4 && select == 13){
      ssSettings_copyProjectMapsToGlobal();
      ssDisplayUI_showPopupMessage(str_DEFAULTDRUM,str_MAPSET,3);
    }   
    // handle SHIFT+YFunc+Select_15 = Reset Midi
    if (inShift && ctrl == 4 && select == 15){
      ssSettings_copyGlobalMapToProject();
      ssDisplayUI_showPopupMessage("",str_RESETMIDI_WARNING,3);
    }
    // handle YFunc+Select_14 = VMAPHIT value
    if (!inShift && ctrl == 4 && select == 14){
      if (_inTrigger){
        ssDisplayUI_loadPanelPage(VMAPHIT);
      }
    }
    // handle YFunc+Select_15 = VMAPACCENT value
    if (!inShift && ctrl == 4 && select == 15){
      if (_inTrigger){
        ssDisplayUI_loadPanelPage(VMAPACCENT);
      }
    }    
// **
// ** WHITE FUNC ctrl buttons - ctrl == 6
// **
    // handle WFunc+Select_8 = Octave down
    if (ctrl == 6 && select == 8){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        ssMidiHelper_transposePlayingSeqNotesForTrack(_currentNoteTrack,-12);
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 1, 1, -12, false);   // need to adjust noteOn, cmdValue 1
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 2, 1, -12, false);   // and noteOff
        ssFileHelper_makeFileDirty(26); 
      }
    }
    // handle WFunc+Select_9 = Octave up
    if (ctrl == 6 && select == 9){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        ssMidiHelper_transposePlayingSeqNotesForTrack(_currentNoteTrack,12);
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 1, 1, 12, false);   // need to adjust noteOn
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 2, 1, 12, false);   // and noteOff
        ssFileHelper_makeFileDirty(27);
      }
    }
    // handle WFunc+Select_10 = semi tone down
    if (ctrl == 6 && select == 10){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        //Serial.print(startingStep);Serial.print("/");Serial.println(MAXSTEPS*2 - startingStep);

        ssMidiHelper_transposePlayingSeqNotesForTrack(_currentNoteTrack,-1);
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 1, 1, -1, false);   // need to adjust noteOn, cmdValue 1
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 2, 1, -1, false);   // and noteOff
        ssFileHelper_makeFileDirty(28); 
      }
    }
    // handle WFunc+Select_11 = semi tone up
    if (ctrl == 6 && select == 11){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        //Serial.print(startingStep);Serial.print("/");Serial.println(MAXSTEPS*2 - startingStep);
        
        ssMidiHelper_transposePlayingSeqNotesForTrack(_currentNoteTrack,1);
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 1, 1, 1, false);   // need to adjust noteOn
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 2, 1, 1, false);   // and noteOff
        ssFileHelper_makeFileDirty(29);
      }
    }
        //flipTrackSteps
    // handle WFunc+Select_12 = flip track at step
    if (ctrl == 6 && select == 12){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        //Serial.print(startingStep);Serial.print("/");Serial.println(MAXSTEPS*2 - startingStep);
        
        ssNoteData.flipTrackSteps(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep);   // need to adjust noteOn
        ssFileHelper_makeFileDirty(30);
      }
    }  

    //nudgeTrack
    // handle WFunc+Select_13 = nudge track left
    if (ctrl == 6 && select == 13){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        ssNoteData.nudgeTrack(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, -2);             // nudge left 1/16 note
        ssFileHelper_makeFileDirty(301);
      }
    }           
    // handle WFunc+Select_14 = nudge track left
    if (ctrl == 6 && select == 14){
      if (!_inTrigger){
        int startingStep = 0; 
        if (_currentStep > 0) { startingStep = _currentStep *2; }             // do only remaining steps
        if (inShift) { startingStep = 0; }                                    // do full track
        ssNoteData.nudgeTrack(_currentBank, _currentNoteTrack, startingStep, MAXSTEPS*2 - startingStep, 2);             // nudge right 1/16 note
        ssFileHelper_makeFileDirty(302);
      }
    }    
    // handle WFunc+Select_4 = velocity down
    if (!inShift && ctrl == 6 && select == 4){
      if (!_inTrigger){
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, 0, MAXSTEPS*2, 1,2, -10, true);
        ssFileHelper_makeFileDirty(31); 
      }
    }
    // handle WFunc+Select_5 = velocity up
    if (!inShift && ctrl == 6 && select == 5){
      if (!_inTrigger){
        ssNoteData.adjustCmdValue(_currentBank, _currentNoteTrack, 0, MAXSTEPS*2, 1,2, 10, true);
        ssFileHelper_makeFileDirty(32);
      }
    }
    if (!inShift && ctrl == 6 && select == 6){
      if (!_inTrigger){
        ssNoteData.levelCmdValue(_currentBank, _currentNoteTrack, 0, MAXSTEPS*2, 1, 2, 127, 2);      // normalize
        ssFileHelper_makeFileDirty(33);
      }
    }
    if (!inShift && ctrl == 6 && select == 7){
      if (!_inTrigger){
        ssNoteData.levelCmdValue(_currentBank, _currentNoteTrack, 0, MAXSTEPS*2, 1, 2, 127, 0);      // maximize
        ssFileHelper_makeFileDirty(34);
      }
    }    
    // handle SHIFT+WFunc+Select_0 = Fill Track
    if (inShift && ctrl == 6 && select == 0){
      if (ssSettings_getBankLength(_currentBank) < 9){  // the biggest fill is one 8 bar copy into in 16 bars; so if length is greater than 8 bars do nothing
        if (_inTrigger){
          // SSTrigData::duplicateStepsByTrack(byte bank, byte track, byte start, byte numOfSteps, byte numOfCopies)
          ssTrigData.duplicateStepsByTrack(_currentBank,_currentTriggerTrack,0,ssSettings_getBankLength(_currentBank) * 16, MAXSTEPS / (ssSettings_getBankLength(_currentBank) * 16) - 1);
        } else {
          // SSNoteData::duplicateStepsByTrack(byte bank, byte track, byte start, byte numOfSteps, byte numOfCopies)
          ssNoteData.duplicateStepsByTrack(_currentBank,_currentNoteTrack,0,(ssSettings_getBankLength(_currentBank) * 16)*2, MAXSTEPS / (ssSettings_getBankLength(_currentBank) * 16) - 1);
        }
        ssFileHelper_makeFileDirty(35);
      }
    }
    // handle SHIFT+WFunc+Select_1 = Fill Drums (fill bank but trigger only)
    if (inShift && ctrl == 6 && select == 1){
      if (ssSettings_getBankLength(_currentBank) < 9){  // the biggest fill is one 8 bar copy into in 16 bars; so if length is greater than 8 bars do nothing
        ssTrigData.duplicateStepsByBank(_currentBank,0,ssSettings_getBankLength(_currentBank) * 16, MAXSTEPS / (ssSettings_getBankLength(_currentBank) * 16) - 1);
        ssFileHelper_makeFileDirty(36);
      }
    }  
    // handle SHIFT+WFunc+Select_2 = Fill Bank
    if (inShift && ctrl == 6 && select == 2){
      if (ssSettings_getBankLength(_currentBank) < 9){  // the biggest fill is one 8 bar copy into in 16 bars; so if length is greater than 8 bars do nothing
        ssTrigData.duplicateStepsByBank(_currentBank,0,ssSettings_getBankLength(_currentBank) * 16, MAXSTEPS / (ssSettings_getBankLength(_currentBank) * 16) - 1);
        ssNoteData.duplicateStepsByBank(_currentBank,0,(ssSettings_getBankLength(_currentBank) * 16)*2, MAXSTEPS / (ssSettings_getBankLength(_currentBank) * 16) - 1);
        ssFileHelper_makeFileDirty(37);
      }
    }
    // handle SHIFT+WFUNC+Select_4 = Copy Track
    if (inShift && ctrl == 6 && select == 4){
      ssDisplayUI_loadPanelPage(COPYTRACK);
    }
    // handle SHIFT+WFUNC+Select_5 = Copy Track
    if (inShift && ctrl == 6 && select == 5){
      ssDisplayUI_loadPanelPage(COPYDRUMS);
    }
    // handle SHIFT+WFUNC+Select_6 = Copy Bank
    if (inShift && ctrl == 6 && select == 6){
      ssDisplayUI_loadPanelPage(COPYBANK);
    }
  
// **
// ** BLUE ctrl button - ctrl == 7
// **
    // handle Robot = Robot 1 state/settings
    if (!inShift && ctrl == 7 && NOSELBTN){    
      ssDisplayUI_loadPanelPage(ROBOTPAGE1);
    }   
    if (inShift && ctrl == 7 && NOSELBTN){          
      ssDisplayUI_loadPanelPage(ROBOTPAGE2);
    }   
    // **
    // ** Panel Key State Reset
    // **    
    if (NOSELBTN){
      _inErase = false;
      _inRatchet = false;
      if (_inKeyboard){
        ssDisplay_exitKeyboard();
        _inKeyboard = false;
      }
    }
    break;

  // *******************************
  // *
  // *  COPYTRACK ACTIONS
  // *
  // *******************************
  case COPYTRACK:  
  
    // **
    // ** SELECT BUTTONS
    // **
    if (!inShift && NOCTRLBTN && (select < 16)){                                                       // NOCTRLBTN is shorthand for ctrl == NOBUTTON
      if (_showSuperTriggerUI){
        if (!(select == _currentTriggerTrack && _bankTrackCopyBank == _currentBank)){                 // avoid copying bank.track to same bank/track
          copyTrack(_currentBank, _currentTriggerTrack, _bankTrackCopyBank,select);
        }
      } else if (_inTrigger){ 
        if (!(select - 8 == _currentTriggerTrack && _bankTrackCopyBank == _currentBank) && (select > 7)){    // avoid copying bank/track to same bank/track; have to select a trigger track, so select 0-7 is invalid
          copyTrack(_currentBank, _currentTriggerTrack, _bankTrackCopyBank, select - 8);
        }
      } else {
        if (!(select == _currentNoteTrack && _bankTrackCopyBank == _currentBank) && (select < 8)){    // avoid copying bank/track to same bank/track; have to select a note track, so select 8 - 15 is invalid
          copyTrack(_currentBank, _currentNoteTrack, _bankTrackCopyBank, select);
        }
      }
      ssDisplayUI_loadPanelPage(DEFAULT);
    }
    
    // **
    // ** SELECT BANK BUTTONS
    // **    
    if (!inShift && NOCTRLBTN && select>15 && select<20){
      if (select - 16 != _bankTrackCopyBank){
        _bankTrackCopyBank = select - 16;
        ssDisplayUI_updatePanelPage(COPYTRACK);
      }
    }

    break;

  // *******************************
  // *
  // *  COPYBANK ACTIONS
  // *
  // ******************************* 
  case COPYBANK:
  case COPYDRUMS:
  
    // **
    // ** SELECT BANK BUTTONS
    // **
    if (!inShift && NOCTRLBTN && select>15 && select<20){
      if (select - 16 != _currentBank){
        ssClockHelper_stop();
        ssMidiHelper_killAllOutNotes(SEQ);
        ssTrigData.copyBankToBank(_currentBank,select - 16);
        if (!_copyDrumsBank) { ssNoteData.copyBankToBank(_currentBank,select - 16); }    // copy bank is not Async so stop the clock
        if (_inPlay) { ssClockHelper_start(); }
        ssFileHelper_makeFileDirty(38);
      }
      ssDisplayUI_loadPanelPage(DEFAULT);
    }
    break;
    
  // *******************************
  // *
  // *  PATCHSELECT ACTIONS
  // *
  // ******************************* 
  case PATCHSELECT:
    if (ctrl == 5 && NOSELBTN && _inLock == PATCHLOCK){  // leave patch lock
        ssDisplayUI_gotoLock(NOLOCK);
        ssDisplayUI_loadPanelPage(DEFAULT);
    }
    // handle SHIFT+Midi+SelectBank_* = select different Patch Bank
    if (select > 15 && select <20){
      if (!_inTrigger){
        if (inShift){
          _currentPatchBank = (select - 12);
        } else {
          _currentPatchBank = (select - 16);
        }
        ssDisplayUI_updatePanelPage(PATCHSELECT);    
      }
    }
    // handle SHIFT+Midi+Select_* = select Patch ( * PatchBank)
    if (select < 16){
      if (!_inTrigger){
        ssMidiHelper_handlePatchChange(select + _currentPatchBank*16, true);
        ssDisplayUI_gotoLock(NOLOCK);
        /*
        char tmp[17] = "Change: ";
        char tmpVal[5];
        itoa(select + _currentPatchBank*16,tmpVal,10);
        strcat(tmp,tmpVal);
        ssDisplayUI_showPopupMessage(str_SENTPATCH,tmp,3); 
        */
      }
    }
    break;
    
  // *******************************
  // *
  // *  NOTEMIDIMAP ACTIONS
  // *
  // ******************************* 
  case NOTEMIDIMAP:
    // handle Midi+Select_* = toggle MIDI channel
    if (!inShift && ctrl == 5 && select < 20){
      if (select < 16) {
        if (_inTrigger){
          ssSettings_toggleMidiChannelForTriggerTrack(select + (_currentMidiPort * 16), _currentTriggerTrack, ssSettings_getGroupDrumMidi());
        } else {
          ssMidiHelper_killTrackOutNotes(_currentNoteTrack, SEQ);
          ssSettings_toggleMidiChannelForNoteTrack(select + (_currentMidiPort * 16), _currentNoteTrack);
        }
      } else {
        if (select == 16) { _currentMidiPort = 0; }
        else if (select == 17) { _currentMidiPort = 1; }
      }
      ssDisplayUI_updatePanelPage(NOTEMIDIMAP);
    }
    if (NOCTRLBTN){
      ssDisplayUI_loadPanelPage(DEFAULT);    
    }   
    break;    
  // *******************************
  // *
  // *  DMAPSELECT ACTIONS
  // *
  // *******************************  
  case DMAPSELECT:
    if (inShift && ctrl == 5 && select < 8){
      ssSettings_handleDrumMapSelect(select);
    }
    if (NOCTRLBTN){
      ssDisplayUI_loadPanelPage(DEFAULT);    
    }
    break;    
  // *******************************
  // *
  // *  BARJUMP ACTIONS
  // *
  // ******************************* 
  case BARJUMP:
    // handle Bar+Select_* = jump to selected bar
    if (!inShift && ctrl == 2 && select < 16){
      ssClockHelper_jumpToBar(select);
      ssDisplayUI_updatePanelPage(BARJUMP);
    } 
    if (NOCTRLBTN){
        ssDisplayUI_loadPanelPage(DEFAULT);    
    }   
    break;  
  // *******************************
  // *
  // *  BARLENGTH ACTIONS
  // *
  // *******************************     
  case BARLENGTH:
    // handle SHIFT+Bar+Select_* = change length
    if (inShift && ctrl == 2 && select <16){
      ssSettings_setBankLength(_currentBank,select + 1);
      if ((_currentStep >  ssSettings_getBankLength(_currentBank) * 16) && _activeRobot != 3) {
        ssClockHelper_jumpToBar(0);
      }
      ssDisplayUI_updatePanelPage(BARLENGTH);
    }
    if (NOCTRLBTN){
        ssDisplayUI_loadPanelPage(DEFAULT);    
    }   
    break;   
  // *******************************
  // *
  // *  STEPJUMP ACTIONS
  // *
  // *******************************
  case STEPJUMP:
    // handle Step+Select_* = jump to selected step
    if (!inShift && ctrl == 3 && select < 16){
      ssClockHelper_jumpToSubStep(select);
      ssDisplayUI_updatePanelPage(STEPJUMP);
    }  
    if (NOCTRLBTN){
        ssDisplayUI_loadPanelPage(DEFAULT);    
    }   
    break;         
  // *******************************
  // *
  // *  STEPEDIT ACTIONS
  // *
  // *******************************
  case STEPEDIT:
    processDefaultSelectSlides(select, ctrl, inShift);        // these enable track slide and select to still function while in lock
    processDefaultSelectBtns(select, ctrl,inShift);
    ssStepEdit_handleSelectBtn(select, ctrl,inShift);   
    
    if (((ctrl < 8 && ctrl != 3) || (inShift && ctrl == 3)) && NOSELBTN && _inLock == 3){    // if a ctrl button other than step is pressed or shift+step, exit step edit 
      ssStepEdit_leaveStepEditPage();
      ssDisplayUI_gotoLock(0);
      ssDisplayUI_loadPanelPage(DEFAULT);
    }    
    break;

  
  // *******************************
  // *
  // *  SOLOPAGE ACTIONS
  // *
  // *******************************
  case SOLOPAGE:
    // handle Solo+Select_* = toggle track solo
    processDefaultSelectSlides(select, ctrl, inShift);         // these enable track slide and bank select to still function while in lock
    processDefaultBankButtons(select, ctrl, inShift);
    
    if ((!inShift && ctrl == 0 && select < 16 && _inLock == 0) || (!inShift && NOCTRLBTN && select < 16 && _inLock == 1)){
      if (_showSuperTriggerUI){
        ssMuteSolo_toggleSoloTriggerTrack(_muteSoloEditBank,select);
      } else {
        if (select < 8){
          ssMuteSolo_toggleSoloNoteTrack(_muteSoloEditBank,select);
        } else {
          ssMuteSolo_toggleSoloTriggerTrack(_muteSoloEditBank,select - 8);  
        }
      }
      ssDisplayUI_updatePanelPage(SOLOPAGE);
      ssFileHelper_makeFileDirty(39);
    } 

    // handle Solo+Bank_* = solo cmds
    if (!inShift && ctrl == 0 && select > 15 && select < 20){
      switch (select){
        case 16:
          ssMuteSolo_soloAllNoteTracks(_muteSoloEditBank);
          break;
        case 17:
          ssMuteSolo_soloAllTriggerTracks(_muteSoloEditBank);
          break;
        case 18:
          ssMuteSolo_soloAllTracks(_muteSoloEditBank);
          break;
        case 19:
          ssMuteSolo_clearAllSolo(_muteSoloEditBank);
          break;
      }
      ssDisplayUI_updatePanelPage(SOLOPAGE);
      ssFileHelper_makeFileDirty(40);
    }
     
    // handle SHIFT+Solo while in Solo Lock = unlock solo
    if (inShift && ctrl == 0 && NOSELBTN && _inLock == 1){
      ssDisplayUI_gotoLock(0);
      _muteSoloEditBank = _currentBank;
      ssDisplayUI_loadPanelPage(DEFAULT);
    }    
    if (NOCTRLBTN && _inLock != 1){
      _muteSoloEditBank = _currentBank;
      ssDisplayUI_loadPanelPage(DEFAULT);    
    }   
    break; 
  // *******************************
  // *
  // *  MUTEPAGE ACTIONS
  // *
  // *******************************
  case MUTEPAGE:
    // handle Mute+Select_* = toggle track mute
    processDefaultSelectSlides(select, ctrl, inShift);        // these enable track slide and bank select to still function while in lock
    processDefaultBankButtons(select, ctrl, inShift);
    
    if ((!inShift && ctrl == 1 && select < 16 && _inLock == 0) || (!inShift && NOCTRLBTN && select < 16 && _inLock == 2)){
      if (_showSuperTriggerUI){
        ssMuteSolo_toggleMuteTriggerTrack(_muteSoloEditBank,select);
      } else {
        if (select < 8){
          if (_muteSoloEditBank == _currentBank) { ssMidiHelper_killTrackOutNotes(select,SEQ); }
          ssMuteSolo_toggleMuteNoteTrack(_muteSoloEditBank,select);
        } else {
          ssMuteSolo_toggleMuteTriggerTrack(_muteSoloEditBank,select - 8);  
        }
      }
      ssDisplayUI_updatePanelPage(MUTEPAGE);
      ssFileHelper_makeFileDirty(41);
    }  

    // handle Mute+Bank_* = mute cmds
    if (!inShift && ctrl == 1 && select > 15 && select < 20){
      switch (select){
        case 16:
          ssMuteSolo_muteAllNoteTracks(_muteSoloEditBank);
          if (_muteSoloEditBank == _currentBank) { ssMidiHelper_killAllOutNotes(SEQ); }
          break;
        case 17:
          ssMuteSolo_muteAllTriggerTracks(_muteSoloEditBank);
          break;
        case 18:
          ssMuteSolo_muteAllTracks(_muteSoloEditBank);
          if (_muteSoloEditBank == _currentBank) { ssMidiHelper_killAllOutNotes(SEQ); }
          break;
        case 19:
          ssMuteSolo_clearAllMute(_muteSoloEditBank);
          break;
      }
      ssDisplayUI_updatePanelPage(MUTEPAGE);
      ssFileHelper_makeFileDirty(42);
    }

    
    // handle SHIFT+Mute while in Mute Lock = unlock mute
    if (inShift && ctrl == 1 && NOSELBTN && _inLock == 2){
      ssDisplayUI_gotoLock(0);
      _muteSoloEditBank = _currentBank;
      ssDisplayUI_loadPanelPage(DEFAULT);
    }
    if (NOCTRLBTN && _inLock != 2){
      _muteSoloEditBank = _currentBank;
      ssDisplayUI_loadPanelPage(DEFAULT);    
    }   
    break; 

  // *******************************
  // *
  // *  FILEPAGE ACTIONS
  // *
  // *******************************
  case FILEPAGE:
    if (ctrl != 4 && !NOCTRLBTN){                                // if in the filepage and you press a CTRL button, treat that as a cancel, leave file and resubmit the button action
      ssDisplayUI_loadPanelPage(DEFAULT);
      ssUIHandler_handleSelectButton(select, ctrl, inShift);  
    }
    break;
  // *******************************
  // *
  // *  SAVEDMAP ACTIONS
  // *
  // *******************************
  case SAVEDMAP:
    if (!inShift && NOCTRLBTN && select < 8){        // selected a storage slot 1 - 8
      ssSettings_saveDrumMapIntoSlot(select);
      ssDisplayUI_loadPanelPage(DEFAULT);
    }
    break;

  // *******************************
  // *
  // *  ROBOT ACTIONS
  // *
  // ******************************* 
  case ROBOTPAGE1:
  case ROBOTPAGE2:
    processDefaultRobotButtons(select, ctrl, inShift);
    break;
  case STEPRECORD:                                    // this is so step record can us the note length options
    if (ctrl == 7 && select < 16){
      ssRobot_handleSelectBtn(select, ctrl, inShift);
    } 
    break;    
  case ROBOTCOMPLEX:
  case ROBOTPROB:
  case ROBOTSCALE:
  case ROBOTCHORD:
  case ROBOTPLEN:
  // handle Blue+Select_* = edit settings
    if (select < 16){                                                  // handle "quick value" - using select buttons to pick a value or moving between robot settings
      ssRobot_handleSelectBtn(select, ctrl, inShift);
    } else if ((!inShift && !NOCTRLBTN) || (select > 15 && select < 20)) {          // pressing any CTRL key or pressing bank silently exits ROBOT settings
      ssDisplayUI_loadPanelPage(DEFAULT);
      ssUIHandler_handleSelectButton(select, ctrl, inShift);
    } 
    break;  
  // *******************************
  // *
  // *  VELOCITY MAPS ACTIONS
  // *
  // ******************************* 
  case VMAPHIT:
  case VMAPACCENT:
    if (!inShift && ctrl == 4 && select == 14){
      if (_inTrigger){
        ssDisplayUI_loadPanelPage(VMAPHIT);
      }
    } else if (!inShift && ctrl == 4 && select == 15){
      if (_inTrigger){
        ssDisplayUI_loadPanelPage(VMAPACCENT);
      }
    } else {
      processDefaultSelectBtns(select, ctrl, inShift);
      processDefaultSelectSlides(select, ctrl, inShift);
      if (_inTrigger){
        ssDisplayUI_loadPanelPage(_panelPage);
      } else {
        ssDisplayUI_loadPanelPage(DEFAULT);
      }
    }
    if (!NOCTRLBTN && ctrl != 4 && NOSELBTN){  
      ssDisplayUI_loadPanelPage(DEFAULT);
      ssUIHandler_handleSelectButton(select, ctrl, inShift);     
    }
    break;
  // *******************************
  // *
  // *  SETSHORTCUT ACTIONS
  // *
  // ******************************* 
  case SETSHORTCUT:
    if (select < 16){
      ssSettings_handleShortcutSelectBtn(select, inShift);
    }
  }
}



// **
// ** TRANSPORT BUTTONS
// **
void ssUIHandler_handleAuxButton(byte button, bool inShift){
  if (button == GRNBTN) {
    ssClockHelper_handlePlayButton(inShift);
  }
  if (button == REDBTN) {
    ssClockHelper_handleRecordButton(inShift);
  }
  if (button == BLKBTN) {
    if (inShift){
      ssDisplayUI_loadPanelPage(DEFAULT);                     // SHIFT+Black Btn = Back to DEFAULT
    } else {
      ssClockHelper_handleStopButton(inShift);
    }
  }
  switch (_panelPage){
    case ROBOTCOMPLEX:
    case ROBOTPROB:
    case ROBOTSCALE:
    case ROBOTCHORD:
    case ROBOTPLEN:
      ssRobot_robotPageExit(NOBUTTON, NOBUTTON, inShift);
      break;
  }  
}

// **
// ** TRIGGER BUTTONS
// **
void ssUIHandler_handleTrigButton(byte btn, bool state, bool inShift){
  switch (_panelPage){
    case STEPRECORD:
      if (btn == TRIGBTN0){
        ssSequencer_handleStepRecTie(state);
      } else if (btn == TRIGBTN1 && state == ON){   // rest
        ssSequencer_handleStepRecRest();
      }
      break;    
    case ROBOTCOMPLEX:
    case ROBOTPROB:
    case ROBOTSCALE:
    case ROBOTCHORD:
    case ROBOTPLEN:
      ssRobot_robotPageExit(NOBUTTON,NOBUTTON,inShift);
      // no break - purposely fall through
    default:
      if (btn == TRIGBTN1 && state == ON){
        ssSequencer_handleTriggerHit(inShift);
      } else if (btn == TRIGBTN0){
        if (state){
          if (inShift){
            _inFill = 2;
          } else {
            _inFill = 1;
          }
        } else {
          _inFill = 0;
        }
      }    
  }    
}

// **
// ** KNOB TURN/BUTTON
// **
void ssUIHandler_handleKnobButton(bool isDown,bool inShift) {   // knob button acts like a cancel button
  switch (_panelPage){
    case DEFAULT:
    case SETSHORTCUT:
      ssSettings_handleKnobPushShortcuts(isDown, inShift);
      break;
    case SETTINGS:
      ssSettings_handleKnobPush(isDown, inShift);
      break;
    case FILEPAGE:
    case RESTOREPAGE:
      ssFileHelper_handleKnobBtnEvent(isDown,inShift);
      break;    
    case SAVEDMAP:
    case COPYBANK:
    case COPYTRACK:
    case SWINGVALUE:
      if (isDown) { ssDisplayUI_loadPanelPage(DEFAULT); }    // exit with current values
      break;
    case ROBOTSCALE:
    case ROBOTPROB:
    case ROBOTCOMPLEX:
    case ROBOTCHORD:
    case ROBOTPLEN:
      ssRobot_handleKnobButton(isDown,inShift);
      break;
    case STEPEDIT:
      ssStepEdit_handleKnobButton(isDown,inShift);
      break;
    case VMAPHIT:
    case VMAPACCENT:
      ssSequencer_handleKnobButton(isDown,inShift);
      break;
    case STEPRECORD:
      if (isDown) { 
        _inStepRec = false;
        ssDisplayUI_loadPanelPage(DEFAULT); 
      }    // cancel out
      break;
    case PATCHSELECT:
      if (isDown) { 
        ssDisplayUI_gotoLock(NOLOCK);
        ssDisplayUI_loadPanelPage(DEFAULT);
      }
      break;
  }
}
void ssUIHandler_handleKnobRotate(int delta, bool inShift) {
  switch(_panelPage){
    case DEFAULT:
      ssClockHelper_handleKnobTurn(delta);    // clockHelper handles tempo change
      break;
    case SWINGVALUE:
      ssSettings_handleKnobTurnShortcuts(delta);
      break;
    case SETTINGS:
      ssSettings_handleKnobTurn(delta);
      break;
    case FILEPAGE:
    case RESTOREPAGE:
      ssFileHelper_handleKnobTurnEvent(delta);
      break;
    case ROBOTSCALE:
    case ROBOTPROB:
    case ROBOTCOMPLEX:
    case ROBOTCHORD:
    case ROBOTPLEN:
      ssRobot_HandleKnobTurn(delta, inShift);
      break;
    case STEPEDIT:
      ssStepEdit_HandleKnobTurn(delta);
      break;
    case VMAPHIT:
    case VMAPACCENT:
      ssSequencer_HandleKnobTurn(delta, inShift);
      break;      
    case PATCHSELECT:
      ssMidiHelper_handlePatchChangeKnobRotate(delta);
      break;
  }
}

// **
// ** DEFAULT SELECT SLIDES
// **
void processDefaultSelectBtns(byte select, byte ctrl, bool inShift){
    // handle Select_* button only = changing track
    if (!inShift && NOCTRLBTN && (select < 16)){                                                       // NOCTRLBTN is shorthand for ctrl == NOBUTTON

      if (_inTrigger && _showSuperTriggerUI && (select == _currentTriggerTrack)) { return; }           // user just selected current track so do nothing
      if (_inTrigger && !_showSuperTriggerUI && (select - 8 == _currentTriggerTrack)) { return; }      // user just selected current track so do nothing
      if (!_inTrigger && (select == _currentNoteTrack)){ return; }                                     // user just selected current track so do nothing
  
      if (_showSuperTriggerUI){
          _currentTriggerTrack = select;
          _inTrigger = true;
      } else {
        if (select > 7) {                     // trigger track
          _currentTriggerTrack = select - 8;
          _inTrigger = true;
        } else {                              // note track
          _currentNoteTrack = select;
          _inTrigger = false;
        }
      }
      ssDisplay_handleTrackChange();
      if (_panelPage == STEPEDIT){ ssStepEdit_showStepEditLeds(); }
    }  
}
void processDefaultSelectSlides(byte select, byte ctrl, bool inShift){
    // handle SHIFT+Select_14 = slide virtual tracks left
    if (inShift && NOCTRLBTN && select == 14 && _showSuperTriggerUI) { 
      _showSuperTriggerUI = false;
      ssPanel.slideRight(ROW_YLW);
      ssDisplayUI_updateTrackDisplay();
    }
    // handle SHIFT+Select_15 = slide virtual tracks right
    if (inShift && NOCTRLBTN && select == 15 && !_showSuperTriggerUI) { 
      _showSuperTriggerUI = true;
      ssPanel.slideLeft(ROW_YLW);
      ssDisplayUI_updateTrackDisplay();
    }
}
// **
// ** DEFAULT SELECT BANK BUTTONS
// **
void processDefaultBankButtons(byte select, byte ctrl, bool inShift){
    // handle Bank_* = change bank on next loop
    if (!inShift && NOCTRLBTN && select>15 && select<20){

      byte selectedBank = select - 16;
      if (selectedBank != _currentBank){
        if (_inPlay){
          if (selectedBank == _nextBank){ 
            ssSequence_cancelBankChange();        
          } else {
            _nextBank = selectedBank;
            ssDisplayUI_updateBankDisplay();
          }
        } else {
          ssSequence_changeBank(selectedBank);
        }
      } else {                                      // another way to cancel bank change
        ssSequence_cancelBankChange();
      }
      
    }
    // handle SHIFT+Bank_* = change bank now
    if (inShift && NOCTRLBTN && select>15 && select<20){    
      byte bank = select - 16;
      if (bank != _currentBank){
          ssSequence_changeBank(bank);
      }
    }
}

// **
// ** DEFAULT SELECT BANK BUTTONS
// **
void processDefaultRobotButtons(byte select, byte ctrl, bool inShift){
  // handle Blue+Select_* = edit settings
  if (ctrl == 7 && select < 16){
    ssRobot_handleSelectBtn(select, ctrl, inShift);
  } 
  if (ctrl == 7 && select > 15 && select <20){
    ssRobot_handleBankBtn(select, inShift);
  }     
  if (ctrl != 7){
      ssDisplayUI_loadPanelPage(DEFAULT);    
  } 
}  
// *******************************
//
//       DEBUG
//
// *******************************

void DEBUG_showSelectButtonEvent(byte button, byte ctrl, bool inShift){
  Serial.print(inShift);
  Serial.print(F("-"));
  Serial.print(ctrl);
  Serial.print(F("-"));
  Serial.println(button);
}
