



// handle midi input

void ssTuring_handleMidiNoteOn(KeyInputState kis){
  buildTuringCustomScale(kis.note, kis.velocity, true); 
  //ssTuring_DEBUG_printTuringArray();
}
void ssTuring_handleMidiNoteOff(KeyInputState kis){
  RobotSettings tbotSettings = ssSettings_getRobotSettings();

  if (!tbotSettings.keyLatch) {
      turnOffCurrentTuringNote();
      buildTuringCustomScale(kis.note,kis.velocity,false); 
  }
}
void buildTuringCustomScale(byte note, byte velocity, bool noteOn){
  KeyInputState kis;
  byte scaleCount = 0;
  byte interval = 0;
  mCurrentTuringRootNote = 0xFF;
  for (byte i=0;i<128;i++){
    kis = ssMidiHelper_getKeyInputNoteState(i);
    if (kis.handler == TURING && (noteOn || (i != note))){         // the i!=note||noteOn is because at this point KeyInputNoteState has not been updated yet. so don't include the released note in the scale
      if (scaleCount == 0) {
        mCurrentTuringRootNote = i;
        mCurrentTuringRootVelocity = velocity;
        scalesToInterval[12][scaleCount + 1][0] = 0;
        scalesToInterval[12][scaleCount + 1][1] = 20;
      } else {
        interval = (i - mCurrentTuringRootNote);       
        scalesToInterval[12][scaleCount + 1][0] = interval;
        scalesToInterval[12][scaleCount + 1][1] = 10;
      }
      scaleCount++;
    }
  }
  if (ssSettings_getRobotSettings().scale == 12){
    scalesToInterval[12][0][0] = scaleCount;
    scalesToInterval[12][0][1] = scaleCount * 10 + 10;
    mTuringScaleIndex = 0;
    mTuringIndex = 1;
  }

  // mTuringScaleIndex = 0;
}

void ssTuring_DEBUG_printTuringArray(){
    RobotSettings tbotSettings = ssSettings_getRobotSettings();
    Serial.print(mCurrentTuringRootNote);Serial.print("::");
    for (byte s=0;s<getPatternSteps();s++){
      Serial.print(mTuringArray[s]);Serial.print(",");
    }
    Serial.println();
}
// handle output
void ssTuring_playbackStep(byte bank, byte step, bool inHalfStep){                            // inHalfStep means it is a 1/32 note between 1/16 note steps
  RobotSettings tbotSettings = ssSettings_getRobotSettings();
  if (_activeRobot != 1) return;
  if (bank != mTuringBank) { return; }
  if (mCurrentTuringRootNote == 0xFF ) return; 

  if (tbotSettings.noteType > 4){ return; }                                                   // Rhythm 13 (which doesn't work in turing) or Rhythm Off, don't play
  
  bool inStacato = false;
  if (tbotSettings.noteLength == 1) inStacato = true;                                          // inStacato
  byte noteLenSteps = 1 << (4 - tbotSettings.noteType);
  
  if (inHalfStep){
    if (inStacato && (noteLenSteps == 1) && (mLastTuringNote < ROBOTREST) && (getTuringNextNote() != ROBOTTIE)) {      // if playing 1/16 notes and stacato and next note is not a Tie then we cut the note off on the FALL
      turnOffCurrentTuringNote(true);
    }
    return;
  }

  if (inStacato && (noteLenSteps > 1) && (step % noteLenSteps == noteLenSteps/2) && (mLastTuringNote < ROBOTREST) && (getTuringNextNote() != ROBOTTIE)) {    // if stacato and we are half way though the note length
    turnOffCurrentTuringNote();
    return;                                                                                                           // only play turing notes on note type (in robot settings), we are only 1/2 way there
  } 

  if (step % noteLenSteps != 0) {  
    return;                                                                                                           // return on any other "wrong" step - only play turing notes on note type (in robot settings)
  }    

  if ((mLastTuringNote < ROBOTREST) && (getTuringNextNote() != ROBOTTIE)){
    turnOffCurrentTuringNote(); 
  }

  // update turingArray
  if (!_inRatchet) { updateTuringArray(); }
  byte currentNote = getTuringCurrentNote();
  switch (currentNote){
    case ROBOTTIE:     // tie
      playTuringNote(true);                                             // true mean this doesn't acually play the note (it is already playing) but it updated the recording to add the tie
      mLastTuringNote = ROBOTTIE;
      break;
    case ROBOTREST:     // rest
      // note off
      mLastTuringNote = ROBOTREST;
      break;
    default:      // note
      mLastTuringNote = currentNote;
      mLastTuringNote = mLastTuringNote + mCurrentTuringRootNote - 12;
      if (mLastTuringNote > 127) {
        mLastTuringNote = 0xFF;
      }

      playTuringNote(false);
      
      if (mLastTuringNote == 0xFF) mLastTuringNote = ROBOTREST;

      break;
  }
  //ssTuring_DEBUG_printTuringArray();
}
byte getTuringNextNote(){
  byte nn = mTuringArray[mTuringIndex];
  if (nn == 0xFF) nn = ROBOTREST;
  return nn;
}
byte getTuringCurrentNote(){
  RobotSettings tbotSettings = ssSettings_getRobotSettings();

  byte ni = mTuringIndex;
  if (ni == 0)  ni = getPatternSteps();
  ni = ni - 1;

  byte nn = mTuringArray[ni];
  if (nn == 0xFF) { nn = ROBOTREST; }
  return nn;
}
void playTuringNote(bool isTie){
  if (!ssMuteSolo_trackFilter(_currentBank, mTuringTrack)) { return; }      // TODO: doing it this way means Muted tracks will not get recorded. Is that right?
  if (mLastTuringNote == 0xFF || isTie) { return; } 
  
  ssMidiHelper_sendTrackNote(mTuringTrack,  mLastTuringNote, mCurrentTuringRootVelocity, ON, SEQ);
  mLastTuringPlayedNote = mLastTuringNote;
  if (_inRec && ssTuring_onTuringTrack()) {
    ssNoteData.addEvent(_currentStep*2,_currentBank,mTuringTrack,1,mLastTuringNote,mCurrentTuringRootVelocity, false); 
    mLastTuringNoteRecorded = true;
    ssFileHelper_makeFileDirty(21);
  } else {
    mLastTuringNoteRecorded = false;
  }
}

byte updateTuringArray(){
  // pick a note in the key of C based on scale setting, octave range, probability and complexity; note is 0 - 127, 128 = rest , 129 = tie
  mTuringIndex++;
  if (mTuringIndex >= getPatternSteps()) {
    mTuringIndex = 0;
  }
  
  if ((mTuringArray[mTuringIndex] == 0xFF) || askTuring()) {
      mTuringArray[mTuringIndex] = getTuringNote();
  }

  return mTuringArray[mTuringIndex];
}
byte getPatternSteps(){
  return ssSettings_getRobotSettings().patternLen / (1 << (4 - ssSettings_getRobotSettings().noteType)) * 16;
}
byte getTuringNote(){
  RobotSettings tbotSettings = ssSettings_getRobotSettings();

  byte noteType = getTuringNoteType();
  if (noteType > 127) return noteType;

  byte keyNote = 12; // midi C1
  byte scale = tbotSettings.scale;
  byte range = tbotSettings.octaveRange;
  int tmp = range - 1;
  byte rangeDelta = abs(tmp) + 1;

  byte scaleNoteCount = scalesToInterval[scale][0][0];

  byte rangeOffset = 0;
  byte upOrDown = 0;
  switch (tbotSettings.direction) {
    case ROBOTRANDOM:
    case ROBOTRNDWEIGHTED:
      // MODE Random
      // select a random octave within the range to add to the note
      rangeOffset = random(rangeDelta + 1) * 12;
      break;
    case ROBOTUP:
      // MODE = Scale Up
      // range runs up the scale repeating the scale within the sequence count
      rangeOffset = (int(mTuringScaleIndex / scaleNoteCount) %  rangeDelta) * 12;
      break;
    case ROBOTDOWN:
      // MODE = scale down
      rangeOffset = (int((1200 - mTuringScaleIndex) / scaleNoteCount) %  rangeDelta) * 12;
      break;
    case ROBOTEXCLUDE:
      // MODE = scale up/down
      upOrDown = int(mTuringScaleIndex / (scaleNoteCount * rangeDelta)) % 2;
      rangeOffset = int(mTuringScaleIndex / scaleNoteCount) % rangeDelta;
      if (upOrDown == 0) {
        // going up
        // rangeOffset = rangeOffset;
      } else {
        // going down
        rangeOffset = rangeDelta - rangeOffset - 1;
      }
      rangeOffset = rangeOffset * 12;
      break;
  }

  keyNote += rangeOffset; 
  if (range == 0) keyNote -= 12;
         
 // scalesToInterval[scalesValue][index][weight]; index[0][0] = count

  int scaleNote;
  switch (tbotSettings.direction) {
    case ROBOTRANDOM:
    case ROBOTRNDWEIGHTED:
      // MODE Random
      // pick a random interval from the weighted scale
      if (tbotSettings.direction == ROBOTRANDOM) {
        scaleNote = scalesToInterval[scale][random(scaleNoteCount)+1][0];
      }
      else{
        int totalWeight = scalesToInterval[scale][0][1];
        int rndNum = random(totalWeight);
        int runningTotal = 0;
        for (byte b=1;b<scaleNoteCount + 1;b++){
          // go through each note
          runningTotal += scalesToInterval[scale][b][1];    // get running total weight of each note
          if (runningTotal > rndNum) {
            // if running total is bigger than the random number, pick that interval
            scaleNote = scalesToInterval[scale][b][0];
            b = 99;
          }
        }
      }
      break;
    case ROBOTUP:
      // MODE = Scale Up
      // range runs up the scale repeating the scale within the sequence count
      scaleNote = scalesToInterval[scale][(mTuringScaleIndex % scaleNoteCount)+1][0];
      break;
    case ROBOTDOWN:
      // MODE Scale Down
      scaleNote = scalesToInterval[scale][((1200 - mTuringScaleIndex) % scaleNoteCount)+1][0];
      break;
    case ROBOTEXCLUDE:
      // MODE = Scale Up/Down
      // range runs up the scale repeating the scale within the sequence count
      int noteIndex = mTuringScaleIndex % scaleNoteCount;
      if (upOrDown == 0) {
        noteIndex = noteIndex;
      } else {
        noteIndex = scaleNoteCount - noteIndex - 1;
      }

      // scalesToInterval array index off by 1 as first element is scaleNoteCount
      scaleNote = scalesToInterval[scale][noteIndex + 1][0];
      break;
  }
  
  // add the scale interval to the root note
  keyNote += scaleNote;  

  // if we go out of MIDI range (i.e. too high) then just rest
  if (keyNote > 127) { keyNote = 128; }

  // we are going to play a note so increment the scale index
  mTuringScaleIndex++;
  if (mTuringScaleIndex > 1200) { mTuringScaleIndex = 0; }

  return keyNote;
}

byte getTuringNoteType(){
  // 3 possible note types - tie(129), rest(128), note(1)
  byte rtn = 1;
  
  // determine note type based on Complexity knob. 
  byte cmplx = ssSettings_getRobotSettings().complexity + 10;    // 10 - 110
  int noteType = random(100);                                       // 0 - 99
  if (noteType < (55 - cmplx/2)) { rtn =  ROBOTREST; }             // rest    50 - [5-50] = [45 - 0]
  if (noteType > (60 + cmplx/2)) { rtn =  ROBOTTIE; }              // tie     60 + [5-50] = [65 - 110]


  //Serial.print("Complex:");Serial.println(rtn);
  return rtn;
}

bool askTuring(){
  // probknob -- current knob value 0 - 1000

  if (random(100) < ssSettings_getRobotSettings().probability) {
    //Serial.println("turing true");
    return true;
  } else {
    //Serial.println("turing false");
    return false; 
  }  
  
}

void turnOffCurrentTuringNote(){
  turnOffCurrentTuringNote(false);
}
void turnOffCurrentTuringNote(bool outPhase32note){
  ssMidiHelper_sendTrackNote(mTuringTrack,  mLastTuringPlayedNote, 0, OFF, SEQ);
  if (mLastTuringNoteRecorded) {
    int step = _currentStep*2;
    if (outPhase32note) { step++; }
    ssNoteData.addEvent(step,_currentBank,mTuringTrack,2,mLastTuringPlayedNote,0, false); 
    mLastTuringNote = ROBOTREST;
    mLastTuringNoteRecorded = false;
    ssFileHelper_makeFileDirty(22);
  }  
}

void ssTuring_setTuringTrack(byte track){
  mTuringTrack = track;
}
byte ssTuring_getTuringTrack(){
  return mTuringTrack;
}
void ssTuring_begin(){
  for (byte i=0;i<TURINGMAXSTEPS;i++){
    mTuringArray[i] = 0xFF;  
  }
  mTuringTrack = 0xFF;
  mTuringBank = 0xFF;
}
void ssTuring_makeActiveRobot(){
  if (_activeRobot != 1){             // if not already active robot
    mTuringTrack =  _currentNoteTrack;
    mTuringBank = _currentBank;
    RobotSettings rsSettings = ssSettings_getRobotSettings();
    rsSettings.keyLatch = true;
    rsSettings.noteType = 3;
    ssSettings_setRobotSettings(rsSettings);
    _activeRobot = 1; 
  }  
}
void ssTuring_turingModeOff(){
  turnOffCurrentTuringNote();
  ssTuring_begin();
  _activeRobot = 0xFF;
}
bool ssTuring_onTuringTrack(){
  return !_inTrigger && (mTuringTrack == _currentNoteTrack) && (mTuringBank == _currentBank) && _activeRobot == 1;
}

void ssTuring_handleStop(){
  turnOffCurrentTuringNote();
  mCurrentTuringRootNote = 0xFF;
  mTuringIndex = 0;
}

void ssTuring_handlePlay(bool inPlay){
  if (!inPlay){                           // if paused
    turnOffCurrentTuringNote();   
  }
}

void ssTuring_handleRec(bool inRec){
  if (!inRec){
    turnOffCurrentTuringNote();  
  }
}
