/*
 * Tigger API for SS1 sequencer
 */

#ifndef sstrigdata_h
#define sstrigdata_h

#include "Arduino.h"

#define NUMOFTRIGSTEPS 256
#define TRIGDATADWORD uint32_t
#define TRIGSKIPWORD uint16_t
#define NUMOFBANKS 4

struct TrigEvent{
   int step;
   byte bank;
   byte track;
   bool trigger;
   bool accent;
};
	
class SSTrigData
{
  public:

	typedef void (*hStepPlayback)(TrigEvent); 			

  SSTrigData();
	void begin();
	void addEvent(byte bank, byte track, int step, bool trigger, bool accent, bool skip);
	void addEvent(TrigEvent e, bool skip);
	void clearEvents();
	void clearEventsForBank(byte bank);
	void clearEventsForTrack(byte bank, byte track);
	void eraseAtStep(byte bank, byte track, int step);
	void DEBUG_printEventData(byte bank);
	void playbackStep(byte bank, int step);
	void setHandlerStepPlayback(hStepPlayback);
	void duplicateStepsByTrack(byte bank, byte track, byte start, byte numOfSteps, byte numOfCopies);
	void duplicateStepsByBank(byte bank, byte start, byte numOfSteps, byte numOfCopies);
	void copyBankTrackToBankTrack(byte srcBank, byte srcTrack, byte dstBank, byte dstTrack);
	void copyBankToBank(byte srcBank, byte dstBank);
  void * getEventsDataPointer();
  int  getEventDataSize();
  TrigEvent getTrigEvent(byte bank, byte track, byte step);
  void setTrigEvent(TrigEvent e);
  void toggleTrigger(byte bank, byte track, byte step);
  void toggleAccent(byte bank, byte track, byte step);
  void nudgeStep(byte bank, byte track, byte step, int steps);

  void DEBUG_printAtStep(byte bank, byte step);
	
	
	
  private:
	TRIGSKIPWORD	mSkips[NUMOFTRIGSTEPS][NUMOFBANKS];
  TRIGDATADWORD    mEvents[NUMOFTRIGSTEPS][NUMOFBANKS];
	
	void     		mFullClearEvents();
	
	hStepPlayback	raiseStepPlayback;
	
	TrigEvent	mGetTrigEventFromEvents(byte bank, byte track, int step);
	void		    mPutTrigEventInEvents(TrigEvent e);
	void  			mSetSkip(byte bank, byte track, int step);
	
};





#endif
