#include "Arduino.h"
#include "SSTrigData.h"
#include <stdio.h>

/*
#define NUMOFTRIGSTEPS 256
#define TRIGDATADWORD uint32_t

struct TrigEvent{
   int step;
   byte bank;
   byte track;
   bool trigger;
   bool accent;
};
*/

SSTrigData::SSTrigData() { 
	// constructor

}

void SSTrigData::begin(){
	clearEvents();
}
TrigEvent SSTrigData::getTrigEvent(byte bank, byte track, byte step){
  return mGetTrigEventFromEvents(bank, track, step);
}
void SSTrigData::setTrigEvent(TrigEvent e){
  mPutTrigEventInEvents(e);
}
void * SSTrigData::getEventsDataPointer(){
  return &mEvents;
}
int  SSTrigData::getEventDataSize(){
  return sizeof(mEvents);
}
void SSTrigData::toggleTrigger(byte bank, byte track, byte step){
  TrigEvent e = getTrigEvent(bank, track, step);
  e.trigger = !e.trigger;
  if (!e.trigger) { e.accent = false; }
  setTrigEvent(e);   
}
void SSTrigData::toggleAccent(byte bank, byte track, byte step){
  TrigEvent e = getTrigEvent(bank, track, step);
  e.trigger = true;
  e.accent = !e.accent;
  setTrigEvent(e);    
}
void SSTrigData::nudgeStep(byte bank, byte track, byte step, int steps){
  TrigEvent e = getTrigEvent(bank, track, step);
  if (e.trigger){
    eraseAtStep(bank,track,step);
    byte newStep = step + steps;                // because it is a byte it will auto loop; TODO bad?
    e.step = newStep;
    setTrigEvent(e); 
  }
}
void SSTrigData::clearEvents(){
	mFullClearEvents();
 /*
 TRIGDATADWORD tmpArray[] = {16451,0,64,0,68,0,64,0,65,0,64,0,68,4,64,0,67,0,64,0,68,0,64,0,65,0,64,0,68,0,64,0};
  for (int t=0;t<32;t++){
    mEvents[t][0] = tmpArray[t];
  }
  */
}
void SSTrigData::mFullClearEvents(){
	for (byte b=0;b<NUMOFBANKS;b++){
		for (int i=0;i<NUMOFTRIGSTEPS;i++){
			mEvents[i][b] = 0;
			mSkips[i][b] = 0;
		}
	}
}
void SSTrigData::clearEventsForBank(byte bank){
	for (int i=0;i<NUMOFTRIGSTEPS;i++){
		mEvents[i][bank] = 0;
		mSkips[i][bank] = 0;
	}
}
void SSTrigData::clearEventsForTrack(byte bank, byte track){
	TRIGDATADWORD trackMask = (0b11) << (track * 2);
	TRIGSKIPWORD skipMask = 1 << track;
	for (int i=0;i<NUMOFTRIGSTEPS;i++){
		mEvents[i][bank] &= (~trackMask);
		mSkips[i][bank] &= (~skipMask);
	}	
}
void SSTrigData::eraseAtStep(byte bank, byte track, int step){
	TRIGDATADWORD trackMask = 0b11 << (track * 2);
	TRIGSKIPWORD skipMask = 1 << track;

	mEvents[step][bank] &= (~trackMask);
	mSkips[step][bank] &= (~skipMask);
}
void SSTrigData::mSetSkip(byte bank, byte track, int step){
	TRIGSKIPWORD mask = 1 << track;
	mSkips[step][bank] |= mask; 
}
void SSTrigData::addEvent(TrigEvent e, bool skip){
	if (skip) { mSetSkip(e.bank,e.track,e.step); }
	mPutTrigEventInEvents(e);
}
void SSTrigData::addEvent(byte bank, byte track, int step, bool trigger, bool accent, bool skip){
	TrigEvent e;
	e.step = step;
	e.bank = bank;
	e.track = track;
	e.trigger = trigger;
	e.accent = accent;
	addEvent(e,skip);
	
}
void SSTrigData::duplicateStepsByTrack(byte bank, byte track, byte start, byte numOfSteps, byte numOfCopies){
	// go through events steps from start to start + numOfSteps
	int top = start+numOfSteps;
	if (top > NUMOFTRIGSTEPS) { top = NUMOFTRIGSTEPS; }
	for (int s=start;s<top;s++){
		TRIGDATADWORD stepData = mEvents[s][bank];
		if (stepData != 0){
			TrigEvent e = mGetTrigEventFromEvents(bank,track,s);
			for (byte c=1;c<numOfCopies+1;c++){
				if (s + (numOfSteps * c) < NUMOFTRIGSTEPS){
					// addEvents numOfCopies times spaced appropiately
					addEvent(e.bank,e.track,s + (numOfSteps * c),e.trigger,e.accent,false);  // e.skip??
				}
			}
		}
	}	
}
void SSTrigData::duplicateStepsByBank(byte bank, byte start, byte numOfSteps, byte numOfCopies){
	// go through events steps from start to start + numOfSteps
	int top = start+numOfSteps;
	if (top > NUMOFTRIGSTEPS) { top = NUMOFTRIGSTEPS; }
	
	for (int s=start;s<top;s++){
		TRIGDATADWORD stepData = mEvents[s][bank];
		if (stepData != 0){
			for (byte c=1;c<numOfCopies+1;c++){
				if (s + (numOfSteps * c) < NUMOFTRIGSTEPS){
					// addEvents numOfCopies times spaced appropiately
					mEvents[s + (numOfSteps * c)][bank] = stepData;
				}
			}
		}
	}	
}

void SSTrigData::copyBankTrackToBankTrack(byte srcBank, byte srcTrack, byte dstBank, byte dstTrack){
	clearEventsForTrack(dstBank, dstTrack);
	
	for (int s=0;s<NUMOFTRIGSTEPS;s++){
		TRIGDATADWORD stepData = mEvents[s][srcBank];
		if (stepData != 0){
			TrigEvent e = mGetTrigEventFromEvents(srcBank,srcTrack,s);
			addEvent(dstBank,dstTrack,s,e.trigger,e.accent,false);  // e.skip??
		}
	}		
}
void SSTrigData::copyBankToBank(byte srcBank, byte dstBank){
	clearEventsForBank(dstBank);
	
	for (int s=0;s<NUMOFTRIGSTEPS;s++){
		TRIGDATADWORD stepData = mEvents[s][srcBank];
		if (stepData != 0){
			mEvents[s][dstBank] = stepData;
		}
	}			
}

void SSTrigData::playbackStep(byte bank, int step){
	for (int i=0;i<16;i++){
		TRIGSKIPWORD mask = 1 << i;							// create skip mask
	
		if (mSkips[step][bank] & mask){				// if a skip
			mSkips[step][bank] &= ~mask;			// clear the mask
		} else {									// else play the trigger
			TrigEvent e = mGetTrigEventFromEvents(bank, i, step);
			if (e.trigger){
				if (raiseStepPlayback != NULL) { raiseStepPlayback(e); }
			}
		}
	}	
}
TrigEvent SSTrigData::mGetTrigEventFromEvents(byte bank, byte track, int step){

	TrigEvent e;
	e.bank = bank;
	e.track = track;
	e.step = step;
	
	TRIGDATADWORD tdw = mEvents[step][bank];

	e.trigger = tdw & (0b1 << (track * 2));
	e.accent = tdw & (0b1 << (track * 2 + 1));
	
	return e;
}
void SSTrigData::mPutTrigEventInEvents(TrigEvent e){
	TRIGDATADWORD currentStepDword = mEvents[e.step][e.bank];
	
	// clear the two bits for track
	TRIGDATADWORD mask = (0b11) << (e.track * 2);
	currentStepDword &= (~mask);
	
	TRIGDATADWORD newBits = 0b00;
	
	if (e.trigger) { 
		newBits |= 0b01; 
		if (e.accent)  { newBits |= 0b10; }
	}
	
	newBits = newBits << (e.track * 2);
	
	mEvents[e.step][e.bank] = currentStepDword | newBits;
}

void SSTrigData::setHandlerStepPlayback(hStepPlayback h){
		raiseStepPlayback = h;
}


void SSTrigData::DEBUG_printEventData(byte bank){
	Serial.println(F("------------------TRIGDATA START-------------------------------------------"));
	for(int i=0;i<32;i++){
		TRIGDATADWORD tdw = mEvents[i][bank];
		Serial.print(F("Step: "));
		Serial.print(i);
		Serial.print(F("\t data: "));
		Serial.print(tdw, BIN);
		Serial.print(F("\t\t skip:"));
		Serial.println(mSkips[i][bank],BIN);
	}
	Serial.println(F("------------------TRIGDATA END-------------------------------------------"));
}

void SSTrigData::DEBUG_printAtStep(byte bank, byte step){
    TRIGDATADWORD tdw = mEvents[step][bank];
    Serial.print(F("Step: "));
    Serial.print(step);
    Serial.print(F("\t\t data: "));
    Serial.print(tdw, BIN);
    Serial.print(F("\t\t skip:"));
    Serial.println(mSkips[step][bank],BIN);
}
