// STEPEDIT UI
int mEditStep = -1;

void ssStepEdit_showStepEditPage(){
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_STEPEDIT);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(str_SELECTBAR_OPTION);
  ssStepEdit_updateStepEditPage();
  ssDisplayUI_resetBankLEDS();
}
void ssStepEdit_updateStepEditPage(){

  ssDisplayUI_updateStepDisplay();        // this calls ssStepEdit_showStepEditLeds
}
void ssStepEdit_leaveStepEditPage(){
    ssPanel.setLEDBits(ROW_RED,BLINK,0x0);
    mEditStep = -1;
    for (byte b=0;b<4;b++){
      ssPanel.setPoint(ROW_BANKAUX,SOLID,b,OFF);      
      ssPanel.setPoint(ROW_BANKAUX,FASTBLINK,b,OFF);
    }
}

void ssStepEdit_handleSelectBtn(byte select, byte ctrl, bool inShift){
  if (ctrl == 3 && select < 16){
    int cs = _currentStep;
    if (cs == -1) { cs = 0; }
    cs = (cs/16) * 16 + select;

    if (cs == mEditStep){                       // TODO - need to be able to select 1/32 notes
      ssStepEdit_leaveStepEditPage();
    } else {
      mEditStep = cs;
      ssPanel.setLEDBits(ROW_RED,BLINK,0x0);
      ssPanel.setPoint(ROW_RED,BLINK,mEditStep % 16,ON);
      for (byte b=0;b<4;b++){
        ssPanel.setPoint(ROW_BANKAUX,FASTBLINK,b,ON);
      }
    }
  }
  else if (!inShift && (NOCTRLBTN || ctrl == 3) && select > 15 && select < 20 && mEditStep > -1){
    switch (select){
      case 16:              // nudge left
        if (_inTrigger){
          ssTrigData.nudgeStep(_currentBank, _currentTriggerTrack, mEditStep, -1);
        } else {
          ssNoteData.nudgeStep(_currentBank, _currentNoteTrack, mEditStep*2, -2);   // *2 and -2 because recorder runs on 1/32 note steps
        }
        break;
      case 17:              // nudge right
        if (_inTrigger){
          ssTrigData.nudgeStep(_currentBank, _currentTriggerTrack, mEditStep, 1);
        } else {
          ssNoteData.nudgeStep(_currentBank, _currentNoteTrack, mEditStep*2, 2);    // *2 and +2 because recorder runs on 1/32 note steps
        }
        break;
      case 18:              // toggle trigger OR delete step notes for track
        if (_inTrigger){    
          ssTrigData.toggleTrigger(_currentBank, _currentTriggerTrack, mEditStep); 
        } else {
          ssNoteData.eraseAtStep(_currentBank, _currentNoteTrack, mEditStep*2);
        }
        break;
      case 19:              // toggle accent OR 
        if (_inTrigger){    
          ssTrigData.toggleAccent(_currentBank, _currentTriggerTrack, mEditStep);
        } else {
          
        }
        break;
    }
    ssStepEdit_leaveStepEditPage();       // function is named wrong
    ssStepEdit_updateStepEditPage();
  }
}



void ssStepEdit_showStepEditLeds(){
  if (_inTrigger){
    uint16_t grnLeds = 0;
    uint16_t redLeds = 0;
    for (byte s=0;s<16;s++){
      TrigEvent e = ssTrigData.getTrigEvent(_currentBank, _currentTriggerTrack, (_currentStep / 16) * 16 + s);
      redLeds = redLeds << 1;
      grnLeds = grnLeds << 1;
      if (e.trigger){
        redLeds += 1;
      }
      if (e.accent){
        grnLeds += 1;
      }
    }
    ssPanel.setLEDBits(ROW_RED,SOLID,redLeds);
    ssPanel.setLEDBits(ROW_GRN,SOLID,grnLeds);
  } else {
    uint16_t grnLeds = 0;  
    uint16_t redLeds = 0;
    for (byte s=0;s<16;s++){
      byte summary = ssNoteData.getStepSummary(_currentBank, _currentNoteTrack, ((_currentStep / 16) * 16 + s)*2);
      redLeds = redLeds << 1;
      redLeds += (summary & 0x1);
      summary = ssNoteData.getStepSummary(_currentBank, _currentNoteTrack, ((_currentStep / 16) * 16 + s)*2 + 1);
      grnLeds = grnLeds << 1;
      grnLeds += (summary & 0x1);
    }
    ssPanel.setLEDBits(ROW_RED,SOLID,redLeds);
    ssPanel.setLEDBits(ROW_GRN,SOLID,grnLeds);      
  }
}

void ssStepEdit_handleKnobButton(bool isDown, bool inShift){
  if (isDown) {
    ssStepEdit_leaveStepEditPage();
    ssDisplayUI_gotoLock(0);
    ssDisplayUI_loadPanelPage(DEFAULT);
  }
}
void ssStepEdit_HandleKnobTurn(int delta){
  ssClockHelper_advanceBar(delta);
  ssStepEdit_updateStepEditPage();
}
