
#ifndef ssSettings_defs_h
#define ssSettings_defs_h

#include "Arduino.h"

struct TriggerNoteMap{
  byte      note;
  byte      velocity;
  byte      accent;  
};

struct RobotSettings{
  bool keyLatch;        
  byte direction;       // Direction         - UP(0), DOWN(1), INCLUDE(2), EXCLUDE(3), RANDOM(4), RANDOMWEIGHTED (5)
  byte noteType;        // note type/size    - 2^n   0 = 1 (whole), 1 = 2 (half), 2 = 4 (quarter), 3 = 8 (eighth), 4 = 16 (sixteenth)
  byte octaveRange;     // octave range      - 0 = -1 , 1 = 0, 2 = +1, 3 = +2
  byte noteLength;      // note length       - 2^n   0 = 1 (whole), 1 = 2 (half)
  byte probability;     // Probability
  byte complexity;      // Complexity
  byte patternLen;      // Pattern Length
  byte scale;           // Scale
  bool doubleNote;      // Double Note  
  bool transpose ;      // Transpose
  byte chord;           // Chord
};

struct GlobalSettings{
  bool      loadLastBackup;
  int       tempo;                              // default tempo for new projects
  byte      bankLength[4];                      // default bank lengths for new projects
  byte      clockSource;
  bool      recMetroDefault;
  byte      recPitchbendResolution;
  bool      recCCMsg;
  byte      midiInPort;
  byte      midiInChannel;
  uint32_t  midiTrackMap[8];                        // 32 bit byte flag; MSB midi port 1, channel 1 --  TrackMidiMap maps track to midi channels; default for new projects
  uint32_t  midiTriggerMap[16];                     // 32 bit byte flag; MSB midi port 1, channel 1 --  TriggerMidiMap maps trigger track to midi channels; default for new projects
  TriggerNoteMap midiTriggerNoteMap[16];           // note value, velocity, accent velocity  --  NoteMap/VelocityMap trigger track to midi note/velocity; default for new projects
  
  uint32_t  memoryMidiTriggerMap[16][8];          // stored midiTriggerMap maps -- 8 slots of DrumMaps
  TriggerNoteMap memoryTriggerNoteMap[16][8];     // stored NoteMap/Velocity maps -- 8 slots of DrumMaps
  byte      redLedDisplay;         
  bool      confirmDeletes;
  bool      groupDrumMidi;
  bool      portBDrumTrigger;                     // port B as drum trigger
  byte      portBTriggerInNoteMapNote[16];        // note In from port B that maps to track [1-16]
};

struct ProjectSettings{
  char      projectName[15];
  int       tempo;
  bool      swingEnable;
  byte      swing;
  bool      swingType;
  byte      bankLength[4];
  uint32_t  midiTrackMap[8];                  // 32 bit byte flag; MSB midi port 1, channel 1
  uint32_t  midiTriggerMap[16];               // 32 bit byte flag; MSB midi port 1, channel 1
  TriggerNoteMap midiTriggerNoteMap[16];         // note value, velocity, accent velocity  --  default for new projects
  RobotSettings robotSettings;
};




struct SettingTreeNode{
  char    settingName[17];
  byte    type;
  byte    childType;            
  void   (*callFunction)();  
};

#endif
