
#define TREESIZE 16

const SettingTreeNode mSettingTree[] =
  {{"Settings        ",0,10,NULL},
    {"Preferences     ",10,11,NULL},
     {"Grp Drum MIDI ",11,99,showGroupDrumMidi},
     {"Red LED Disply",11,99,showRedLedDisplay},
     {"Confirm Delete",11,99,showConfirmDeletes},
     {"Load Lst Prjct",11,99,showLoadLastBackupSetting},
    {"Midi            ",10,12,NULL},
     {"Midi Inpt Chnl",12,99,showMidiInputChannel},
     {"PrtB Drum Trig",12,99,showPortBDrumTrigger},
    {"Recording       ",10,13,NULL},
     {"Metronome     ",13,99,showRecMetronome},
     {"Rec Pitchwheel",13,99,showRecPitchMessages},
     {"Rec CC Msg    ",13,99,showRecCCMessages},
    {"Clock           ",10,14,NULL},
     {"Clock Source  ",14,99,showClockTypeSetting}};

// IF YOU ADD SETTING ITEMS MAKE SURE TO CHANGE TREESIZE ABOVE

  
GlobalSettings mGlobalSettings;

char  mDefaultFileName = '\0';
int   mMenuIndex;
byte  mMenuTreeIndex;
byte  mCurrentMenuType;
byte  mSettingPage;

//*
//*
//* SETTINGS INIT, SETTINGS SAVE/LOAD
//*
//*
void ssSettings_processPostLoad(){
  ssClockHelper_setTempo(ssSettings_getTempo());            // restore the tempo state  
}
void ssSettings_begin(bool loadGSettings){
  createNewGlobalSettings();
  if (loadGSettings) {
    loadGlobalSettingsFromFile();                   // replace default globalSettings with globalSetting stored on SD card 
  } else {
    saveGlobalSettingsToFile();                     // if we don't load the global settings from the file, then save the coded version to make sure the file version is up to date with the code
  }
}
void createNewGlobalSettings(){

  mGlobalSettings.loadLastBackup = false;
  mGlobalSettings.tempo = 120;
  for (byte i=0;i<4;i++){ mGlobalSettings.bankLength[i] = 2; }
  mGlobalSettings.clockSource = CLOCKTYPE_INTERNAL;
  mGlobalSettings.recMetroDefault = true;
  mGlobalSettings.recPitchbendResolution = 1;
  mGlobalSettings.recCCMsg = true;
  mGlobalSettings.midiInPort = 0;
  mGlobalSettings.midiInChannel = 1;
  mGlobalSettings.redLedDisplay = 3;
  mGlobalSettings.confirmDeletes = true;
  mGlobalSettings.groupDrumMidi = true;
  mGlobalSettings.portBDrumTrigger = false;

  for (byte i=0;i<16;i++){                                                        // this loop sets the default values for midi and trigger maps
    if (i<8){                                                                     // these settgins only have 8 values
      mGlobalSettings.midiTrackMap[i] = 0x80000000 >> i;                          // map 8 note tracks to MIDI port A channel i
    }
    mGlobalSettings.midiTriggerMap[i] = 0x400000;                               // default all trigger channels to MIDI port A channel 10 - 0b00000000010000000000000000000000
    mGlobalSettings.midiTriggerNoteMap[i].note = (i * 2) + 48;
    mGlobalSettings.midiTriggerNoteMap[i].velocity = 100;
    mGlobalSettings.midiTriggerNoteMap[i].accent = 127;
    for (byte memslot=0;memslot<8;memslot++){
      mGlobalSettings.memoryMidiTriggerMap[i][memslot] = 0;
      mGlobalSettings.memoryTriggerNoteMap[i][memslot] = {0xFF,0,0};                     // invalid note 0xFF means the memory slot (s) is "empty"
    } 
    mGlobalSettings.portBTriggerInNoteMapNote[i] = 0xFF;
  }
}
void ssSettings_createNewProject(){
  ssFileHelper_getNewProjectName(_projectSettings.projectName);                    // getNewProjectName fills projectName with string
  _projectSettings.tempo = mGlobalSettings.tempo;
  _projectSettings.swingEnable = false;
  _projectSettings.swing = 50;
  _projectSettings.swingType = false;
  _projectSettings.bankLength[0] = mGlobalSettings.bankLength[0];
  _projectSettings.bankLength[1] = mGlobalSettings.bankLength[1];
  _projectSettings.bankLength[2] = mGlobalSettings.bankLength[2];
  _projectSettings.bankLength[3] = mGlobalSettings.bankLength[3];
  _projectSettings.robotSettings = {false,0,4,1,1,100,100,4,5,false,false,0};
  ssSettings_copyGlobalMapToProject();
  ssNoteData.clearEvents();
  ssTrigData.clearEvents();
  ssMuteSolo_clearAll();
  ssFileHelper_cleanBoth();
}

void loadGlobalSettingsFromFile(){
  if (ssFileHelper_getRoot()){
    File file = SD.open(F("_GLOBAL.SS1"), FILE_READ);
    if (file) {
      file.read(&mGlobalSettings,sizeof(mGlobalSettings));
      file.close();
    } else {
      // file doesn't exist, make it
      saveGlobalSettingsToFile();
    }
  } else {
    Serial.println(F("no SD card; using default global settings"));
  }
}
void saveGlobalSettingsToFile(){
  if (ssFileHelper_getRoot()){
      if (SD.exists(F("_global.ss1"))) { SD.remove("_global.ss1"); }
      File file =  SD.open(F("_GLOBAL.SS1"), FILE_WRITE);
      file.write((byte *)&mGlobalSettings, sizeof(mGlobalSettings));
      file.close();
  }    
}

//*
//*
//* GLOBAL - GET, SET, EDIT SETTINGS VALUES
//*
//*

// LAST FILE
bool  ssSettings_getGlobalLoadLastBackup(){
  return mGlobalSettings.loadLastBackup;
}
void toggleGlobalLoadLastBackup(){
  mGlobalSettings.loadLastBackup = !mGlobalSettings.loadLastBackup;
  saveGlobalSettingsToFile();
}
bool ssSettings_getGroupDrumMidi(){
  return mGlobalSettings.groupDrumMidi;
}
void ssSettings_toggleGroupDrumMidi(){
  mGlobalSettings.groupDrumMidi = !mGlobalSettings.groupDrumMidi;
}
byte ssSettings_getRedLedDisplay(){
  return mGlobalSettings.redLedDisplay;
}
void ssSettings_setRedLedDisplay(byte v){
  mGlobalSettings.redLedDisplay = v;
  saveGlobalSettingsToFile();
}
void toggleRedLedDisplay(int d){
  mGlobalSettings.redLedDisplay = (mGlobalSettings.redLedDisplay + d) % 4;
  saveGlobalSettingsToFile();
}

bool ssSettings_getPortBDrumTrigger(){
  return mGlobalSettings.portBDrumTrigger;
}
void ssSettings_setPortBDrumTrigger(bool v){
  mGlobalSettings.portBDrumTrigger = v;
  saveGlobalSettingsToFile();
}
void ssSettings_togglePortBDrumTrigger(){
  mGlobalSettings.portBDrumTrigger = !mGlobalSettings.portBDrumTrigger;
  saveGlobalSettingsToFile();
}

byte ssSettings_getConfirmDeletes(){
  return mGlobalSettings.confirmDeletes;
}
void ssSettings_setConfirmDeletes(bool b){
  mGlobalSettings.confirmDeletes = b;
  saveGlobalSettingsToFile();
}
void toggleConfirmDeletes(){
  mGlobalSettings.confirmDeletes = !mGlobalSettings.confirmDeletes;
  saveGlobalSettingsToFile();
}
// CLOCK
byte	ssSettings_getGlobalClockSource(){
  return mGlobalSettings.clockSource;
}
void incGlobalClockSource(){
  byte cs = mGlobalSettings.clockSource + 1;
  if (cs > 4) { cs = 0; }
  mGlobalSettings.clockSource = cs;
  ssClockHelper_setClockSource(mGlobalSettings.clockSource);
  saveGlobalSettingsToFile();  
}
void decGlobalClockSource(){
  byte cs = mGlobalSettings.clockSource;
  if (cs == 0) { cs = 5; }
  mGlobalSettings.clockSource = cs - 1;
  ssClockHelper_setClockSource(mGlobalSettings.clockSource);
  saveGlobalSettingsToFile();
}

// METRONOME
bool ssSettings_getGlobalMetroDefault(){
  return mGlobalSettings.recMetroDefault;
}
void ssSettings_toggleGlobalMetroDefault(){
  mGlobalSettings.recMetroDefault = !mGlobalSettings.recMetroDefault;
  saveGlobalSettingsToFile();
}

// RECORD PITCH, CC, PATCH
byte  ssSettings_getRecPitchbendResolution(){
  return mGlobalSettings.recPitchbendResolution;
}
void ssSettings_setPitchbendResolution(byte b){
  mGlobalSettings.recPitchbendResolution = b;
  saveGlobalSettingsToFile();
}
void incPitchChange(){
  byte pc = mGlobalSettings.recPitchbendResolution + 1;
  if (pc >2) { pc = 0; }
  mGlobalSettings.recPitchbendResolution = pc;
  saveGlobalSettingsToFile();
}
void decPitchChange(){
  byte pc = mGlobalSettings.recPitchbendResolution;
  if (pc == 0) { pc = 3; }
  mGlobalSettings.recPitchbendResolution = pc - 1;
  saveGlobalSettingsToFile();
}
bool  ssSettings_getRecCCMsg(){
  return mGlobalSettings.recCCMsg;
}
void ssSettings_toggleRecCCMsg(){
  mGlobalSettings.recCCMsg = !mGlobalSettings.recCCMsg;
  saveGlobalSettingsToFile();
}

// MIDI IN
byte  ssSettings_getMidiInPort(){
  return mGlobalSettings.midiInPort;
}
uint32_t ssSettings_getMidiInChannel(){
  return mGlobalSettings.midiInChannel;
}
void incMidiChannel(){
  byte c = mGlobalSettings.midiInChannel + 1;
  if (c>16) { c = 1; }
  mGlobalSettings.midiInChannel = c;
  ssMidiHelper_updateMidiInputChannel();
  saveGlobalSettingsToFile();
}
void decMidiChannel(){
  byte c = mGlobalSettings.midiInChannel;
  if (c == 1) { c = 17; }
  mGlobalSettings.midiInChannel = c - 1;
  ssMidiHelper_updateMidiInputChannel();
  saveGlobalSettingsToFile();
}

// MIDI MAPS
uint32_t ssSettings_getGlobalMidiTrackMap( byte track){
  return mGlobalSettings.midiTrackMap[track];
}
uint32_t ssSettings_getGlobalMidiTriggerMap(byte track){
  return mGlobalSettings.midiTriggerMap[track];
}
TriggerNoteMap  ssSettings_getGlobalMidiDrumMap(byte i){
  return mGlobalSettings.midiTriggerNoteMap[i];
}


//*
//*
//* PROJECT - GET, SET, EDIT SETTINGS VALUES
//*
//*

// PROJECT NAME
void ssSettings_getProjectName(char* rtnStr){
  strcpy(rtnStr, _projectSettings.projectName);
}
void ssSettings_setProjectName(const char s[]){
  strcpy(_projectSettings.projectName,s);
  ssFileHelper_makeFileDirty(13);
}

// PROJECT TEMPO
int  ssSettings_getTempo(){
  return _projectSettings.tempo;
}
void ssSettings_setTempo(float t){
  _projectSettings.tempo = (int)t;
  ssFileHelper_makeFileDirty(14);
}

// PROJECT BANK LENGTHS
byte ssSettings_getBankLength(byte i){
  return _projectSettings.bankLength[i];
}
void ssSettings_setBankLength(byte i, byte bl){
  _projectSettings.bankLength[i] = bl;
  ssFileHelper_makeFileDirty(15);
}

// PROJECT MIDI MAPS
uint32_t ssSettings_getMidiTrackMap(byte track){
  return _projectSettings.midiTrackMap[track];           
}
void ssSettings_toggleMidiChannelForNoteTrack(byte channel, byte track){
  uint32_t mask = 0x80000000 >> channel;
  _projectSettings.midiTrackMap[track] ^= mask;
  ssFileHelper_makeFileDirty(16);
}
void ssSettings_copyGlobalMapToProject(){      
  for (byte t=0;t<8;t++){
    _projectSettings.midiTrackMap[t] = mGlobalSettings.midiTrackMap[t];
    _projectSettings.midiTriggerMap[t] = mGlobalSettings.midiTriggerMap[t];
    _projectSettings.midiTriggerNoteMap[t] = mGlobalSettings.midiTriggerNoteMap[t];
  }
  for (byte t=8;t<16;t++){
    _projectSettings.midiTriggerMap[t] = mGlobalSettings.midiTriggerMap[t];
    _projectSettings.midiTriggerNoteMap[t] = mGlobalSettings.midiTriggerNoteMap[t];    
  }
  ssFileHelper_makeFileDirty(17);
}
void ssSettings_copyProjectMapsToGlobal(){     
  for (byte t=0;t<8;t++){
    mGlobalSettings.midiTrackMap[t] = _projectSettings.midiTrackMap[t];
    mGlobalSettings.midiTriggerMap[t] = _projectSettings.midiTriggerMap[t];
    mGlobalSettings.midiTriggerNoteMap[t] = _projectSettings.midiTriggerNoteMap[t];
  }
  for (byte t=8;t<16;t++){
    mGlobalSettings.midiTriggerMap[t] = _projectSettings.midiTriggerMap[t];
    mGlobalSettings.midiTriggerNoteMap[t] = _projectSettings.midiTriggerNoteMap[t];    
  }
  saveGlobalSettingsToFile();
}
uint32_t ssSettings_getMidiTriggerMap(byte track){
  return _projectSettings.midiTriggerMap[track];       
}
void ssSettings_toggleMidiChannelForTriggerTrack(byte channel, byte track, bool group){
  uint32_t mask = 0x80000000 >> channel;
  if (group){
    for (byte t=0;t<16;t++){
      _projectSettings.midiTriggerMap[t] = mask;
    }
  } else {
    _projectSettings.midiTriggerMap[track] ^= mask;
  }
  ssFileHelper_makeFileDirty(18);
}
TriggerNoteMap ssSettings_getMidiTriggerNoteMap(byte track){
  return _projectSettings.midiTriggerNoteMap[track];           
}
void ssSettings_setMidiTriggerNoteMap(byte track, TriggerNoteMap dm){
  _projectSettings.midiTriggerNoteMap[track] = dm;
  ssFileHelper_makeFileDirty(19);
}
void ssSettings_setMidiTriggerNoteMapNote(byte track, byte note){
  _projectSettings.midiTriggerNoteMap[track].note = note;
  ssFileHelper_makeFileDirty(20);
}
byte ssSettings_getPortBTriggerInNoteMapNote(byte track){
  return mGlobalSettings.portBTriggerInNoteMapNote[track];
}
void ssSettings_setPortBTriggerInNoteMapNote(byte track, byte note){
  mGlobalSettings.portBTriggerInNoteMapNote[track] = note;
  saveGlobalSettingsToFile();
}
RobotSettings ssSettings_getRobotSettings(){
  return _projectSettings.robotSettings;
}
void ssSettings_setRobotSettings(RobotSettings rs){
  _projectSettings.robotSettings = rs;
}

bool ssSettings_getSwingEnable(){
  return _projectSettings.swingEnable;
}
void ssSettings_toggleSwingEnable(){
  _projectSettings.swingEnable = !_projectSettings.swingEnable;
}

byte ssSettings_getSwing(){
  return _projectSettings.swing;
}
void ssSettings_setSwing(byte b){
  _projectSettings.swing = b;
}

bool ssSettings_getSwingType(){
  return _projectSettings.swingType;
}
void ssSettings_setSwingType(bool b){
  _projectSettings.swingType = b;
}
//*
//*
//* SETTINGS UI PAGES DISPLAY 
//*
//*
void ssSettings_showSaveDrumMapPage(){

  uint16_t grnSlotState = 0;
  uint16_t redSlotState = 0;  
  
  for (byte memslot=0;memslot<8;memslot++){
    grnSlotState = grnSlotState << 1;
    redSlotState = redSlotState << 1;
    if (mGlobalSettings.memoryTriggerNoteMap[0][memslot].note == 0xFF){   // if the track have an invalid note it means the slot is empty
      grnSlotState += 1;        
    } else {
      redSlotState += 1;
    }
  }

  ssPanel.setLEDBits(ROW_GRN,SOLID,grnSlotState<<8);
  ssPanel.setLEDBits(ROW_RED,SOLID,redSlotState<<8);
  ssPanel.clearRow(ROW_YLW);
  
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_SAVEDRUMMAP);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(str_SELECTSLOT);  
  
}
void ssSettings_saveDrumMapIntoSlot(byte slot){
  if (slot > 7) { return; }  
  ssPanel.setPoint(ROW_GRN,SOLID,slot,OFF);
  ssPanel.setPoint(ROW_RED,SOLID,slot,ON);

  char tmp1[17];
  strcpy(tmp1,str_DRUMMAPTOSLOT);
  char tmp2[4];
  itoa(slot+1,tmp2,10);
  strcat(tmp1,tmp2);
  ssDisplayUI_showPopupMessage(str_DRUMMAPSAVED,tmp1,1);
  
  for (byte t=0;t<16;t++){
      mGlobalSettings.memoryMidiTriggerMap[t][slot] = _projectSettings.midiTriggerMap[t];
      mGlobalSettings.memoryTriggerNoteMap[t][slot] = _projectSettings.midiTriggerNoteMap[t];      // invalid note 0xFF means the memory slot (s) is "empty"
  }
  saveGlobalSettingsToFile();
}

void ssSettings_showDrumMapSelectPage(){
  uint16_t redSlotState = 0;
  
  for (byte slot=0;slot<8;slot++){
    redSlotState = redSlotState << 1;
    if (mGlobalSettings.memoryTriggerNoteMap[0][slot].note != 0xFF){  
      redSlotState += 1;        
    }
  }
  ssPanel.setLEDBits(ROW_RED,SOLID,redSlotState<<8);
  ssPanel.clearRow(ROW_GRN);
  // ssPanel.clearRow(ROW_YLW);   // leave this on for Drum In Trigger Mapping
}

void ssSettings_handleDrumMapSelect(byte slot){
  if (slot > 7) { return; }
  if (mGlobalSettings.memoryTriggerNoteMap[0][slot].note == 0xFF){
    ssDisplayUI_showPopupMessage(str_EMPTYDRUMMAP_WARNING,"",1);  
  } else {
    char tmp1[17];
    strcpy(tmp1,str_DRUMMAPFROMSLOT);
    char tmp2[4];
    itoa(slot+1,tmp2,10);
    strcat(tmp1,tmp2);
    ssDisplayUI_showPopupMessage(str_DRUMMAPLOADED,tmp1,1);  
    for (byte t=0;t<16;t++){
        _projectSettings.midiTriggerMap[t] = mGlobalSettings.memoryMidiTriggerMap[t][slot];
        _projectSettings.midiTriggerNoteMap[t] = mGlobalSettings.memoryTriggerNoteMap[t][slot]; 
    }   
  }
}


//*
//*
//* SETTINGS MENU PAGES DISPLAY 
//*
//*
void showGroupDrumMidi(){
  mSettingPage = 10;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_GROUPDRUMMIDI);
  printYesNo(mGlobalSettings.groupDrumMidi);      
}
void showConfirmDeletes(){
  mSettingPage = 9;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_CONFIRMDELETES_QUESTION);
  printYesNo(mGlobalSettings.confirmDeletes);    
}
void showRedLedDisplay(){
  mSettingPage = 8;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_REDLEDDISPLAY);
  ssPanel.display.setCursor(1,1);
  switch (mGlobalSettings.redLedDisplay){
    case 0:
      ssPanel.display.print(str_OFF_OPTION);
      break;
    case 1:
      ssPanel.display.print(str_STEPS_OPTION);
      break;
    case 2:
      ssPanel.display.print(str_TRACKS_OPTION);
      break;
    case 3:
      ssPanel.display.print(str_BOTH_OPTION);
      break;      
  }   
}

void showPortBDrumTrigger(){
  mSettingPage = 11;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_PORTBDRUMTRIG_QUESTION);
  printYesNo(mGlobalSettings.portBDrumTrigger);    
}

void showRecMetronome(){
  mSettingPage = 7;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_METRONOMEON);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(str_REC_QUESTION);
  printYesNo(mGlobalSettings.recMetroDefault);  
}
void showClockTypeSetting(){
  mSettingPage = 6;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_CLOCKSOURCE);
  ssPanel.display.setCursor(0,1);
  switch (mGlobalSettings.clockSource){
    case CLOCKTYPE_INTERNAL: //internal
      ssPanel.display.print(str_INTERNAL_OPTION);
      break;
    case CLOCKTYPE_MIDI: // midi
      ssPanel.display.print(str_MIDI_OPTION);
      break;   
    case CLOCKTYPE_EXTERNAL16: //external 1/16
      ssPanel.display.print(str_EXTERNAL116_OPTION);
      break;
    case CLOCKTYPE_EXTERNAL8: //external 1/8
      ssPanel.display.print(str_EXTERNAL18_OPTION);
      break;
    case CLOCKTYPE_EXT24PPQN: //external 24 ppqn
      ssPanel.display.print(str_EXT24PPQN_OPTION);
      break;
  }  
}
void showLoadLastBackupSetting(){
  mSettingPage = 5;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_LOADLAST);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(str_PROJECT_QUESTION);
  printYesNo(mGlobalSettings.loadLastBackup);    
}
void showMidiInputChannel(){
  mSettingPage = 4;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_MIDIINPUT);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(str_CHANNEL_COLON);
  if (mGlobalSettings.midiInChannel > 9){
    ssPanel.display.setCursor(10,1);
  } else {
    ssPanel.display.setCursor(11,1);
  }
  char tmp[3];
  itoa(mGlobalSettings.midiInChannel,tmp,10);
  ssPanel.display.print(tmp);
}
void showRecPitchMessages(){
  mSettingPage = 3;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_RECPITCHWHEEL_QUESTION);
  ssPanel.display.setCursor(1,1);
  switch (mGlobalSettings.recPitchbendResolution){
    case 0: //rec off
      ssPanel.display.print(str_NOLOWHIGH_NOOPTION);
      break;
    case 1: //rec low
      ssPanel.display.print(str_NOLOWHIGH_LOWOPTION);
      break;
    case 2: //rec high
      ssPanel.display.print(str_NOLOWHIGH_HIGHOPTION);
      break;
  }
}
void showRecCCMessages(){
  mSettingPage = 2;
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_RECORDCC);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(str_MSGS_QUESTION);
  printYesNo(mGlobalSettings.recCCMsg);  
}

void printYesNo(bool y){
  ssPanel.display.setCursor(8,1);
  if (y){
    ssPanel.display.print(str_YESNO_YESOPTION);
  } else {
    ssPanel.display.print(str_YESNO_NOOPTION);
  }
}
void ssSettings_showSettings(){
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  mSettingPage = 0;

  mMenuIndex = 0;
  mCurrentMenuType = 10;
  showMenuNodeByTypeIndex(mCurrentMenuType,mMenuIndex);
}

//*
//*
//* SETTINGS SHORTCUTS UI HANDLERS
//*
//*
void ssSettings_handleKnobTurnShortcuts(int delta){
    if (delta > 0) {
      _projectSettings.swing += 5;
      if (_projectSettings.swing > 100) { _projectSettings.swing = 100; }
    } else {
      if (_projectSettings.swing < 5) { _projectSettings.swing = 5; }
      _projectSettings.swing -= 5;
    }
    ssClockHelper_updateSwingSettings();
    ssSettings_updateSwingValuePage();
}
void ssSettings_handleKnobPushShortcuts(bool isDown, bool inShift){
  if(isDown){
    if (inShift){
      ssDisplayUI_loadPanelPage(SETTINGS);      
    } else {
      ssDisplayUI_loadPanelPage(SETSHORTCUT);
      _inKnobPush = true;
    }
  } else {        // knob up
    _inKnobPush = false;
    ssDisplayUI_loadPanelPage(DEFAULT);
    ssDisplayUI_gotoLock(0);
    _inErase = false;     
  }
}
void ssSettings_showShortcutPage(){
  ssSettings_updateShortcutPage();
}
void ssSettings_updateShortcutPage(){
  int settingMask = 0;                                    // update yellow LEDs with Robot status
  if (mGlobalSettings.redLedDisplay > 0){                 // if redLedDisplay setting is not OFF(0)
    settingMask += (0b10000000000000000 >> mGlobalSettings.redLedDisplay);
  }  
  settingMask += (0b0000100000000000 >> mGlobalSettings.recPitchbendResolution);       
  if (mGlobalSettings.recCCMsg)       { settingMask += 0b0000000100000000; }
  if (mGlobalSettings.portBDrumTrigger)  { settingMask += 0b0000000010000000; }
  if (_recUnQuantized)                { settingMask += 0b0000000000010000; }
  if (ssSettings_getSwingEnable())    { settingMask += 0b0000000000001000; }
  if (!ssSettings_getSwingType())     { settingMask += 0b0000000000000100; }
  if (ssSettings_getSwingType())      { settingMask += 0b0000000000000010; }
  if (ssSettings_getGroupDrumMidi())  { settingMask += 0b0001000000000000; }
  ssPanel.setLEDBits(ROW_YLW,SOLID,settingMask);  
}
void ssSettings_handleShortcutSelectBtn(byte select, bool inShift){
  if (!inShift){
    switch (select){
      case 0:
      case 1:
      case 2:
        ssSettings_setRedLedDisplay(select + 1);
        break;
      case 3:
        ssSettings_toggleGroupDrumMidi();
        break;
      case 4:   // Pitchbend Off
        ssSettings_setPitchbendResolution(0);
        break;
      case 5:
        ssSettings_setPitchbendResolution(1);
        break;
      case 6:
        ssSettings_setPitchbendResolution(2);
        break;
      case 7:
        ssSettings_toggleRecCCMsg();
        break;
      case 8:
        ssSettings_togglePortBDrumTrigger();
        break;
      case 11:
        ssSequencer_toggleQuantizeRec();
        break;
      case 12:
        ssSettings_toggleSwingEnable();
        ssClockHelper_updateSwingSettings();
        break;
      case 13:
        ssSettings_setSwingType(false);
        ssClockHelper_updateSwingSettings();
        break;
      case 14:
        ssSettings_setSwingType(true);
        ssClockHelper_updateSwingSettings();
        break;
      case 15:
        ssDisplayUI_loadPanelPage(SWINGVALUE);
        break;
    }
    ssSettings_updateShortcutPage();
  }
}
void ssSettings_showSwingValuePage(){
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_SWINGVALUE);
  ssSettings_updateSwingValuePage();
}
void ssSettings_updateSwingValuePage(){
  ssPanel.display.setCursor(4,1);
  ssPanel.display.print("< ");
  char tmp[5];
  itoa(ssSettings_getSwing(),tmp,10);
  ssPanel.display.print(tmp);
  ssPanel.display.print("% >");  
}
//*
//*
//* SETTINGS MENU UI HANDLERS
//*
//*

void ssSettings_handleKnobPush(bool isDown, bool inShift){
  if (isDown){
    if (inShift){                                                     // if SHIFT go back up settings
      if (mSettingPage == 0){                                         //   if in settings menu tree and not in settings edit page
        if (mCurrentMenuType == 10){                                  //      and if at the top of the menu tree, leave settings menu
          ssDisplayUI_loadPanelPage(DEFAULT);         
        } else {
          mCurrentMenuType = (mCurrentMenuType/10) * 10;              //      else back up a branch of the tree
          showMenuNodeByTypeIndex(mCurrentMenuType,mMenuIndex); 
        }
      } else {                                                        //   else in settings edit page, go back to menu tree branch   
        mSettingPage = 0;
        mMenuIndex = 0;
        showMenuNodeByTypeIndex(mCurrentMenuType,mMenuIndex);  
      }     
    } else {                                                          // if just DOWN, no shift
      if (mSettingPage > 0){                                          //   if in setting edit page exit settings menu
        ssDisplayUI_loadPanelPage(DEFAULT);
      } else if (mSettingTree[mMenuTreeIndex].childType == 99){       //   if on a leaf go to edit page for that setting
        mSettingTree[mMenuTreeIndex].callFunction();
      } else {                                                        //   else go down to next branch or leaf                                                   
        mCurrentMenuType = mSettingTree[mMenuTreeIndex].childType; 
        mMenuIndex = 0;
        showMenuNodeByTypeIndex(mCurrentMenuType,mMenuIndex);         
      }
    }
  }
}
// THIS IS WHERE VALUES ARE CHANGED
void ssSettings_handleKnobTurn(int delta){
  switch (mSettingPage){
    case 0:
      mMenuIndex += delta;
      if (mMenuIndex < 0) { 
        mMenuIndex = getUpperBoundsForMenuType(mCurrentMenuType) - 1; 
      } else if (mMenuIndex > getUpperBoundsForMenuType(mCurrentMenuType) - 1){
        mMenuIndex = 0;
      }
      showMenuNodeByTypeIndex(mCurrentMenuType,mMenuIndex);
      break;
    case 2:
      ssSettings_toggleRecCCMsg();
      showRecCCMessages();
      break;
    case 3:
      if (delta > 0){
        incPitchChange();
      } else {
        decPitchChange();
      }
      showRecPitchMessages();
      break;
    case 4:
      if (delta > 0){
        incMidiChannel();
      } else {
        decMidiChannel();
      }
      showMidiInputChannel();
      break;
    case 5:
      toggleGlobalLoadLastBackup();
      showLoadLastBackupSetting();
      break;
    case 6:
      if (delta > 0){
        incGlobalClockSource();
      } else {
        decGlobalClockSource();
      }
      showClockTypeSetting();
      break;
    case 7:
      ssSettings_toggleGlobalMetroDefault();
      showRecMetronome();
      break;
    case 8:
      toggleRedLedDisplay(delta);
      showRedLedDisplay();
      break;
    case 9:
      toggleConfirmDeletes();
      showConfirmDeletes();
      break;
    case 10:
      ssSettings_toggleGroupDrumMidi();
      showGroupDrumMidi();
      break;
    case 11:
      ssSettings_togglePortBDrumTrigger();
      showPortBDrumTrigger();
      break; 
  }
}

//*
//*
//* SETTINGS MENU LOGIC
//*
//*
byte getUpperBoundsForMenuType(byte type){
  byte count = 0;
  for (byte x=0;x<TREESIZE;x++){
    if (mSettingTree[x].type == type) { count++; }
  }
  return count;
}

void showMenuNodeByTypeIndex(byte type, byte index){ // 1,0
  byte xidx = 0;
  byte c = 0;
  byte parentIndex = 0;

  while (xidx != index+1){
    if (mSettingTree[c].childType == type){
      parentIndex = c;  
    }
    if (mSettingTree[c].type == type){
        xidx++;
    } 
    c++;
    if (c == TREESIZE) { return; } // TODO handle error  
  }

  mMenuTreeIndex = c - 1;
  printMenuNode(parentIndex,0);
  printMenuNode(mMenuTreeIndex,1);

}

void printMenuNode(byte index, byte line){
  char tmp[17];
  strcpy(tmp,mSettingTree[index].settingName);
  ssPanel.display.setCursor(0,line);
  if (line == 0){
    for (byte i=0;i<strlen(tmp);i++){                 // toUpperCase
      if (tmp[i] > 90) { tmp[i] = tmp[i] - 32; } 
    }
    ssPanel.display.print(tmp);
    ssPanel.display.setCursor(15,0);
  } else {
    ssPanel.display.print("<");
    ssPanel.display.print(tmp);
    ssPanel.display.setCursor(15,line);
    ssPanel.display.print(">");
  }
}

void ssSettings_DEBUGPrintGlobalSettings(){
/*
  Serial.println(F("-------- global settings ------------"));
  Serial.print(F("tempo"));Serial.println(mGlobalSettings.tempo);
  Serial.print(F("bankLength"));Serial.println(mGlobalSettings.bankLength[4]);
  Serial.print(F("clockSource"));Serial.println(mGlobalSettings.clockSource);
  Serial.print(F("recMetroDefault"));Serial.println(mGlobalSettings.recMetroDefault);
  Serial.print(F("recPitchbendResolution"));Serial.println(mGlobalSettings.recPitchbendResolution);
  Serial.print(F("recCCMsg"));Serial.println(mGlobalSettings.recCCMsg);
  Serial.print(F("midiInPort"));Serial.println(mGlobalSettings.midiInPort);
  Serial.print(F("midiInChannel"));Serial.println(mGlobalSettings.midiInChannel);
  for (byte m=0;m<8;m++){
    Serial.print(F("midiTrackMap"));Serial.print(m);Serial.print(F("   "));Serial.println(mGlobalSettings.midiTrackMap[m],BIN);
  }
  for (byte m=0;m<16;m++){
    Serial.print(F("midiTriggerMap"));Serial.print(m);Serial.print(F("   "));Serial.println(mGlobalSettings.midiTriggerMap[m],BIN);
  }
  for (byte m=0;m<16;m++){
    Serial.print(F("note"));Serial.print(m);Serial.println(mGlobalSettings.midiTriggerNoteMap[m].note);
    Serial.print(F("velocity"));Serial.print(m);Serial.println(mGlobalSettings.midiTriggerNoteMap[m].velocity);
    Serial.print(F("accent"));Serial.print(m);Serial.println(mGlobalSettings.midiTriggerNoteMap[m].accent);
  }


  Serial.println(F("-------- end global settings ------------"));  
*/
}
