// **********************************************
// *
// *    sequencer functions
// *
// **********************************************

//*
//*
//* SEQUENCER HANDLE TRANSPORT EVENTS
//* FROM SSCLOCKHELPER
//*
//*
void ssSequencer_handlePlay(bool inPlay){
  if (!inPlay){                                 // if paused or stopped
    ssMidiHelper_killAllOutNotes(SEQ);          //   stop all sequencer notes    
  } else {                                      // play started
    ssSequencer_exitStepRecord();               //   playing kicks you out of step record
  }
}
void ssSequencer_handleStop(){                  // only called when stpped from a play
  ssSequence_cancelBankChange();
  ssMidiHelper_killAllOutNotes(SEQ);            //   stop all sequencer notes
  closeOutRecordedNoteOns();
}
void ssSequencer_handleRec(bool inRec){       
  if (!inRec){                                  // if recording stops mid note, close the recorded note, but keep playing it (i.e. no killNotes)
    closeOutRecordedNoteOns();  
  }
}
void ssSequencer_handleBeforeLoop(bool inRec){
  if (inRec){                                  // if recording and we loop end the note before the loop
    closeOutRecordedNoteOns();  
  }  
}
void closeOutRecordedNoteOns(){
  KeyInputState kis;
  for (byte n=0;n<128;n++){
    kis = ssMidiHelper_getKeyInputNoteState(n);
    if (kis.handler == SEQUENCER && kis.recorded){
      recordMidiNoteOff(kis);
      clearKeyInputNoteStateRecBit(n);      // clear the recorded bit so we don't record noteOff again when key is released
    }
  }
}
//*
//*
//* SEQUENCER DATA EDITS
//*
//*
void copyTrack(byte srcBank, byte srcTrack, byte dstBank, byte dstTrack){
  if (_inTrigger){
    ssTrigData.copyBankTrackToBankTrack(srcBank,srcTrack,dstBank,dstTrack);
  } else {
    ssNoteData.copyBankTrackToBankTrack(srcBank,srcTrack,dstBank,dstTrack);
  }  
  ssFileHelper_makeFileDirty(1);
}
void ssSequencer_clearTrack(){
  if (_inTrigger) {
    ssTrigData.clearEventsForTrack(_currentBank,_currentTriggerTrack);     
  } else {
    ssMidiHelper_killTrackOutNotes(_currentNoteTrack, SEQ);       
    ssNoteData.clearEventsForTrack(_currentBank,_currentNoteTrack);
  }
  ssFileHelper_makeFileDirty(2);  
}
void ssSequencer_clearDrums(){
  ssTrigData.clearEventsForBank(_currentBank);
  ssFileHelper_makeFileDirty(3);  
}
void ssSequencer_clearBank(){
  ssMidiHelper_killAllOutNotes(SEQ);
  ssNoteData.clearEventsForBank(_currentBank);
  ssTrigData.clearEventsForBank(_currentBank);
  ssFileHelper_makeFileDirty(4);  
}
void ssSequencer_clearAllData(){
  ssMidiHelper_killAllOutNotes(SEQ);
  ssNoteData.clearEvents();
  ssTrigData.clearEvents();
  ssFileHelper_makeFileDirty(5);
}
void ssSequencer_newProject(){
  ssClockHelper_stopTransport();
  ssSettings_createNewProject();
  ssDisplayUI_loadPanelPage(DEFAULT);  
}
void ssSequencer_markTempo(byte bank, int step){
  if (step == -1) step = 0;
  int t = ssSettings_getTempo();
  byte v1 = t/128;
  byte v2 = t%128;
  ssNoteData.addEvent(step, bank, 0, 6, v1, v2, false, true);
}

//*
//*
//* CHANGE SEQUENCE/PLAYBACK STATE
//*
//*
void ssSequence_changeBank(byte newBank){
  ssMidiHelper_killAllOutNotes(SEQ);
  ssDisplayUI_resetBankLEDS();
  _currentBank = newBank;
  _nextBank = newBank;
  ssDisplayUI_updateBankDisplay();
  ssMuteSolo_updateLedStatus();

  if (_inPlay){
    ssClockHelper_restartSequencerStep();
  } else {
    ssClockHelper_resetSequencerStep();
  }
}
void ssSequence_cancelBankChange(){
  _nextBank = _currentBank;
  ssDisplayUI_updateBankDisplay();
}
//*
//*
//* HANDLE MIDI INPUT FOR SEQUENCER
//*
//*
void ssSequencer_handleMidiNoteOn(KeyInputState kis){
  if (ssSettings_getPortBDrumTrigger() && kis.port == 1){                         // if PortB Drum Trigger setting is ON and the MIDI note came from Port B
    bool accent = false;
    if (kis.velocity > 118) { accent = true; }
    if (_panelPage == DMAPSELECT){                                                // set the trigger pad to the track
      ssSettings_setPortBTriggerInNoteMapNote(kis.track, kis.note); 
      ssSequencer_playTriggerHit(kis.track, accent);   
    } else {
      for (byte i=0;i<16;i++){  
        if (ssSettings_getPortBTriggerInNoteMapNote(i) == kis.note) {             // play the track trigger from pad
          ssSequencer_playTriggerHit(i, accent);
        }
      }
    }
  } else if (kis.handler == SEQUENCER){
    ssMidiHelper_sendTrackNote(kis.track,kis.note,kis.velocity,true,LIVE);
    if (_inRec && _inPlay) {
      int stp =  _currentStep;
      byte offset = 0;
      bool skp = false;
      if (ssClockHelper_getOffset() > 4){
        if (_recUnQuantized){
          offset = 1;                                                               // this is 1/32 note quantization
        } else {  
          stp++;                                                                    // this is 1/16 note quantization
          if (stp == ssSettings_getBankLength(kis.bank) * 16) { stp = 0; }
          skp = true;
        }
      }
      ssNoteData.addEvent(stp*2 + offset,kis.bank,kis.track,1,kis.note,kis.velocity, skp); 
      ssMidiHelper_setKeyInputNoteStateRecBit(kis.note);                                // mark this key note as recorded
      ssFileHelper_makeFileDirty(6);
    }
  } else if (kis.handler == TRIGGER) {
    if (kis.port == 0 || !ssSettings_getPortBDrumTrigger()){ 
      ssMidiHelper_sendTriggerTrackDirectNote(kis.track,kis.note,false);
    }
    if (_panelPage == NOTEMIDIMAP){
      ssSettings_setMidiTriggerNoteMapNote(kis.track, kis.note);
    }
  }
}
void ssSequencer_handleMidiNoteOff(KeyInputState kis){
  if (kis.handler == SEQUENCER){
    ssMidiHelper_sendTrackNote(kis.track,kis.note,0,false,LIVE);
    if (kis.recorded) {               // if the note is recorded, record the noteOff
      recordMidiNoteOff(kis);
    }
  } // TRIGGER noteOns already sent the note off so ignore
}
void recordMidiNoteOff(KeyInputState kis){
  int stp =  _currentStep;
  byte offset = 0;
  bool skp = false;
  if (ssClockHelper_getOffset() > 4){
    if (_recUnQuantized){
      offset = 1;                                                                    // this is 1/32 note quantization
    } else {  
      stp++;
      if (stp == ssSettings_getBankLength(kis.bank) * 16) { stp = 0; }
      skp = true;
    }
  }
  ssNoteData.addEvent(stp*2 + offset,kis.bank,kis.track,2,kis.note,0, skp);   
}
void ssSequencer_handlePitchBend(byte channel,int value){
  if (!_inTrigger){
    ssMidiHelper_sendTrackPitchBend(_currentNoteTrack,value);
    if (_inRec && _inPlay && (ssSettings_getRecPitchbendResolution() > 0)) { 
      int stp =  _currentStep;
      bool skp = false;
      if (ssClockHelper_getOffset() > 4){
        stp++;
        if (stp == ssSettings_getBankLength(_currentBank) * 16) { stp = 0; }
        skp = true;
      }
      ssNoteData.addEvent(stp*2,_currentBank,_currentNoteTrack,3,value/128,value%128, skp);
      ssFileHelper_makeFileDirty(7); 
    }    
  }
}
void ssSequencer_handleCC(byte channel, byte msg, byte value){
  if (!_inTrigger){
    // if (msg == 1) { msg = 74; }              // maps mod wheel to filter CC
    // Serial.print(msg);Serial.print("::");Serial.println(value);
    ssMidiHelper_sendTrackCCMsg(_currentNoteTrack, msg, value);
    if (_inRec && _inPlay && ssSettings_getRecCCMsg()) { 
      int stp =  _currentStep;
      bool skp = false;
      if (ssClockHelper_getOffset() > 4){
        stp++;
        if (stp == ssSettings_getBankLength(_currentBank) * 16) { stp = 0; }
        skp = true;
      }
      ssNoteData.addEvent(stp*2,_currentBank,_currentNoteTrack,5,msg,value, skp, true);     // TODO -  add to top ??
      ssFileHelper_makeFileDirty(9);
    }  
  }
}
void ssSequencer_handleTriggerHit(bool accent){
  if (_inTrigger){
    ssSequencer_playTriggerHit(_currentTriggerTrack, accent);
  }
}
void ssSequencer_playTriggerHit(byte track, bool accent){
  ssMidiHelper_sendTriggerTrackHit(track,accent);
  if (_inRec && _inPlay) {   
    int stp =  _currentStep;
    bool skp = false;
    if (ssClockHelper_getOffset() > 4){
      stp++;
      if (stp == ssSettings_getBankLength(_currentBank) * 16) { stp = 0; }
      skp = true;
    }
    ssTrigData.addEvent(_currentBank, track, stp, ON, accent, skp); 
    ssFileHelper_makeFileDirty(10);
  }
}
void ssSequencer_toggleQuantizeRec(){
  _recUnQuantized = !_recUnQuantized;
  ssClockHelper_setRecLED(_inRec);
}

//*
//*
//*  SEQUENCER PLAYBACK FUNCTIONS
//*
//*
void ssSequencer_handleNoteDataStepPlayback(NoteEvent e){
  if (_inPlay){
    if (e.bank == _currentBank && ssMuteSolo_recorderFilter(e)) {
      switch (e.cmd){
        case 1: // noteOn
          if ((e.track != _currentNoteTrack) || (ssMidiHelper_getKeyNoteState(e.val1,_currentNoteTrack) == 0)){                 // if this note is not currently being played on the keyboard then play the sequence note
            ssMidiHelper_sendTrackNote(e.track,e.val1,e.val2,true,SEQ); 
          }
          break;
        case 2: // noteOff
          if ((e.track != _currentNoteTrack) || (ssMidiHelper_getKeyNoteState(e.val1,_currentNoteTrack) == 0)){                 // if this note is not currently being played on the keyboard then play the sequence note
            ssMidiHelper_sendTrackNote(e.track,e.val1,e.val2,false,SEQ);   
          }
          break; 
        case 3: // pitchBend
          ssMidiHelper_sendTrackPitchBend(e.track,e.val1 * 128 + e.val2);  
          break;   
        case 4: // patchChange
          ssMidiHelper_sendTrackPatchChange(e.track,e.val1); 
          break;  
        case 5: // CC message
          ssMidiHelper_sendTrackCCMsg(e.track, e.val1, e.val2);
          break;
        case 6: // tempo
          ssClockHelper_setTempo(e.val1 * 128 + e.val2);
          break;
      } 
    }
  }
}
void ssSequencer_handleTrigDataStepPlayback(TrigEvent e){
  if (_inPlay){
    if (e.step == _currentStep && e.bank == _currentBank && ssMuteSolo_triggerFilter(e)) { 
      ssMidiHelper_sendTriggerTrackHit(e.track, e.accent);
    }
  }
}

// ************************************************************
// 
//  DRUM MACHINE
//
// ************************************************************

void ssSequencer_handleSelectBtn(byte select, bool inShift){
  TriggerNoteMap tnm = ssSettings_getMidiTriggerNoteMap(_currentTriggerTrack);
  if (select < 14){
    byte value = select * 10;
    if (value > 127) { value = 127; };
    if (_panelPage == VMAPHIT){
      tnm.velocity = value;
      ssSettings_setMidiTriggerNoteMap(_currentTriggerTrack, tnm);
      ssSequencer_showVMapHitPage();
    } else if (_panelPage == VMAPACCENT){
      tnm.accent = value;
      ssSettings_setMidiTriggerNoteMap(_currentTriggerTrack, tnm);
      ssSequencer_showVMapAccentPage();
    }    
  }
}

void ssSequencer_showVMapHitPage(){
  TriggerNoteMap tnm = ssSettings_getMidiTriggerNoteMap(_currentTriggerTrack);
  char tmp[4];
  itoa(tnm.velocity,tmp,10);
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_VELOCITYMAP);
  ssPanel.display.setCursor(4,1);
  ssPanel.display.print("< ");
  ssPanel.display.print(tmp);
  ssPanel.display.print(" >");
}
void ssSequencer_showVMapAccentPage(){
  TriggerNoteMap tnm = ssSettings_getMidiTriggerNoteMap(_currentTriggerTrack);
  char tmp[4];
  itoa(tnm.accent,tmp,10);
  
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_ACCENTMAP);
  ssPanel.display.setCursor(4,1);
  ssPanel.display.print("< ");
  ssPanel.display.print(tmp);
  ssPanel.display.print(" >");
}


void ssSequencer_handleKnobButton(bool isDown, bool inShift){
  if (isDown) {
    ssDisplayUI_loadPanelPage(DEFAULT);  // back oput   
  }
}
void ssSequencer_HandleKnobTurn(int delta, bool inShift){
  TriggerNoteMap tnm = ssSettings_getMidiTriggerNoteMap(_currentTriggerTrack);

  switch(_panelPage){
    case VMAPHIT:
      if (delta > 0) {
        if (inShift){
          tnm.velocity += 1;          
        } else {
          tnm.velocity += 10;          
        }
        if (tnm.velocity > 127) { tnm.velocity = 0; }
      } else {
        if (inShift){
          if (tnm.velocity == 0) { tnm.velocity = 128; }
          tnm.velocity -= 1;      
        } else {
          if (tnm.velocity < 10) { tnm.velocity = 137; }
          tnm.velocity -= 10;             
        }
      }
      ssSettings_setMidiTriggerNoteMap(_currentTriggerTrack, tnm);
      ssSequencer_showVMapHitPage();
      break;
    case VMAPACCENT:
      if (delta > 0) {
        if (inShift){
          tnm.accent += 1;          
        } else {
          tnm.accent += 10;          
        }
        if (tnm.accent > 127) { tnm.accent = 0; }
      } else {
        if (inShift){
          if (tnm.accent == 0) { tnm.accent = 128; }
          tnm.accent -= 1;      
        } else {
          if (tnm.accent < 10) { tnm.accent += 137; }
          tnm.accent -= 10;             
        }        
      }
      ssSettings_setMidiTriggerNoteMap(_currentTriggerTrack, tnm);
      ssSequencer_showVMapAccentPage();
      break;
  }
}

// ************************************************************
// 
//  STEP RECORDER
//
// ************************************************************
KeyInputState       mStepNotes[12];
byte mStepNoteIndex = 0;

void ssSequencer_handleStepRecMidiNoteOn(KeyInputState kis){
  ssMidiHelper_sendTrackNote(kis.track,kis.note,kis.velocity,true,LIVE);
  mStepNotes[mStepNoteIndex] = kis;
  mStepNoteIndex++;
}
void ssSequencer_handleStepRecMidiNoteOff(KeyInputState kis){
  Serial.println("ssSequencer_handleStepRecMidiNoteOff");
  int stp =  _currentStep;
  if (stp == -1) { stp = 0; ssClockHelper_restartSequencerStep();}

  byte stepLength = 1 << (4 - ssSettings_getRobotSettings().noteType);
  int nextStep;

  ssMidiHelper_sendTrackNote(kis.track,kis.note,0,false,LIVE);
 
  if (ssMidiHelper_getKeyInputNoteStateCount() < 2 && mStepNoteIndex > 0){         // removed the last key; write step; TODO: ssMidiHelper_getKeyInputNoteStateCount gets updated after midi processors. Why?
    if (_inSlide > 0){       // in tie and note played so make it a slur
      nudgeLastNoteOffs(1);   
      _inSlide = 2; 
    }
    
    for (byte n=0;n<mStepNoteIndex;n++){
      ssNoteData.addEvent(stp*2,mStepNotes[n].bank,mStepNotes[n].track,1,mStepNotes[n].note,mStepNotes[n].velocity, false, true); 
      if (ssSettings_getRobotSettings().noteLength) {                                                                                   // if stacato
        nextStep = stepLength;
        if (nextStep >= ssSettings_getBankLength(_currentBank) * 16) { nextStep -= ssSettings_getBankLength(_currentBank) * 16; }
      } else {
        nextStep = stepLength * 2;
        if (nextStep >= ssSettings_getBankLength(_currentBank) * 16) { nextStep -= ssSettings_getBankLength(_currentBank) * 16; }
      }      
      Serial.println(nextStep);                         
      ssNoteData.addEvent(stp*2 + nextStep,mStepNotes[n].bank,mStepNotes[n].track,2,mStepNotes[n].note,0, false);
    }
    ssFileHelper_makeFileDirty(11);
    mStepNoteIndex = 0;

    // advance to next step
    ssClockHelper_advanceSequencerStep(stepLength);
  }
}
void ssSequencer_handleStepRecRest(){
  ssClockHelper_advanceSequencerStep(1 << (4 - ssSettings_getRobotSettings().noteType));
}
void ssSequencer_handleStepRecTie(bool state){
  if (state == ON){    
    _inSlide = 1;
  } else {
    if (_inSlide < 2){                      // no note was playyed to it is a tie, not a slur
      nudgeLastNoteOffs(2);
      ssClockHelper_advanceSequencerStep(1 << (4 - ssSettings_getRobotSettings().noteType)); 
    }
    _inSlide = 0;
  }  
}
void nudgeLastNoteOffs(int steps){
// look at bank/track, currentStep
  int cs = _currentStep *2;
  if (ssNoteData.getStepSummary(_currentBank,_currentNoteTrack,cs) & 0b10){                           // if there are noteOffs, then last stepRec was legato, nudge those
    ssNoteData.nudgeCmdAtStep(_currentBank, _currentNoteTrack, cs, 2, 1);  
  } else {
    cs = cs - 1;                                                                                      // else, go back one 1/32 step,
    if (cs < 0) { cs = ssSettings_getBankLength(_currentBank) * 32 - 1; }
    if (ssNoteData.getStepSummary(_currentBank,_currentNoteTrack,cs) & 0b10){                         //  if there are noteOffs, then last stepRec was stacato, nudge those
      ssNoteData.nudgeCmdAtStep(_currentBank, _currentNoteTrack, cs, 2, 1);  
    } 
  }
}
void ssSequencer_enterStepRecord(){
  _inStepRec = true;
  ssClockHelper_setPlayTransport(OFF);
  ssClockHelper_setRecordTransport(OFF);
  _inSlide = 0;
  
  ssClockHelper_setRecLED(OFF);
  ssPanel.setPoint(ROW_BANKAUX,BLINK,REDBTNLED,ON);
  ssPanel.setClick(OFF); // turn off metro

  ssDisplayUI_loadPanelPage(STEPRECORD);    
}
void ssSequencer_exitStepRecord(){
  _inStepRec = false;
  ssPanel.setPoint(ROW_BANKAUX,BLINK,REDBTNLED,OFF);
  ssDisplayUI_loadPanelPage(DEFAULT); 
  _inSlide = 0;          
}
