
#ifndef ssRobot_defs_h
#define ssRobot_defs_h

#include "Arduino.h"

#define ROBOTUP           0
#define ROBOTDOWN         1
#define ROBOTINCLUDE      2
#define ROBOTEXCLUDE      3
#define ROBOTRANDOM       4
#define ROBOTRNDWEIGHTED  5

#define ROBOTTIE          128
#define ROBOTREST         129
#define TURINGMAXSTEPS    128

#define NUMOFSCALES       13
#define NUMOFCHORDS       8
#define MAXNOTESINCHORD   5

#define CHORDCUSTOM       7


const char* scales[]={"Major","minor","blues","Maj Penatonic","min Penatonic","Chromatic","Drone","Dorian","Phrygian","Lydian","Mixolydian","Locrian","Custom"};
byte scalesToInterval[NUMOFSCALES][14][2]={   // scalesToInterval[scalesValue][index][weight]; index[n][0][0] = count
{{7,115},{0,30},{2,10},{4,20},{5,5},{7,25},{9,10},{11,15},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},               // major
 {{7,115},{0,30},{2,10},{3,20},{5,5},{7,25},{8,10},{10,15},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // natural minor
 {{6,110},{0,30},{3,20},{5,15},{6,10},{7,20},{10,15},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // minor blues
 {{5,80},{0,30},{2,10},{4,10},{7,20},{9,10},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},                 // major penatonic
 {{5,80},{0,30},{3,10},{5,10},{7,20},{10,10},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},                // minor penatonic
 {{12,120},{0,10},{1,10},{2,10},{3,10},{4,10},{5,10},{6,10},{7,10},{8,10},{9,10},{10,10},{11,10},{0,0}},      // chromatic
 {{1,1},{0,1},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},                       // Drone
 {{7,115},{0,30},{2,10},{3,5},{5,25},{7,10},{9,15},{10,20},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // Dorian
 {{7,115},{0,30},{1,10},{3,5},{5,25},{7,10},{8,15},{10,20},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // Phrygian
 {{7,115},{0,30},{2,10},{4,5},{6,25},{7,10},{9,15},{11,20},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // Lydian
 {{7,115},{0,30},{2,10},{4,5},{5,25},{7,10},{9,15},{10,20},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // Mixolydian
 {{7,115},{0,30},{1,10},{3,5},{5,25},{6,10},{8,15},{10,20},{0,0},{0,0},{0,0},{0,0},{0,0},{0,0}},              // Locrian
 {{1,10},{0,10},{1,10},{2,10},{3,10},{4,10},{5,10},{6,10},{7,10},{8,10},{9,10},{10,10},{11,10},{0,0}}         // custom
};


const char* chords[]={"Maj","min","Sus2","Sus4","Dom7","Maj7","min7","Custom"};
const char* notes[]={"C","C#","D","D#","E","F","F#","G","G#","A","A#","B"};

/*
 *  other chord ideas
 *  octaves
 *  Maj and Min thirds
 *  Power Chord / 5ths
 *  add lower octave (is this a settings?)
 *  "power strings" chords
 * 
 */

byte chordIntervals[NUMOFCHORDS][MAXNOTESINCHORD + 1] = {
  {3,0,4,7,0,0},
  {3,0,3,7,0,0},
  {3,0,2,7,0,0},
  {3,0,5,7,0,0},
  {4,0,4,7,10,0},
  {4,0,4,7,11,0},
  {4,0,3,7,10,0},
  {6,0,0,0,0,0}
};

byte mTuringArray[TURINGMAXSTEPS];   // array of turing notes based on the key of C
byte mTuringIndex = 0;
int  mTuringScaleIndex;
byte mLastTuringNote = 0;
byte mLastTuringPlayedNote = 0;
bool mLastTuringNoteRecorded = false;
byte mCurrentTuringRootNote = 0xFF;
byte mCurrentTuringRootVelocity = 127;
byte mTuringTrack = 0xFF;
byte mTuringBank = 0xFF;


#endif
