// ROBOT settings UI - used for all robots Arp, turning, etc

void ssRobot_showSettingsPage(byte page){    // page ROBOTPAGE1 or ROBOTPAGE2
  ssRobot_showSettingsLeds(page);  
}
void ssRobot_updateSettingsPage(byte page){
  ssRobot_showSettingsLeds(page);  
}
void ssRobot_handleBankBtn(byte select, bool inShift){
  if (!_inTrigger){
    byte blueBtn = select - 16; 
    if (blueBtn < 4){
      if (blueBtn == _activeRobot){
        ssRobot_turnOffActiveRobot();  
      } else {
        ssRobot_turnOnActiveRobot(blueBtn); 
      }
    }
  }
}
void ssRobot_handleSelectBtnAdv(byte select){
  switch (select){
      case 11:
      ssDisplayUI_loadPanelPage(ROBOTPLEN);
      return;
      break;
    case 12:
      ssDisplayUI_loadPanelPage(ROBOTPROB);
      return;
      break;
    case 13:
      ssDisplayUI_loadPanelPage(ROBOTCOMPLEX);
      return;
      break;
    case 14:
      ssDisplayUI_loadPanelPage(ROBOTSCALE);
      return;
      break;
    case 15:
      ssDisplayUI_loadPanelPage(ROBOTCHORD);
      return;
      break;
  }
}
void ssRobot_handleSelectBtn(byte select, byte ctrl, bool inShift){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();  
  if (inShift && _panelPage == ROBOTPAGE2){
    switch (select){
      case 0:
        rbtSettings.transpose = !rbtSettings.transpose;
        if (!rbtSettings.transpose) { mArpTransposeNote = 0xFF; }
        break;
      case 11:
      case 12:
      case 13:
      case 14:
      case 15:
        ssRobot_handleSelectBtnAdv(select);
        return;
        break;
      case 1:
        rbtSettings.octaveRange = 1;
        break;
      case 2:
        rbtSettings.octaveRange = 2;
        break;
      case 3:
        rbtSettings.octaveRange = 3;
        break;
      case 8:
        rbtSettings.noteLength = 0;
        break;
      case 9:
        rbtSettings.noteLength = 1;
        break;         
    }
    ssSettings_setRobotSettings(rbtSettings);
    ssRobot_updateSettingsPage(ROBOTPAGE2);
  } else {
    if (_panelPage == ROBOTCOMPLEX){                      // these are the quick select for Turing Prob, Complex and PLength
      if (select < 10){
        rbtSettings.complexity  = (select + 1) * 10;
        ssSettings_setRobotSettings(rbtSettings);
        ssRobot_robotPageExit(select, ctrl, inShift);
      } else if (select == 10) {
        rbtSettings.complexity  = 0;
        ssSettings_setRobotSettings(rbtSettings);
        ssRobot_robotPageExit(select, ctrl, inShift);      
      } else if (select < 16){
        ssRobot_handleSelectBtnAdv(select);
      }
    } else if (_panelPage == ROBOTPROB){
      if (select < 10){
        rbtSettings.probability = (select + 1) * 10;
        ssSettings_setRobotSettings(rbtSettings);
        ssRobot_robotPageExit(select, ctrl, inShift);
      } else if (select == 10) {
        rbtSettings.probability  = 0;
        ssSettings_setRobotSettings(rbtSettings);
        ssRobot_robotPageExit(select, ctrl, inShift);      
      } else if (select < 16){
        ssRobot_handleSelectBtnAdv(select);
      }
    } else if (_panelPage == ROBOTPLEN){
      if (select < 8){
        rbtSettings.patternLen = select + 1;
        ssSettings_setRobotSettings(rbtSettings);
        ssRobot_robotPageExit(select, ctrl, inShift);
      } else if (select > 10 && select < 16){
        ssRobot_handleSelectBtnAdv(select);
      }
    } else if ((_panelPage == ROBOTSCALE || _panelPage == ROBOTCHORD) && (select > 10 && select < 16)){
      ssRobot_handleSelectBtnAdv(select);
    } else {
      switch (select){
        case 0:
          rbtSettings.keyLatch = !rbtSettings.keyLatch;
          if (!rbtSettings.keyLatch) { 
            mArpNoteCount = 0; 
            turnOffArpCurrentNote(); 
            mArpTransposeNote == 0xFF; 
          }
          break;
        case 1:
          rbtSettings.direction = 0;
          break;
        case 2:
          rbtSettings.direction = 1;
          break;
        case 3:
          rbtSettings.direction = 2;
          break;
        case 4:
          rbtSettings.direction = 3;
          break;
        case 5:
          rbtSettings.direction = 4;
          break;
        case 6:
          rbtSettings.direction = 5;
          break;
        case 7:
          rbtSettings.doubleNote = !rbtSettings.doubleNote;
          break;
        case 8:
          rbtSettings.noteType = 1;     //  1/2
          break;
        case 9:
          rbtSettings.noteType = 2;     //  1/4
          break;
        case 10:
          rbtSettings.noteType = 3;     //  1/8
          break;
        case 11:
          rbtSettings.noteType = 4;     //  1/16
          break;
        case 12:
          rbtSettings.noteType = 5;     //  Rhythm 13
          break;
        case 13:
          rbtSettings.noteType = 6;     //  R. OFF
          break;
      }
      ssSettings_setRobotSettings(rbtSettings);
      ssRobot_updateSettingsPage(ROBOTPAGE1);
    }
  }
  
}
void ssRobot_robotPageExit(byte select, byte ctrl, bool inShift){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();
  char tmp[21] = "Set: ";
  char valueStr[5];
  
  switch (_panelPage){
    case ROBOTCOMPLEX:
      itoa(rbtSettings.complexity,valueStr,10);
      strcat(tmp,valueStr);
      strcat(tmp,"%");
      ssDisplayUI_showPopupMessage(str_COMPLEXITY,tmp,3, DEFAULT);
      break;
    case ROBOTPROB:
      itoa(rbtSettings.probability,valueStr,10);
      strcat(tmp,valueStr);
      strcat(tmp,"%");
      ssDisplayUI_showPopupMessage(str_PROBABLITY,tmp,3, DEFAULT);      
      break;
    case ROBOTPLEN:
      itoa(rbtSettings.patternLen,valueStr,10);
      strcat(tmp,valueStr);
      ssDisplayUI_showPopupMessage(str_PATTERNLENGTH,tmp,3, DEFAULT);
      break;
    case ROBOTSCALE:
      strcat(tmp,scales[rbtSettings.scale]);
      ssDisplayUI_showPopupMessage(str_SCALE,tmp,3, DEFAULT);
      break;
    case ROBOTCHORD:
      strcat(tmp,chords[rbtSettings.chord]);
      ssDisplayUI_showPopupMessage(str_CHORD,tmp,3, DEFAULT);
      break;
  }

}
void ssRobot_updateBankLeds(){
  ssDisplayUI_resetBankLEDS();                                // update Blue LEDs with what robots are on
  if (_activeRobot < 16){
    ssPanel.setPoint(ROW_BANKAUX,BLINK,_activeRobot,ON);
  }  
}
void ssRobot_showSettingsLeds(byte page){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();

  ssRobot_updateBankLeds();
  ssRobot_showCurrentRobotTrackLeds();

        
  int robotSettingMask = 0;                                    // update yellow LEDs with Robot status
  if (page == ROBOTPAGE2){
    if (rbtSettings.transpose)          { robotSettingMask += 0b1000000000000000; }
    robotSettingMask += (0b1000000000000000 >> rbtSettings.octaveRange);       
    robotSettingMask += (0b0000000010000000 >> rbtSettings.noteLength);
    if (rbtSettings.probability == 100) { robotSettingMask += 0b0000000000001000; }
    if (rbtSettings.complexity  == 100) { robotSettingMask += 0b0000000000000100; }
  } else { // ROBOTPAGE1
    if (rbtSettings.keyLatch) { robotSettingMask += 0b1000000000000000; }
    robotSettingMask += (0b0100000000000000 >> rbtSettings.direction);
    robotSettingMask += (0b0000000100000000 >> rbtSettings.noteType); 
    if (rbtSettings.doubleNote) { robotSettingMask += 0b0000000100000000; }
  }
  ssPanel.setLEDBits(ROW_YLW,SOLID,robotSettingMask);


}
void ssRobot_showCurrentRobotTrackLeds(){
  ssPanel.clearRow(ROW_GRN);                                  // update red/green leads with what track is currently assigned to what robot
  ssPanel.clearRow(ROW_RED);

  byte robotTrack;
  if (_activeRobot == 0 && mArpTrack < 8) {                   // RED LEDs show current ROBOT track when holding the ROBOT button
    robotTrack = mArpTrack;
  } else if (_activeRobot == 1 && mTuringTrack < 8) {                          
    robotTrack = mTuringTrack;
  } else if (_activeRobot == 2 && mChordTrack < 8) {                          
    robotTrack = mChordTrack;
  } else {                                                    // no currtent robot or patternBot doesn't have a track associated with it so just return
    return;
  }
  ssPanel.setPoint(ROW_RED,BLINK,robotTrack,ON,EXCL);  
}
void ssRobot_showPLenPage(){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();
  char tmp[4];
  itoa(rbtSettings.patternLen,tmp,10);
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_PATTERNLENGTH_CAPS);
  ssPanel.display.setCursor(4,1);
  ssPanel.display.print("<  ");
  ssPanel.display.print(tmp);
  ssPanel.display.setCursor(10,1);
  ssPanel.display.print(">");

  ssDisplayUI_resetRedGrnYlwLEDS();
  ssPanel.setBar(ROW_GRN,SOLID,rbtSettings.patternLen);
}
void ssRobot_showProbPage(){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();
  char tmp[4];
  itoa(rbtSettings.probability,tmp,10);
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_PROBABLITY_CAPS);
  ssPanel.display.setCursor(4,1);
  ssPanel.display.print("< ");
  ssPanel.display.print(tmp);
  ssPanel.display.print("%");
  ssPanel.display.setCursor(11,1);
  ssPanel.display.print(">");

  ssDisplayUI_resetRedGrnYlwLEDS();
  if (rbtSettings.probability > 9) {  
    ssPanel.setBar(ROW_RED,SOLID,rbtSettings.probability/10);
  }
}
void ssRobot_showComplexPage(){
  RobotSettings rbtSettings =ssSettings_getRobotSettings();
  char tmp[4];
  itoa(rbtSettings.complexity,tmp,10);
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_COMPLEXITY_CAPS);
  ssPanel.display.setCursor(4,1);
  ssPanel.display.print("< ");
  ssPanel.display.print(tmp);
  ssPanel.display.print("%");
  ssPanel.display.setCursor(11,1);
  ssPanel.display.print(">");

  ssDisplayUI_resetRedGrnYlwLEDS();
  if (rbtSettings.complexity > 9) {  
    ssPanel.setBar(ROW_RED,SOLID,rbtSettings.complexity/10);
  }
}
void ssRobot_showScalePage(){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();
  char tmp[17];
  strcpy(tmp,scales[rbtSettings.scale]);
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_SCALE_CAPS);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print("<");
  ssPanel.display.setCursor(8 - strlen(tmp)/2,1);
  ssPanel.display.print(tmp);
  ssPanel.display.setCursor(15,1);
  ssPanel.display.print(">"); 
  ssDisplayUI_resetRedGrnYlwLEDS();
}
void ssRobot_showChordPage(){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();
  char tmp[17];
  strcpy(tmp,chords[rbtSettings.chord]);
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_CHORD_CAPS);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print("<");
  ssPanel.display.setCursor(8 - strlen(tmp)/2,1);
  ssPanel.display.print(tmp);
  ssPanel.display.setCursor(15,1);
  ssPanel.display.print(">"); 
  ssDisplayUI_resetRedGrnYlwLEDS();
}
void ssRobot_handleKnobButton(bool isDown, bool inShift){
  if (isDown) {
    ssRobot_robotPageExit(NOBUTTON,NOBUTTON,inShift);  // exit with current values   
  }
}
void ssRobot_HandleKnobTurn(int delta, bool inShift){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();

  switch(_panelPage){
    case ROBOTSCALE:
      if (delta > 0) {
        rbtSettings.scale++;
        if (rbtSettings.scale == NUMOFSCALES) { rbtSettings.scale = 0; }
      } else {
        if (rbtSettings.scale == 0) { rbtSettings.scale = NUMOFSCALES; }
        rbtSettings.scale--;
      }
      ssSettings_setRobotSettings(rbtSettings);
      ssRobot_showScalePage();
      break;
    case ROBOTPLEN:
      if (delta > 0) {
        rbtSettings.patternLen += 1;
        if (rbtSettings.patternLen > 8) { rbtSettings.patternLen = 8; }
      } else {
        if (rbtSettings.patternLen < 2) { rbtSettings.patternLen = 2; }
        rbtSettings.patternLen -= 1;
      }
      ssSettings_setRobotSettings(rbtSettings);
      ssRobot_showPLenPage();
      break;
    case ROBOTPROB:
      if (delta > 0) {
        if (inShift){
          rbtSettings.probability += 1;
        } else {
          rbtSettings.probability += 10;
        }
        if (rbtSettings.probability > 100) { rbtSettings.probability = 100; }
      } else {
        if (inShift){
          if (rbtSettings.probability < 1) { rbtSettings.probability = 1; }
          rbtSettings.probability -= 1;
        } else {
          if (rbtSettings.probability < 10) { rbtSettings.probability = 10; }
          rbtSettings.probability -= 10;
        }
      }
      ssSettings_setRobotSettings(rbtSettings);
      ssRobot_showProbPage();
      break;
    case ROBOTCOMPLEX:
      if (delta > 0) {
        if (inShift){
          rbtSettings.complexity += 1;
        } else {
          rbtSettings.complexity += 10;
        }
        if (rbtSettings.complexity > 100) { rbtSettings.complexity = 100; }
      } else {
        if (inShift){
          if (rbtSettings.complexity < 1) { rbtSettings.complexity = 1; }
          rbtSettings.complexity -= 1;
        } else {
          if (rbtSettings.complexity < 10) { rbtSettings.complexity = 10; }
          rbtSettings.complexity -= 10;
        }
      }
      ssSettings_setRobotSettings(rbtSettings);
      ssRobot_showComplexPage();
      break;
    case ROBOTCHORD:
      turnOffCurrentChord();
      if (delta > 0) {
        rbtSettings.chord++;
        if (rbtSettings.chord == NUMOFCHORDS) { rbtSettings.chord = 0; }
      } else {
        if (rbtSettings.chord == 0) { rbtSettings.chord = NUMOFCHORDS; }
        rbtSettings.chord--;
      }
      ssSettings_setRobotSettings(rbtSettings);
      ssRobot_showChordPage();
      break;  
  }
}
void ssRobot_turnOffActiveRobot(){
  switch (_activeRobot){
    case 0: // arp
      ssArp_arpModeOff();
      break;
    case 1: // turing
      ssTuring_turingModeOff();
      break;
    case 2: // chord
      ssChord_chordModeOff();
      break;
    case 3: // pattern
      ssClockHelper_patternModeOff();
      break;
  }
  _activeRobot = 0xFF;
  ssRobot_updateBankLeds();
  ssPanel.setPoint(ROW_CTRLS,BLINK,7,OFF); 
}
void ssRobot_turnOnActiveRobot(byte bot){
  ssRobot_turnOffActiveRobot();
  switch (bot){
    case 0: // arp
      ssArp_makeActiveRobot();
      break;
    case 1: // turing
      ssTuring_makeActiveRobot();
      break;
    case 2: // chord
      ssChord_makeActiveRobot();
      break;
    case 3: // pattern
      ssClockHelper_makeActiveRobot();
      break;
  }
  ssRobot_updateBankLeds();
  ssRobot_showCurrentRobotTrackLeds();
  ssRobot_updateRobotCtrlLED();
}
void ssRobot_updateRobotCtrlLED(){
  if (_activeRobot < 0xFF) {
    ssPanel.setPoint(ROW_CTRLS,BLINK,7,ON);    
  }  
}
