/*
 * Recorder API for SS1 sequencer
 */

#ifndef ssnotedata_h
#define ssnotedata_h

#include "Arduino.h"

#define NUMOFRECORDERSTEPS 512
#define NOTEDATABUFFERSIZE 0x4000
#define NUMOFBANKS  4
#define NUMOFTRACKS 8
#define CMD_NOTEON  1
#define CMD_NOTEOFF 2
#define CMD_PITCH   3
#define CMD_PATCH   4
#define CMD_CC      5

#define NOTEEVENTDWORD uint32_t
#define NOTEDATABUFFERINDEX uint16_t

struct NoteEvent{
	int step;
	byte bank;
	byte track;
	byte cmd;
	byte val1;
	byte val2;
	bool skip;
};
struct EventCount{
	int used;
	int total;
};
	
class SSNoteData
{
  public:

	typedef void (*hStepPlayback)(NoteEvent); 			

  SSNoteData();

	void addEvent(int step, byte bank, byte track, byte cmd, byte val1, byte val2, bool skip);
	void addEvent(int step, byte bank, byte track, byte cmd, byte val1, byte val2, bool skip, bool top);
	void addEvent(NoteEvent e);
  void adjustCmdValue(byte bank, byte track, int startStep, int numOfSteps, byte cmd, byte cmdVal, int adjustAmount, bool minMaxOut);  // adjustAmount == +/-; minMaxOut == true means if you exceed the 0 - 127 range then set the value to 0 or 127, 
                                                                                                                                    // otherwise don't change value. cmdVal = 1 or 2  (eg note or velocity)
	void begin();
  void processPostLoad();
	void clearEvents();
	void clearEventsForBank(byte bank);
	void clearEventsForBank(byte bank, int start);
	void clearEventsForTrack(byte bank, byte track);
	void clearEventsForTrack(byte bank, byte track, int start);
  void clearCmdForBank(byte bank, byte cmd);
	void clearCmdForTrack(byte bank, byte track, byte cmd);
	void clearCmdForTrack(byte bank, byte track, byte cmd, int start);
	void copyBankTrackToBankTrack(byte srcBank, byte srcTrack, byte dstBank, byte dstTrack);
	void copyBankToBank(byte srcBank, byte dstBank);
	void duplicateStepsByTrack(byte bank, byte track, int startStep, int numOfSteps, byte numOfCopies); // cmd filter?  byte start limits to 256 steps
	void duplicateStepsByBank(byte bank, int startStep, int numOfSteps, byte numOfCopies); // cmd filter?
	void eraseAtStep(byte bank, byte track, int step);
  void emptyQueue();
  void flipTrackSteps(byte bank, byte track, int startStep, int numOfSteps);
  void *      getEventsDataPointer();
  uint32_t    getEventDataSize();
  EventCount  getEventUsage();
  byte getStepSummary(byte bank, byte track, int step);
  void levelCmdValue(byte bank, byte track, int startStep, int numOfSteps, byte cmd, byte val, byte level, byte mode);
  void nudgeCmdAtStep(byte bank, byte track, int step, byte cmd, int steps);
  void nudgeStep(byte bank, byte track, int step, int steps);
  void nudgeTrack(byte bank, byte track, int startStep, int numOfSteps, int nudgeSteps);
	void playbackStep(byte bank, int step);
	void processQueue();
	void setHandlerStepPlayback(hStepPlayback);
	void DEBUG_printEventData(int count);
	void DEBUG_printNumOfEvents();
	void DEBUG_printSingleEventData(int i);
  int DEBUG_getEventQueueCount();


	
  private:
  
	struct StepHint{
		int top;
		int bottom;
	};


  
  
  StepHint        mEventStepHints[NUMOFRECORDERSTEPS];
	NOTEEVENTDWORD 	mEvents[NOTEDATABUFFERSIZE];

  struct foobar{
    uint32_t a;
    byte b;
    int c;
    byte e;
  };
  
  foobar  foo;  // ?? THIS IS PROTECTING FROM A MEMORY LEAK. NOT USED BUT REMOVE IT AND PLAYBACK DOESN'T WORK. I THINK IT HAS SOMETHING TO DO WITH DEFINING STRUCT DEFAULT VALUE LIKE GlobalSettings mGlobalSettings  


  NOTEEVENTDWORD        mEventToEVENTDWORD(NoteEvent e);
  NoteEvent             mEVENTDWORDToEvent(NOTEEVENTDWORD d);
 
	void     			        mFullClearEvents();
	void 					        mClearHints();
	void					        mIncStepHints(int);
	void					        mDecStepHints(int);
	void 					        mInsert(NOTEEVENTDWORD value, NOTEEVENTDWORD *a, NOTEDATABUFFERINDEX);
	void 					        mRemove(NOTEEVENTDWORD *a, NOTEDATABUFFERINDEX);
	NOTEDATABUFFERINDEX 	mGetEventCount();
	int						        mGetLastStep();
	void 					        mRebuildStepHints();
  void		              mAddEventData(NoteEvent e, bool top);
	void 	                mAddEventData(NOTEEVENTDWORD edw, bool top);
  void                  mFastAddEventData(NoteEvent e);
	void 					        mDeleteEventData(NOTEDATABUFFERINDEX i);
  void                  mFastDeleteEventData(NOTEDATABUFFERINDEX i);
	void					        mDeleteBankEventsAtStep(byte bank, int step);
	void					        mDeleteTrackEventsAtStep(byte bank, byte track, int step, bool deletePartner);
	void					        mDeleteCmdEventsAtStep(byte bank, byte track, byte cmd, int step);
  void                  mDeleteCmdEventsForBankAtStep(byte bank, byte cmd, int step);
	bool 					        mCompareEvents(NOTEEVENTDWORD eventA, NOTEEVENTDWORD eventB, NOTEEVENTDWORD compareMask);
	void  				        mUpdateEventValue(NOTEDATABUFFERINDEX eventIndex, NOTEEVENTDWORD newValue, NOTEEVENTDWORD updateMask);
  void                  mProcessAddEventQueue();
  void                  mProcessGarbageCollection();
  void                  mCheckGarbage();
  void                  mNudgeEvent(NOTEDATABUFFERINDEX i, int steps);
  NOTEDATABUFFERINDEX   mFindNoteOffPartner(NOTEDATABUFFERINDEX i);
	
	hStepPlayback         raiseStepPlayback;
  NOTEDATABUFFERINDEX   mGarbageIndex;
  NOTEDATABUFFERINDEX   mAddEventQueueIndex;  

	
};





#endif
