void ssMuteSolo_processPostLoad(){
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_updateLedStatus(){
  if (_inLock != 1 && _SoloState[_currentBank] > 0) {             // this flashes the solo/mute ctrl btn LEDs based on playing bank solo/mute state
    ssPanel.setPoint(ROW_CTRLS,BLINK,0,ON);
  } else {
    ssPanel.setPoint(ROW_CTRLS,BLINK,0,OFF);
  }
  if (_inLock != 2 && _MuteState[_currentBank] > 0) {
    ssPanel.setPoint(ROW_CTRLS,BLINK,1,ON);
  } else {
    ssPanel.setPoint(ROW_CTRLS,BLINK,1,OFF);
  }
}
void ssMuteSolo_showSoloState(){
  ssPanel.clearRow(ROW_RED);
  ssPanel.clearRow(ROW_YLW);
  if (_showSuperTriggerUI){
    ssPanel.setLEDBits(ROW_GRN,SOLID,ssMuteSolo_getSoloBits(_muteSoloEditBank,1));    
  } else {
    ssPanel.setLEDBits(ROW_GRN,SOLID,ssMuteSolo_getSoloBits(_muteSoloEditBank,0));       
  }
}
void ssMuteSolo_showMuteState(){
  ssPanel.clearRow(ROW_GRN);
  ssPanel.clearRow(ROW_YLW);
  if (_showSuperTriggerUI){
    ssPanel.setLEDBits(ROW_RED,SOLID,ssMuteSolo_getMuteBits(_muteSoloEditBank,1));    
  } else {
    ssPanel.setLEDBits(ROW_RED,SOLID,ssMuteSolo_getMuteBits(_muteSoloEditBank,0));       
  }
}
void ssMuteSolo_clearAll(){
  for (byte b=0;b<4;b++){
    ssMuteSolo_clearAllMute(b);
    ssMuteSolo_clearAllSolo(b);
  }
  ssMuteSolo_updateLedStatus();
}

void ssMuteSolo_toggleMuteNoteTrack(byte bank, byte track){
  _MuteState[bank] ^= (0x80000000 >> track);
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_toggleSoloNoteTrack(byte bank, byte track){
  _SoloState[bank] ^= (0x80000000 >> track);
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_toggleMuteTriggerTrack(byte bank, byte track){
  _MuteState[bank] ^= (0x00800000 >> track);
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_toggleSoloTriggerTrack(byte bank, byte track){
  _SoloState[bank] ^= (0x00800000 >> track); 
  ssMuteSolo_updateLedStatus(); 
}
void ssMuteSolo_clearAllMute(byte bank){
  _MuteState[bank] = 0x00000000;
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_clearAllSolo(byte bank){
  _SoloState[bank] = 0x00000000;
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_muteAllNoteTracks(byte bank){
  _MuteState[bank] |= 0xFF000000;
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_muteAllTriggerTracks(byte bank){
  _MuteState[bank] |= 0x00FFFF00;
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_soloAllNoteTracks(byte bank){
  _SoloState[bank] |= 0xFF000000;
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_soloAllTriggerTracks(byte bank){
  _SoloState[bank] |= 0x00FFFF00;
  ssMuteSolo_updateLedStatus();
}

void ssMuteSolo_muteAllTracks(byte bank){
  _MuteState[bank] = 0xFFFFFF00;
  ssMuteSolo_updateLedStatus();
}
void ssMuteSolo_soloAllTracks(byte bank){
  _SoloState[bank] = 0xFFFFFF00;
  ssMuteSolo_updateLedStatus();
}


uint16_t ssMuteSolo_getMuteBits(byte bank, byte page){
  uint16_t bits;
  if (page == 0){ 
    bits = _MuteState[bank] >> 16;
  } else {
    bits = (_MuteState[bank] >> 8) & 0x0000FFFF;
  }
  return bits;
}
uint16_t ssMuteSolo_getSoloBits(byte bank, byte page){
  uint16_t bits;
  if (page == 0){ 
    bits = _SoloState[bank] >> 16;
  } else {
    bits = (_SoloState[bank] >> 8) & 0x0000FFFF;
  }
  return bits;
}

// return true if event is played
bool ssMuteSolo_recorderFilter(NoteEvent e){
  if (e.cmd != 1){ return true; }     // only filter noteOns
  
  if (_SoloState[e.bank]){                              // if something is Solo'd in the bank then filter on that (solo trumps mute)
    return (0x80000000 >> e.track) & _SoloState[e.bank];      
  } else {                                              // otherwise filter on Mute
    return (0x80000000 >> e.track) & ~_MuteState[e.bank];      
  }
}
bool ssMuteSolo_trackFilter(byte bank, byte track){     // returns TRUE to play note, FALSE to mute note
  if (_SoloState[bank]){                                // if something is Solo'd in the bank then filter on that (solo trumps mute)
    return (0x80000000 >> track) & _SoloState[bank];      
  } else {                                              // otherwise filter on Mute
    return (0x80000000 >> track) & ~_MuteState[bank];      
  }
}
bool ssMuteSolo_triggerFilter(TrigEvent e){
  if (_SoloState[e.bank]){                              // if something is Solo'd in the bank then filter on that (solo trumps mute)
    return (0x00800000 >> e.track) & _SoloState[e.bank];      
  } else {                                              // otherwise filter on Mute
    return (0x00800000 >> e.track) & ~_MuteState[e.bank];      
  }
}
