// #include <DueFlashStorage.h>
#define MAXNUMOFFILES 64

//DueFlashStorage dueFlashStorage;



bool mProjectDirty = false;           // something in the project has changed since last saved
bool mBackupDirty = false;            // something in the project has changed since last backup
char mFileList[20][13];               // a list of file names returned from getFileList
byte mFileListCount;                  // the number of files in the static filelist
int  mTimeStamp;

byte mSelectionFileIndex;             // the currently displayed/selected index of FileList
byte mFilePage;                       // the page requesting file UI either FILEPAGE or RESTOREPAGE

/*
 * 
 * fillFileList - fills the FileList array for enumeration
 * 
 */
void fillFileList(byte page){                               // page is either FILEPAGE or RESTOREPAGE
  mFileListCount = 0;                                       // reset list to beginning
  char fileSuffix[5] = ".SSS";
  if (page == RESTOREPAGE) { strcpy(fileSuffix,".SOS"); }

  _root.rewindDirectory();                                  // start at the top of the file list; _root was loaded at begin 
  File file = _root.openNextFile();                         // and get the first file

  while (file){
    char fileName[13];
    char ext[5];
    file.getName(fileName,13);                              // get the filename

    byte extIndex = strlen(fileName) - 4;                   // copy the extention into ext
    for (byte i=0;i<5;i++){
      ext[i] = fileName[extIndex + i]; 
    }
    // Serial.print(F("found: "));Serial.print(fileName);Serial.print(F("  with ext: "));Serial.println(ext);
    if (strcmp(ext,fileSuffix) == 0){                       // make sure the file is the right type for the page  FILEPAGE = .SSS or RESTOREPAGE = .SOS
      // Serial.print(F("MATCHED: "));Serial.println(fileName);
      strcpy(mFileList[mFileListCount],fileName);           // add it to the list
      mFileListCount++;
    }
    file = _root.openNextFile();
  }
  if (page == RESTOREPAGE) {   
    sortFileArray(true);                                    // sort the list backwards
  } else {
    sortFileArray(false);                                   // sort the list forwards
  }
}

/*
 * 
 * SAVE and LOAD
 * 
 */
void ssFileHelper_saveProject(){
  if (ssFileHelper_getRoot()){                        // make sure we can write to the SD card
    char fileName[13];
    ssSettings_getProjectName(fileName);              // get the project file name from settings and put into fileName
    if (strlen(fileName) > 0) {                       // make sure its valid
      saveFileDataExt(fileName);                         // save data with that name
      ssFileHelper_cleanProjectFile();

      char tmpStr[12] = "\"";                         // put quotes around the friendly file name
      ssFileHelper_trimFileExtension(fileName);
      strcat(tmpStr, fileName);
      strcat(tmpStr, "\"");
      ssDisplayUI_showPopupMessage(str_PROJECTSAVED,tmpStr,3);  
    }
  }      
}
void ssFileHelper_saveAsNewProject(){
  if (ssFileHelper_getRoot()){                          // make sure we can write to the SD card
    char fileName[13];
    ssFileHelper_getNewProjectName(fileName);           // fill fileName with a new name
    if (strlen(fileName) > 0) {                         // make sure its valid
      ssSettings_setProjectName(fileName);              // store it in the project settings
      saveFileDataExt(fileName);                           // save data with that name
      ssFileHelper_cleanProjectFile();

      char tmpStr[15] = "\"";                           // put quotes around the friendly file name
      ssFileHelper_trimFileExtension(fileName);
      strcat(tmpStr, fileName);
      strcat(tmpStr, "\"");
      ssDisplayUI_showPopupMessage(str_PROJECTSAVEDAS,tmpStr,3);  
    }
  }
}
void ssFileHelper_reloadProject(){
  char fileName[13];
  ssSettings_getProjectName(fileName);                                // put the project name in fileName
  if (loadFileDataExt(fileName)){                                        // load the file
    ssDisplayUI_showPopupMessage(str_PROJECT,str_RELOADED,3);
  } else {
    ssDisplayUI_showPopupMessage(str_ERROR,str_CANTRELOAD,3);
  }
}
/*
bool saveFileData(char* fileName){                                 // saves the current project to the filename
  // Serial.print(F("saveFileData:"));Serial.println(fileName);
  if (ssFileHelper_getRoot()){
    if (SD.exists(fileName)) { SD.remove(fileName); }           // delete the file if it already exists
    File file =  SD.open(fileName, FILE_WRITE);                 // write the new project data
    
    file.write((byte *)ssNoteData.getEventsDataPointer() , FILEBREAK);               // needed to split the recorder events into two SD load buffer because the SD library has a buffer limit of 64k bytes
    //Serial.print(file.write((byte *)ssNoteData.getEventsDataPointer() , FILEBREAK));               // needed to split the recorder events into two SD load buffer because the SD library has a buffer limit of 64k bytes
    //Serial.print("/");Serial.println(ssNoteData.getEventDataSize());
    file.write(((byte *)ssNoteData.getEventsDataPointer()) + FILEBREAK, (int)(ssNoteData.getEventDataSize() - FILEBREAK));
    //Serial.print(file.write(((byte *)ssNoteData.getEventsDataPointer()) + FILEBREAK, (int)(ssNoteData.getEventDataSize() - FILEBREAK)));
    //Serial.print("/");Serial.println(ssNoteData.getEventDataSize());    
    
    file.write((byte *)ssTrigData.getEventsDataPointer(), ssTrigData.getEventDataSize());
    file.write((byte *)_MuteState, sizeof(_MuteState));
    file.write((byte *)_SoloState, sizeof(_SoloState));
    file.write((byte *)&_projectSettings, sizeof(_projectSettings));  
    file.close();  
    return true;
  } else {
    return false;
  }
}
*/
bool saveFileDataExt(char* fileName){
  //Serial.print(F("saveFileDataExt:"));Serial.println(fileName);
  ssNoteData.emptyQueue();                                      // make sure the data queue is finished before saving
  
  if (ssFileHelper_getRoot()){
    if (SD.exists(fileName)) { SD.remove(fileName); }           // delete the file if it already exists
    File file =  SD.open(fileName, FILE_WRITE);                 // write the new project data

    uint16_t blockSize = ssNoteData.getEventDataSize()/2;
    SimpleFileSystem sfs = {blockSize,blockSize,ssTrigData.getEventDataSize(),sizeof(_MuteState),sizeof(_SoloState),sizeof(_projectSettings),0,0};
    file.write((byte *)&sfs , sizeof(sfs)); 
    
    file.write((byte *)ssNoteData.getEventsDataPointer() , blockSize);                               // needed to split the recorder events into two SD load buffer because the SD library has a buffer limit of 64k bytes
    file.write((byte *)ssNoteData.getEventsDataPointer() + blockSize, blockSize);
    
    file.write((byte *)ssTrigData.getEventsDataPointer(), ssTrigData.getEventDataSize());
    file.write((byte *)_MuteState, sizeof(_MuteState));
    file.write((byte *)_SoloState, sizeof(_SoloState));
    file.write((byte *)&_projectSettings, sizeof(_projectSettings));  
    file.close();  
    return true;
  } else {
    return false;
  }  
}
/*
bool loadFileData(char* fileName){                                 // loads the project with given filename
  if (ssFileHelper_getRoot()) {
    //Serial.print(F("loadFileData:"));Serial.println(fileName);
    File file =  SD.open(fileName, FILE_READ);
    if (file) {
      //Serial.print(F("opened:"));Serial.println(fileName);
      ssNoteData.clearEvents();
      ssTrigData.clearEvents();
      
      file.read(ssNoteData.getEventsDataPointer(), 0x2000);
      file.read(ssNoteData.getEventsDataPointer() + 0x2000, ssNoteData.getEventDataSize() - 0x2000);        // needed to split the recorder events into two SD load buffer because the SD library has a buffer limit of 64k bytes
      ssNoteData.processPostLoad();

      file.read(ssTrigData.getEventsDataPointer(), ssTrigData.getEventDataSize());
    
      file.read(_MuteState, sizeof(_MuteState));
      file.read(_SoloState, sizeof(_SoloState));

      file.read(&_projectSettings, sizeof(_projectSettings));
      ssSettings_processPostLoad();
      file.close(); 
      ssFileHelper_cleanBoth(); 
      return true;      
    } else {
      return false;
    }
  } else {
    return false;
  }
}
*/
bool loadFileDataExt(char* fileName){                                 // loads the project with given filename
  if (ssFileHelper_getRoot()) {
    Serial.print(F("loadFileData:"));Serial.println(fileName);
    File file =  SD.open(fileName, FILE_READ);
    if (file) {
      Serial.print(F("opened:"));Serial.println(fileName);
      ssNoteData.clearEvents();
      ssTrigData.clearEvents();

      SimpleFileSystem sfs;
      file.read(&sfs, sizeof(sfs));                                                                          // read the file into to get the sizes
      
      file.read(ssNoteData.getEventsDataPointer(), sfs.noteDataSizeBlockA);
      file.read(ssNoteData.getEventsDataPointer() + sfs.noteDataSizeBlockA, sfs.noteDataSizeBlockB);        // needed to split the recorder events into two SD load buffer because the SD library has a buffer limit of 64k bytes

      file.read(ssTrigData.getEventsDataPointer(), sfs.trigDataSize);
    
      file.read(_MuteState, sfs.muteStateSize);
      file.read(_SoloState, sfs.soloStateSize);

      file.read(&_projectSettings, sfs.projectSettingsSize);
      file.close(); 

      ssNoteData.processPostLoad();
      ssSettings_processPostLoad();
      ssMuteSolo_processPostLoad();

      char projectName[13];
      ssSettings_getProjectName(projectName);
      if (strcmp(fileName,projectName) != 0) {        // if the fileName does not match what is in the projectName in settings
        if (fileName[0] == '_'){                      // if the fileName is "write protected" (starts with _) then find a new project name
          ssFileHelper_getNewProjectName(projectName);
          ssSettings_setProjectName(projectName);
        } else if (!strEndsWith(fileName,".SOS")) {   // otherwise if not a backup, filename trumps saved project name; backups use saved project name
          ssSettings_setProjectName(fileName);
        }
      }
      
      ssFileHelper_cleanBoth(); 
      return true;      
    } else {
      Serial.println(F("Error loading file. Exist?"));
      return false;
    }
  } else {
    Serial.println(F("Error loading file. No SD card"));
    return false;
  }
}
/*
 * 
 * NAME FUNCTIONS
 * 
 */

void ssFileHelper_getNewProjectName(char* rtnStr){                  // fills rtnStr with the next unused filename available
  byte proposedIndex = 1;
  char proposedName[13];
  getProposedName(proposedIndex, proposedName);                     // fills proposedName with the a possible filename string using the proposed index value
  
  fillFileList(FILEPAGE);                                           // fill the FileList with all the current file names for FILEPAGE. RESTOREPAGE does not use this.

  byte i = 0;
  for(byte i=0;i<mFileListCount;i++){                               // enumerate through filenames seeing if the proposed is already used; if it is bump up the proposedIndex and try again
    if (strcmp(mFileList[i],proposedName) == 0){
      proposedIndex++;                                              // since FileList is sorted, don't need to start from the top again
      getProposedName(proposedIndex, proposedName);                 // getting a new name to try
    } else {
      i = mFileListCount;                                           // if not equal, then found a usable name so exit loop
    }
  }
  strcpy(rtnStr,proposedName);                                      // copy the name into the return string
}
void getProposedName(int proposedIndex, char* rtnStr){             // fills rtnStr with a string of the form PROJ_[index].SSS with leading zero if needed
  char proposedIndexNamed[13] = "PROJ_";                           // start with the prefix PROJ_

  if (proposedIndex <10) {                                         // add a leading zero if needed
    strcat(proposedIndexNamed,"0");
  } 

  char pIndexStr[3];
  itoa(proposedIndex, pIndexStr, 10);
  strcat(proposedIndexNamed,pIndexStr);                            // add the index value
  strcat(proposedIndexNamed,".SSS");                               // add the extention

  strcpy(rtnStr,proposedIndexNamed);                               // copy the name into the return string 
}

void ssFileHelper_trimFileExtension(char * rtnStr){                // strips extension off name
  rtnStr[strlen(rtnStr) - 4] = '\0';                               // put an end of string character four character in from the end cutting off the file extension begins
}



/*
 * 
 * DIRTY FILES
 * 
 */
bool ssFileHelper_fileDirty(){
  return mProjectDirty;
}
void ssFileHelper_makeFileDirty(byte d){
  // Serial.print("ssFileHelper_makeFileDirty: ");Serial.println(d);
  mProjectDirty = true;
  mBackupDirty = true;
}
void ssFileHelper_cleanProjectFile(){
  mProjectDirty = false;
}
void ssFileHelper_cleanBoth(){
  mProjectDirty = false;
  mBackupDirty = false;  
}


/*
 * 
 *  BACKUP
 *  
 */


bool ssFileHelper_loadLastBackup(){       
  if (SD.exists("0.SOS")){
    Serial.println(F("ssFileHelper_loadLastBackup: 0.SOS"));
    return loadFileDataExt("0.SOS");                         // load the last back up data and return the results
  }
}
void ssFileHelper_Backup(){
  if (!mBackupDirty) { return; }                          // don't do a backup if nothing has changed

  int t = millis();                                       // DEBUG
  int bakTime = millis()/100 % 100000000;
  char fileName[13];                                      // generate the backup filename based on 1/10 secs since startup; %10000000 limits it to 8 characters       
  itoa(bakTime,fileName,10);     
  strcat(fileName,".SOS");                                // add the extention
  Serial.print(F("ssFileHelper_Backup:"));Serial.println(fileName);
  if (ssFileHelper_getRoot()){                            // if there is a working SD card
    saveFileDataExt(fileName);                            // save the backup
    mBackupDirty = false;                                 // reset (clean) BackupDirty

    t = (millis() - t);                                   // DEBUG
    Serial.print(F("Backup time (ms):"));Serial.println(t);
  } 
}
void resetBackupFiles(){                                              // deletes all previous backups except the last one which it renames 0.SOS
// fill file array with backup
  fillFileList(RESTOREPAGE);                                          // fills mFileList and mFileListCount; sorted
// find the last one                                                  // last one (highest number) is mFileList[0]
  Serial.println("resetBackupFiles list loaded. list above");
  Serial.print("mFileList[0]: ");Serial.println(mFileList[0]);

// rename to 0.SOS
  if (SD.exists(mFileList[0]) && strcmp(mFileList[0],"0.SOS") != 0){  // if there are backup files and first one is not 0.SOS (ie. 0.SOS in not the only file)
    if (SD.exists("0.SOS")){                                          // delete the old 0.SOS because we're making a new one
      Serial.println("removing old 0.SOS");
      SD.remove("0.SOS");  
    }
    Serial.print("renaming: ");Serial.println(mFileList[0]);
    SD.rename(mFileList[0],"0.SOS");

    // delete all remaining files
    for (byte n=1;n<mFileListCount;n++){
      if (SD.exists(mFileList[n])){
        SD.remove(mFileList[n]);
        Serial.print("Deleting: ");Serial.println(mFileList[n]);
      }
    }
  }
  


  // DEBUG
  fillFileList(RESTOREPAGE);                              // fills mFileList and mFileListCount; sorted
  Serial.println("resetBackupFiles list loaded again. list above");
}
/*
 * 
 * "constuctor"
 * 
 */
void ssFileHelper_begin(){
  if (!ssFileHelper_getRoot()){               // gets the root of the SD card for future file calls; if it fails there is no SD card
     
  }
  resetBackupFiles();
  if (ssSettings_getGlobalLoadLastBackup()){        // if settings says load last project
    if (!ssFileHelper_loadLastBackup()) {           // load the last back up
      ssSettings_createNewProject();                // if it fails (e.g. no SD card or backup file, then just load a new project
    }
  } else {
    ssSettings_createNewProject();                  // or if settings says don't load last project, load new project
  }
}
bool ssFileHelper_getRoot(){
  if (_sdActive) {
    if (!_root) {
      _root = SD.open("/");
    }
    return true;
  } else {
    ssDisplayUI_showPopupMessage(str_ERROR,str_NOSDCARD,3);
    return false;
  } 
}

/*
 * 
 *  UI Event Handlers
 * 
 */
void ssFileHelper_showFilePage(byte page){        // page is either FILEPAGE or RESTOREPAGE
  mFilePage = page;                               // show the file load UI
 
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);

  fillFileList(mFilePage);                        // load the file list cache for the page type; this gets used by future UI functions
  mTimeStamp = millis();
  if (mFileListCount == 0){
    if (mFilePage == FILEPAGE){
      ssDisplayUI_showPopupMessage(str_ERROR,str_NOFILES,3);
    } else {
      ssDisplayUI_showPopupMessage(str_ERROR,str_NOBACKUPS,3);        
    }
    return;
  }

  mSelectionFileIndex = 0;                        // reset the SelectionFileIndex
  if (mFilePage == FILEPAGE) {                    // print the header line based on Load or Restore
    ssPanel.display.print(str_SELECTPROJECT);
    showFileSelection();                            
  } else {
    ssPanel.display.print(str_SELECTBACKUP);  
    showRestoreSelection();  
  }
}
void showRestoreSelection(){                             // show current selectable file by mSelectionFileIndex
  char ageStr[15];
  float age = (int(mTimeStamp/100) - atoi(mFileList[mSelectionFileIndex]))/600.0;
  dtostrf(age, 1, 1, ageStr);
  strcat(ageStr," mins ago");
  printFileInfo(ageStr);                            // show the name
  Serial.print("showRestoreSelection: ");Serial.println(mFileList[mSelectionFileIndex]);
}
void showFileSelection(){                             // show current selectable file by mSelectionFileIndex
  char fileName[13];
  strcpy(fileName,mFileList[mSelectionFileIndex]);    // copy the current "selected" filename in local variable
  ssFileHelper_trimFileExtension(fileName);           // trim the extention so the name is friendly
  printFileInfo(fileName);                            // show the name
}
void printFileInfo(char* str){
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print("<              >");
  ssPanel.display.setCursor(7 - strlen(str)/2,1);
  ssPanel.display.print(str);
}
void ssFileHelper_handleKnobBtnEvent(bool isDown, bool inShift){
  if (isDown) {                            // only care about down event
    if (inShift){
      // ssDisplayUI_loadPanelPage(DEFAULT);  // if shift, cancel file operation and back out to DEFAULT     
    } else {
      //Serial.print(F("going to try to load:"));Serial.println(mFileList[mSelectionFileIndex]);
      if (loadFileDataExt(mFileList[mSelectionFileIndex])){
        char projectName[13];
        ssSettings_getProjectName(projectName);                           // if file loaded successfully copy the filename into projectName
        ssFileHelper_trimFileExtension(projectName);                      // trim off extention to make it friendly

        //Serial.print(F("project name:"));Serial.println(projectName);
        if (mFilePage == FILEPAGE){                                       // display success based on Load or Restore
          ssDisplayUI_showPopupMessage(str_LOADED,projectName,3);  
        } else {
          ssDisplayUI_showPopupMessage(str_RESTORED,projectName,3);  
        }
      } else {
        ssDisplayUI_showPopupMessage(str_ERROR,str_LOADINGPROJECT_ERROR,3);
      }
    }
  }
}

void ssFileHelper_handleKnobTurnEvent(int delta){   // this adjust mSelectionFileIndex based on knob rotation, then calls the ui update
  if (delta > 0){
    mSelectionFileIndex++;
    if (mSelectionFileIndex >= mFileListCount) mSelectionFileIndex = 0;
  } else {
    mSelectionFileIndex--;
    if (mSelectionFileIndex > MAXNUMOFFILES) mSelectionFileIndex = mFileListCount - 1;      // mSelectionFileIndex is a BYTE so -1 becomes 255 which is greater than MAXNUMOFFILES
  }
  if (mFilePage == FILEPAGE){
    showFileSelection();
  } else {
    showRestoreSelection();
  }
}



/*
 * 
 *    SORT FUNCTIONS
 *    
 *
 */
void sortFileArray(bool reverse){   
  int innerLoop ;
  int mainLoop ;
  Serial.print("sort type:");
  if (reverse){
    Serial.println("reverse");
  } else {
    Serial.println("forward");
  }
  Serial.println("before");
  DEBUG_printFileArray();


  for ( mainLoop = 1; mainLoop < mFileListCount; mainLoop++){
    innerLoop = mainLoop;
    while (innerLoop  > 0){
      if ((mFileList[innerLoop][0] == '_') == (mFileList[innerLoop - 1][0] == '_')) {   // if they both start with _ OR both not start with _ then do a regular sort
        if (reverse){
          if (strcmp(mFileList[innerLoop - 1],mFileList[innerLoop]) < 0){ 
            switchArray(innerLoop);
          }          
        } else {
          if (strcmp(mFileList[innerLoop - 1], mFileList[innerLoop]) > 0){ 
            switchArray(innerLoop);
          } 
        } 
      } else {
        if (mFileList[innerLoop - 1][0] == '_') {
          switchArray(innerLoop);
        }
      }
      innerLoop--;
    }
  }
  Serial.println("after");
  DEBUG_printFileArray();
}
 
void switchArray(byte value){
 char tempStr[16];
 strcpy(tempStr, mFileList[value - 1]);
 strcpy(mFileList[value - 1], mFileList[value]);
 strcpy(mFileList[value], tempStr);
}
bool strStartsWith(const char * str, const char * startsWithStr){
  byte count = 0;
  for (byte i=0;i<strlen(startsWithStr);i++){
    if (str[i] == startsWithStr[i]) { count++; }   
  }
  return count == strlen(startsWithStr);
}
bool strEndsWith(const char * str, const char * endsWithStr){
  byte count = 0;
  for (byte i=0; i<strlen(endsWithStr);i++){
    if (str[strlen(str) - 1 - i] == endsWithStr[strlen(endsWithStr) - 1 - i]) { count++; }   
  }
  return count == strlen(endsWithStr);
}

char *dtostrf (double val, signed char width, unsigned char prec, char *sout) {
  char fmt[20];
  sprintf(fmt, "%%%d.%df", width, prec);
  sprintf(sout, fmt, val);
  return sout;
}

//DEBUG
void DEBUG_printFileArray(){
  for (byte t=0;t<mFileListCount;t++){
    Serial.println(mFileList[t]);
  }
}
