// **********************************************
// *
// *    display functions
// *
// **********************************************

void ssDisplayUI_showPopupMessage(const char a[],const char b[],byte delay){
  ssDisplayUI_showPopupMessage(a,b,delay,DEFAULT);
}
void ssDisplayUI_showPopupMessage(const char a[],const char b[],byte delay, byte rtnPage){
  _rtnPage = rtnPage; 
  ssDisplayUI_loadPanelPage(rtnPage);
  _inPopup = true;
  ssPanel.showPopupMessage(a,b,delay);
}
void ssDisplayUI_showYesNoDialog(byte confirmPage, const char msg[]){
  _confirmPage = confirmPage;
  if (ssSettings_getConfirmDeletes()){
    _panelPage = OPTIONDIALOG;
    ssPanel.showOptionDialog(TWOOPTDIALOG,msg,str_YES_OPTION,str_NO_OPTION);
  } else {
    ssDisplayUI_handleReturnFromDialog(true);
  }
}
void ssDisplay_enterKeyboard(){
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(topKeys);
  ssPanel.display.setCursor(0,1);
  ssPanel.display.print(botKeys);         
}
void ssDisplay_exitKeyboard(){
  ssDisplayUI_loadPanelPage(_panelPage);  
}

void ssDisplay_displayMidiNote(byte note, bool on){

  byte pos = noteToPosition[note%12];     // look up note to position map; values greater than 20 are top row (black keys)
  
  if (pos > 19) {                         // black key
    pos -= 20;                            // get rid of +20 index for black keys making it a true position value
  Serial.println(pos);
    switch (pos){
      case 0:
      case 3:
        if (note % 24 > 11) { pos += 7; }       // make the note position span 2 octaves
        ssPanel.display.setCursor(pos,0);
        if (on){
          ssPanel.display.print(5);
          ssPanel.display.print(7);
        } else {
          ssPanel.display.print(2);
          ssPanel.display.print(4);
        }
        break;
      case 1:
      case 5:
        if (note % 24 > 11) { pos += 7; }       // make the note position span 2 octaves
        ssPanel.display.setCursor(pos,0);
        if (on){
          ssPanel.display.print((char)0);     
          ssPanel.display.print(6);     
        } else {
          ssPanel.display.print(4);  
          ssPanel.display.print(3);  
        }  
        break;
      case 4:
        if (note % 24 > 11) { pos += 7; }       // make the note position span 2 octaves
        if (on){
          ssPanel.display.setCursor(pos,0); 
          ssPanel.display.print((char)0);   
          ssPanel.display.print(7);  
        } else {
          ssPanel.display.setCursor(pos,0);
          ssPanel.display.print(4);     
          ssPanel.display.print(4);
        }     
        break;  
    }
  } else {            // white key
    if (note % 24 > 11) { pos += 7; }       // make the note position span 2 octaves
    ssPanel.display.setCursor(pos,1);
    if (on) {
      ssPanel.display.print(255);
    } else {
      ssPanel.display.print(1);
    }
  }
}
void ssDisplay_handleTrackChange(){
  ssDisplayUI_updateTrackDisplay();
}
void ssDisplay_handlePlay(bool inPlay){

}
void ssDisplayUI_handleStop(){
  ssDisplayUI_updateStepDisplay();
  ssDisplayUI_updatePanelPage(_panelPage);         // reset UI to stop state
  ssDisplayUI_loadPanelPage(DEFAULT);              // TODO: are there exceptions to this?
}
void ssDisplayUI_setPanelPage(byte page){
  _panelPage = page; 
}
void ssDisplayUI_loadPanelPage(byte page){
  if (_inPopup) { return; }
  switch(page){
    case DEFAULT:
      if (_inLock > 0){
        if (_inLock == SOLOLOCK) {ssDisplayUI_loadPanelPage(SOLOPAGE);}
        if (_inLock == MUTELOCK) {ssDisplayUI_loadPanelPage(MUTEPAGE);}
        if (_inLock == STEPLOCK) {ssDisplayUI_loadPanelPage(STEPEDIT);}
        if (_inLock == PATCHLOCK) {ssDisplayUI_loadPanelPage(PATCHSELECT);}
        break;
      }
      _panelPage = DEFAULT;
      loadDefaultPage();
      break;
    case BARJUMP:
      _panelPage = BARJUMP;
      ssPanel.showToolTip(str_JUMPTOBAR);
      break;    
    case BARLENGTH:
      _panelPage = BARLENGTH;
      ssPanel.showToolTip(str_NUMOFBARS);
      loadBarLengthPage();
      break;
    case STEPJUMP:
      _panelPage = STEPJUMP;
      ssPanel.showToolTip(str_JUMPTOSTEP);
      break;   
    case STEPEDIT:
      _panelPage = STEPEDIT;
      // ssPanel.showToolTip(str_STEPEDIT);
      ssStepEdit_showStepEditPage();
      break;
    case NOTEMIDIMAP:
      _currentMidiPort = 0;
      _panelPage = NOTEMIDIMAP;
      ssPanel.showToolTip(str_MIDICHANNELS);
      showMidiChannels();
      break;
    case PATCHSELECT:
      _panelPage = PATCHSELECT;
      ssMidiHelper_showPatchSelectPage();
      break;
    case DMAPSELECT:
      _panelPage = DMAPSELECT;
      ssPanel.showToolTip(str_SELECTDRUMMAP);
      ssSettings_showDrumMapSelectPage();
      break;      
    case COPYTRACK:
      _panelPage = COPYTRACK;
      ssPanel.showToolTip(str_COPYBNKTRK);
      _bankTrackCopyBank = _currentBank;
      showCopyBankTrackSelectStep();
      break;
    case COPYDRUMS:
      _panelPage = COPYDRUMS;
      ssPanel.showToolTip(str_COPYDRUMS);
      _bankTrackCopyBank = _currentBank;
      _copyDrumsBank = true;
      showCopyBankTrackSelectStep();
      break;    
    case COPYBANK:
      _panelPage = COPYBANK;
      ssPanel.showToolTip(str_COPYBANK);
      _copyDrumsBank = false;
      showCopyBankSelectBank();
      break;
    case SOLOPAGE:
      _panelPage = SOLOPAGE;
      if (_inLock == 1){
        ssPanel.showToolTip(str_SOLOTRACKS_LOCK);
      } else {
        ssPanel.showToolTip(str_SOLOTRACKS);
      }
      _muteSoloEditBank = _currentBank;
      ssMuteSolo_showSoloState();
      break;
    case MUTEPAGE:
      _panelPage = MUTEPAGE;
      if (_inLock == 2){
        ssPanel.showToolTip(str_MUTETRACKS_LOCK);
      } else {
        ssPanel.showToolTip(str_MUTETRACKS);
      }
      _muteSoloEditBank = _currentBank;
      ssMuteSolo_showMuteState();
      break;
    case SETTINGS:
      _panelPage = SETTINGS;
      ssSettings_showSettings();
      break;
    case FILEPAGE:
      _panelPage = FILEPAGE;
      ssFileHelper_showFilePage(FILEPAGE);
      break;
    case RESTOREPAGE:
      _panelPage = RESTOREPAGE;
      ssFileHelper_showFilePage(RESTOREPAGE);
      break;
    case SAVEDMAP:
      _panelPage = SAVEDMAP;
      ssSettings_showSaveDrumMapPage();
      break;
    case ROBOTPAGE1:
      _panelPage = ROBOTPAGE1;
      ssPanel.showToolTip(str_ROBOTSETTINGS);
      ssRobot_showSettingsPage(ROBOTPAGE1);
      break;
    case ROBOTPAGE2:
      _panelPage = ROBOTPAGE2;
      ssPanel.showToolTip(str_ROBOTSETTINGS);
      ssRobot_showSettingsPage(ROBOTPAGE2);
      break;
    case ROBOTPLEN:
      _panelPage = ROBOTPLEN;
      ssRobot_showPLenPage();
      break;
    case ROBOTPROB:
      _panelPage = ROBOTPROB;
      ssRobot_showProbPage();
      break;
    case ROBOTCOMPLEX:
      _panelPage = ROBOTCOMPLEX;
      ssRobot_showComplexPage();
      break;
    case ROBOTSCALE:
      _panelPage = ROBOTSCALE;
      ssRobot_showScalePage();
      break;
    case ROBOTCHORD:
      _panelPage = ROBOTCHORD;
      ssRobot_showChordPage();
      break;
    case VMAPHIT:
      _panelPage = VMAPHIT;
      ssSequencer_showVMapHitPage();
      break;
    case VMAPACCENT:
      _panelPage = VMAPACCENT;
      ssSequencer_showVMapAccentPage();
      break;
    case STEPRECORD:
      _panelPage = STEPRECORD;
      updateRedGreenLEDStepState();
      ssPanel.showToolTip(str_STEPRECORD);
      break;
    case SETSHORTCUT:
      _panelPage = SETSHORTCUT;
      ssSettings_showShortcutPage();
      break;
    case SWINGVALUE:
      _panelPage = SWINGVALUE;
      ssSettings_showSwingValuePage();
      break;
  }
}

void ssDisplayUI_updatePanelPage(byte page){
  switch(page){
    case DEFAULT:
      updateDefaultPage();
      break;
    case BARJUMP:
    case STEPJUMP:
      ssDisplayUI_updateStepDisplay();
      updateRedGreenLEDStepState(); 
      break;
    case STEPEDIT:
      ssStepEdit_updateStepEditPage();
      break;
    case BARLENGTH:
      loadBarLengthPage();
      break;
    case NOTEMIDIMAP:
      showMidiChannels();
      break;
    case PATCHSELECT:
      ssMidiHelper_updatePatchSelectPage();
      break;
    case COPYTRACK:
      showCopyBankTrackSelectStep();
      break;
    case COPYDRUMS:
      showCopyBankSelectBank();
      break;
    case COPYBANK:
      showCopyBankSelectBank();
      break;
    case SOLOPAGE:
      ssClockHelper_updateTempoDisplay(ssSettings_getTempo());
      ssMuteSolo_showSoloState();
      break;
    case MUTEPAGE:
      ssClockHelper_updateTempoDisplay(ssSettings_getTempo());
      ssMuteSolo_showMuteState();
      break;
    case ROBOTPAGE1:
      ssRobot_updateSettingsPage(ROBOTPAGE1);
      break;
    case ROBOTPAGE2:
      ssRobot_updateSettingsPage(ROBOTPAGE2);
      break;
    case SETSHORTCUT:
      ssSettings_updateShortcutPage();
      break;
    case SWINGVALUE:
      ssSettings_updateSwingValuePage();
      break;
  }
}
void ssDisplayUI_handleReturnOfPopup(){
  _inPopup = false;
  ssDisplayUI_loadPanelPage(_rtnPage);
  _rtnPage = DEFAULT;
}

void ssDisplayUI_handleReturnFromDialog(bool rtnYes){
  switch(_confirmPage){
    case CLEARALL:
      if (rtnYes) { 
        ssSequencer_clearAllData(); 
        ssDisplayUI_showPopupMessage(str_ALLDATA,str_CLEARED,3);
      } else {
        ssDisplayUI_showPopupMessage(str_CLEARCANCELLED,"",3);
      }
      break;
    case CLEARBANK:
      if (rtnYes) { 
        ssSequencer_clearBank(); 
        ssDisplayUI_showPopupMessage(str_BANKCLEARED,"",3);
      } else {
        ssDisplayUI_showPopupMessage(str_CLEARCANCELLED,"",3);
      }
      break;
    case CLEARDRUMS:
      if (rtnYes) { 
        ssSequencer_clearDrums(); 
        ssDisplayUI_showPopupMessage(str_DRUMSCLEARED,"",3);
      } else {
        ssDisplayUI_showPopupMessage(str_CLEARCANCELLED,"",3);
      }
      break;
    case CLEARTRACK:
      if (rtnYes) { 
        ssSequencer_clearTrack(); 
        ssDisplayUI_showPopupMessage(str_TRACKCLEARED,"",3);
      } else {
        ssDisplayUI_showPopupMessage(str_CLEARCANCELLED,"",3);
      }
      break;
    case CLEARNEW:
      if (rtnYes) { 
        if (ssFileHelper_fileDirty()){
          ssFileHelper_saveProject();
          ssSequencer_newProject();    
          ssDisplayUI_showPopupMessage(str_PROJECTSAVED,str_NEWPROJECT,3);
        } else {
          ssSequencer_newProject();
          char projectName[13];
          ssSettings_getProjectName(projectName);
          ssFileHelper_trimFileExtension(projectName);
          ssDisplayUI_showPopupMessage(str_NEWPROJECT,projectName,3);
        } 
      } else {
        ssSequencer_newProject();
        ssDisplayUI_showPopupMessage(str_NEWPROJECT,"",3);
      }
      break;                 
  }
  ssClockHelper_setRecLED(_inRec);        // reset the play and record LEDs to correct state
  ssClockHelper_setPlayLED(_inPlay);
  _confirmPage = NOCONFIRM;
}

void showCopyBankSelectBank(){
  for (byte b=0;b<4;b++){
    ssPanel.setPoint(ROW_BANKAUX,SOLID,b,OFF);   
    if (b == _currentBank){
      ssPanel.setPoint(ROW_BANKAUX,BLINK,b,OFF);
    } else {
      ssPanel.setPoint(ROW_BANKAUX,BLINK,b,ON);      
    }
  }  
}
void showCopyBankTrackSelectStep(){
  for (byte b=0;b<4;b++){
    ssPanel.setPoint(ROW_BANKAUX,SOLID,b,OFF);   
    if (b == _bankTrackCopyBank){
      ssPanel.setPoint(ROW_BANKAUX,BLINK,b,ON);
    } else {
      ssPanel.setPoint(ROW_BANKAUX,BLINK,b,OFF);      
    }
  }
}

void ssDisplayUI_gotoLock(byte lock){
  _inLock = lock;
  ssPanel.setPoint(ROW_CTRLS,SOLID,0,OFF);
  ssPanel.setPoint(ROW_CTRLS,SOLID,1,OFF);
  ssPanel.setPoint(ROW_CTRLS,SOLID,3,OFF);
  ssPanel.setPoint(ROW_CTRLS,SOLID,5,OFF);
  switch (lock){
    case 1:
      ssPanel.setPoint(ROW_CTRLS,SOLID,0,ON);
      break;
    case 2:
      ssPanel.setPoint(ROW_CTRLS,SOLID,1,ON);
      break;
    case 3:
      ssPanel.setPoint(ROW_CTRLS,SOLID,3,ON);
      break;
    case 4:
      ssPanel.setPoint(ROW_CTRLS,SOLID,5,ON);
      break;
    case 5:
      break;  
  }
  ssMuteSolo_updateLedStatus();
}

void resetBankTrackCopy(){
  _bankTrackCopyBank = 0;
}

void loadBarLengthPage(){
  ssDisplayUI_updateStepDisplay();
  ssPanel.setBar(ROW_GRN,SOLID,ssSettings_getBankLength(_currentBank));
  ssPanel.clearRow(ROW_RED);
  ssPanel.clearRow(ROW_YLW);
}
void showMidiChannels(){
  for (byte b=0;b<4;b++){                                                   // show the MIDI port on the blue bank LEDs
    ssPanel.clearPoint(ROW_BANKAUX,BLU1BTNLEN + b);  
  }

  ssPanel.setPoint(ROW_BANKAUX,BLINK,BLU1BTNLEN + _currentMidiPort,ON);
  
  if (_inTrigger){                                                          // show the MIDI channel on the red leds
    showTriggerTrackMidiChannels();  
  } else {
    showNoteTrackMidiChannels();    
  }
}
void showNoteTrackMidiChannels(){
  if (!_showSuperTriggerUI){
    uint32_t trackMidiChannels = ssSettings_getMidiTrackMap(_currentNoteTrack);
    ssPanel.setLEDBits(ROW_GRN,SOLID,trackMidiChannels >> 16);                                  // MIDI port 1
    ssPanel.setLEDBits(ROW_RED,SOLID,trackMidiChannels & 0xFFFF);                               // MIDI port 2
  }
}
void showTriggerTrackMidiChannels(){
  uint32_t trackMidiChannels = ssSettings_getMidiTriggerMap(_currentTriggerTrack);
  ssPanel.setLEDBits(ROW_GRN,SOLID,trackMidiChannels >> 16);                                  // MIDI port 1
  ssPanel.setLEDBits(ROW_RED,SOLID,trackMidiChannels & 0xFFFF);                               // MIDI port 2
}
void loadDefaultPage(){               // page loads update all page state
  ssPanel.display.clear();
  ssPanel.display.setCursor(0,0);
  ssPanel.display.print(str_TEMPOCOLON);
  ssClockHelper_updateTempoDisplay(ssSettings_getTempo(),true);

  char projectName[13];
  ssSettings_getProjectName(projectName);
  ssFileHelper_trimFileExtension(projectName);
  
  ssPanel.display.setCursor(1,1);
  ssPanel.display.print(projectName);
  if (ssFileHelper_fileDirty()){
    ssPanel.display.setCursor(0,1);
    ssPanel.display.print("*");
  }
    
  EventCount ec = ssNoteData.getEventUsage();
  if (ec.used + 1000 > ec.total){
    ssPanel.display.setCursor(1,1);
    ssPanel.display.print(" ");
    char tmp[8];
    itoa(ec.used,tmp,10);
    ssPanel.display.print(tmp);
    ssPanel.display.print("/");
    itoa(ec.total,tmp,10);
    ssPanel.display.print(tmp);    
  }

  ssDisplayUI_updateBankDisplay();
  ssDisplayUI_updateStepDisplay();
  ssDisplayUI_updateTrackDisplay();
  ssDisplayUI_updateRobotDisplay();
  resetBankTrackCopy();

}
void updateDefaultPage(){   // page updates only update async changes
  ssClockHelper_updateTempoDisplay(ssSettings_getTempo());
  char projectName[13];
  ssSettings_getProjectName(projectName);
  ssFileHelper_trimFileExtension(projectName);
  ssPanel.display.setCursor(1,1);
  ssPanel.display.print(projectName);
  ssPanel.display.setCursor(0,1);
  if (ssFileHelper_fileDirty()){
    ssPanel.display.print("*");
  }
  ssDisplayUI_updateStepDisplay();
}

void ssDisplayUI_begin(){
  ssPanel.display.createChar(1, whiteKey);
  ssPanel.display.createChar(2, blackKeyLeft);
  ssPanel.display.createChar(3, blackKeyRight);
  ssPanel.display.createChar(4, blackKeyBoth);
  ssPanel.display.createChar(5,blackKeyLeftPress);
  ssPanel.display.createChar(6,blackKeyRightPress);
  ssPanel.display.createChar(7,blackKeyLeftBothPress);
  ssPanel.display.createChar(0,blackKeyRightBothPress);
 
  ssDisplayUI_loadPanelPage(DEFAULT);
}
void ssDisplayUI_updateStepDisplay(){
  int cs = _currentStep;
  if (cs == -1) { cs = 0; }
  
  byte dot1 = 2;
  byte dot2 = 2;
  switch((cs%16)/4) {
    case 0:
      dot1 = 0;
      dot2 = 2;
      break;
    case 1:
      dot1 = 1;
      dot2 = 2;
      break;
    case 2:
      dot1 = 2;
      dot2 = 0;
      break;
    case 3:
      dot1 = 2;
      dot2 = 1;
      break;
  }
  ssPanel.display.segmentSetDigit(0,cs/16 + 1,true,dot1);
  ssPanel.display.segmentSetDigit(1,ssSettings_getBankLength(_currentBank),true,dot2);

  if (_panelPage == DEFAULT || _panelPage == STEPRECORD){ updateRedGreenLEDStepState(); }     // TODO: wrong way to do this
  else if (_panelPage == STEPEDIT){ ssStepEdit_showStepEditLeds(); }
}
void ssDisplayUI_updateBankDisplay(){
  ssDisplayUI_updateStepDisplay();
  for (byte b=0;b<4;b++){
    ssPanel.clearPoint(ROW_BANKAUX,BLU1BTNLEN + b);  
    if (b == _currentBank){
      ssPanel.setPoint(ROW_BANKAUX,SOLID,b,ON);  
    } else if (b != _currentBank && b == _nextBank){
      ssPanel.setPoint(ROW_BANKAUX,BLINK,b,ON);  
    }
  }
}
void ssDisplayUI_updateRobotDisplay(){
  ssRobot_updateRobotCtrlLED();
}
void ssDisplayUI_updateTrackDisplay(){
  if (_inTrigger){
    ssPanel.display.segmentSetDigit(3,_currentTriggerTrack + 1,true,2);   
    ssPanel.display.printChr(4,11);  // d
    ssPanel.display.printChr(3,13);  // r
  } else {
    ssPanel.display.segmentSetDigit(3,_currentNoteTrack + 1,false,2);
    ssPanel.display.printChr(4,14);  // space
    ssPanel.display.printChr(3,12);  // t
    ssPanel.display.printChr(2,13);  // r
  }

  if (_showSuperTriggerUI) {
    if (_inTrigger){
      ssPanel.setPoint(ROW_YLW,SOLID,_currentTriggerTrack,ON,EXCL);
    } else {
      ssPanel.setLEDBits(ROW_YLW,SOLID,0X0000);
    }
  } else {
    ssPanel.normal(ROW_YLW);
    if (_inTrigger){
      ssPanel.setPoint(ROW_YLW,SOLID,_currentTriggerTrack + 8,ON,EXCL);
    } else {
      ssPanel.setPoint(ROW_YLW,SOLID,_currentNoteTrack,ON,EXCL);
    }
  }
}

void updateRedGreenLEDStepState(){
  ssDisplayUI_resetRedGrnLEDS();
  
  int cs = _currentStep;
  if (cs == -1) { cs = 0; }
  if (ssSettings_getRedLedDisplay() & 0b01 || _panelPage == STEPRECORD) { ssPanel.setPoint(ROW_RED,SOLID,cs % 16,ON,EXCL); }
  ssPanel.setPoint(ROW_GRN,SOLID,cs / 16,ON,EXCL);
}


void ssDisplayUI_resetRedGrnYlwLEDS(){
  ssPanel.clearRow(ROW_RED);
  ssPanel.clearRow(ROW_GRN);
  ssPanel.clearRow(ROW_YLW);
}
void ssDisplayUI_resetRedGrnLEDS(){
  ssPanel.clearRow(ROW_RED);
  ssPanel.clearRow(ROW_GRN);
}
void ssDisplayUI_resetBankLEDS(){
  for (byte b=0;b<4;b++){
    ssPanel.clearPoint(ROW_BANKAUX,BLU1BTNLEN + b);
  }
}
