/*
 * Clock API for SS1 sequencer
 */

#ifndef ssClockHelper_h
#define ssClockHelper_h

#include "Arduino.h"

#define INPHASE false
#define OUTPHASE true

#define CLOCKTYPE_INTERNAL    0
#define CLOCKTYPE_MIDI        1
#define CLOCKTYPE_EXTERNAL16  2
#define CLOCKTYPE_EXTERNAL8   3
#define CLOCKTYPE_EXT24PPQN   4

typedef void (*hStarted)(); 			
typedef void (*hStopped)(); 			
typedef void (*h32Note)(bool);		// bool - true notes out of phase event with longer interval (16th note) 			
typedef void (*h16Note)(bool); 			
typedef void (*h8Note)(bool); 			
typedef void (*h4Note)(bool); 			


class SSClock
{
  private:
  	byte mClockCounter;
  	float mTempo;
  	int mOffset;
  	byte mClockSourceType = CLOCKTYPE_INTERNAL;
    uint32_t mMicroTime;
    bool mClockRunning = false;
    uint32_t mClockPeriod;
    bool mSwingEnable = false;
    int  mSwing = 50;
    bool m16Swing = false;
  	
  	void mSetTempo(float t);
  	void mStartClock();
  	void mStopClock();
  	void m4Beat(bool);
  	void m8Beat(bool);
  	void m16Beat(bool);
  	void m32Beat(bool);
    void mAdvanceClock();
  	void mAdvanceClockTick();
    uint32_t  mLastSyncMicros = 0;
  	
  	hStarted 	raiseStartedEvent;
  	hStopped	raiseStoppedEvent;
  	h32Note		raise32NoteEvent;
  	h16Note		raise16NoteEvent;
  	h8Note		raise8NoteEvent;
  	h4Note		raise4NoteEvent;
	
  public:
    SSClock();
  	void begin(int t);
    void setClockSource(byte t);
  	void advanceClock();
    void advanceClockTick();
  	void setTempo(float t);
  	float getTempo();
    void swingEnable(bool);
    void setSwing(byte s);
    int  getSwing();
    void swingType(bool);
  	int  getOffset();
  	void clearOffset();
  	void start();
  	void stop();
    float sync();
  	
  	void setHandlerStarted(hStarted);
  	void setHandlerStopped(hStopped);;
  	void setHandler32Note(h32Note);
  	void setHandler16Note(h16Note);
  	void setHandler8Note(h8Note);
  	void setHandler4Note(h4Note);
	

	
};





#endif
