#include "Arduino.h"
#include "SSClock.h"

SSClock::SSClock() { 
	// constructor

}

void SSClock::begin(int t){
	mSetTempo(t);
}
void SSClock::advanceClock()                  { mAdvanceClock(); }
void SSClock::advanceClockTick()              { mAdvanceClockTick(); }
void SSClock::setClockSource(byte t)          { mClockSourceType = t; }
void SSClock::setTempo(float t) 					    { mSetTempo(t);    }
float SSClock::getTempo()						          { return mTempo;   }
void SSClock::swingEnable(bool e)             { mSwingEnable = e; }
void SSClock::setSwing(byte s)                { mSwing = s;      }
int  SSClock::getSwing()                      { return mSwing;   }
void SSClock::swingType(bool t)               { m16Swing = t;    }
void SSClock::start()							            { mStartClock();   }
void SSClock::stop()							            { mStopClock();    }
void SSClock::clearOffset()						        { mOffset = 0;     }
int  SSClock::getOffset()						          { return mOffset;  }

void SSClock::setHandlerStarted(hStarted p)		{ raiseStartedEvent = p; }
void SSClock::setHandlerStopped(hStopped p)		{ raiseStoppedEvent = p; }
void SSClock::setHandler32Note(h32Note p)		  { raise32NoteEvent = p;  }
void SSClock::setHandler16Note(h16Note p)		  { raise16NoteEvent = p;  }
void SSClock::setHandler8Note(h8Note p)			  { raise8NoteEvent = p;   }
void SSClock::setHandler4Note(h4Note p)			  { raise4NoteEvent = p;   }

float SSClock::sync(){                        // ssClock.sync(
  if (!mClockRunning) { return mTempo; }
  int outOfSyncOffSet;
  int modValue;
  switch (mClockSourceType){
    case CLOCKTYPE_EXTERNAL16:
      modValue = 12;            // 1/16 notes
      break; 
    case CLOCKTYPE_EXTERNAL8:
      modValue = 24;           // 1/8 notes
      break; 
    case CLOCKTYPE_EXT24PPQN:  // 24 ppqn
      modValue = 2;
      break;
  }
  outOfSyncOffSet = mClockCounter % modValue;
  if (outOfSyncOffSet > 5) { outOfSyncOffSet = outOfSyncOffSet - modValue; }

  mMicroTime += (outOfSyncOffSet * mClockPeriod);                             // magical math that adjust the clock to sync with the incoming external clock

  uint32_t tim = micros();
  uint32_t delta = tim - mLastSyncMicros;                                     // delta is the number of millis between incoming ext clock pulses
  mLastSyncMicros = tim;                                                      // store that for next time

  mClockPeriod = delta / modValue;
  
  mTempo = (1250000.0 / (float)mClockPeriod);
  return mTempo;
}

void SSClock::mSetTempo(float t){
	mTempo = t;
	mClockPeriod = (uint32_t)(60000000.0 / (t * 48.0));       // calculate period for given tempo for midi clock 48 pulses per quarter note; 60 / (tempo * 48) 
}
void SSClock::mStartClock(){
  mMicroTime = micros();
  mLastSyncMicros = micros();
  mClockCounter = 255;
  mOffset = 0;
  mClockRunning = true;
	if (raiseStartedEvent != NULL) { raiseStartedEvent(); }
}
void SSClock::mStopClock(){
	mClockRunning = false;
	if (raiseStoppedEvent != NULL) { raiseStoppedEvent(); }
}

void SSClock::mAdvanceClock(){
  if (!mClockRunning || (mClockSourceType == CLOCKTYPE_MIDI)){ return; }        // use the internal "tick" for everything except MIDI clock in

  uint32_t cTime = micros(); 
  if (cTime < mMicroTime) { mMicroTime = cTime; return;}                        // it's been 70 minutes clock flipped; TODO potentially skips a beat. oops.
  if (cTime > mMicroTime + mClockPeriod){                                       // if we've gone past a full clock period then
   mAdvanceClockTick();                                                         //  advance the clock
   mMicroTime += mClockPeriod;                                                  //  set microTime for the next clock period
  }
}

void SSClock::mAdvanceClockTick(){
	mClockCounter++;
	mOffset++;
  if (mClockCounter % 12  == 6)  { m32Beat(OUTPHASE);  }
	if (mClockCounter % 12  == 0)  { m32Beat(INPHASE); }

  if (mSwingEnable){
    int swingAdjst = (mSwing - 50) / 5;
    if (m16Swing) {
      if (mClockCounter % 48  == 36 + swingAdjst/2) { m16Beat(OUTPHASE);  }  // a
      if (mClockCounter % 48  == 24) { m16Beat(INPHASE);   }  // &
      if (mClockCounter % 48  == 12 + swingAdjst/2) { m16Beat(OUTPHASE);  }  // e
      if (mClockCounter % 48  == 0)  { m16Beat(INPHASE);   }  // 1    
    } else {
      if (mClockCounter % 48  == 36 + swingAdjst/2) { m16Beat(OUTPHASE);  }  // a
      if (mClockCounter % 48  == 24 + swingAdjst)   { m16Beat(INPHASE);   }  // &
      if (mClockCounter % 48  == 12 + swingAdjst/2) { m16Beat(OUTPHASE);  }  // e
      if (mClockCounter % 48  == 0)  { m16Beat(INPHASE);   }  // 1    
    }
  } else {
    if (mClockCounter % 24  == 12) { m16Beat(OUTPHASE);   }
    if (mClockCounter % 24  == 0)  { m16Beat(INPHASE);  }    
  }

  if (mClockCounter % 48  == 24) { m8Beat(OUTPHASE);   }
  if (mClockCounter % 48  == 0)  { m8Beat(INPHASE);  }
  
  if (mClockCounter % 96  == 48) { m4Beat(OUTPHASE);   }
	if (mClockCounter % 96  == 0)  { m4Beat(INPHASE);  mClockCounter = 0; mOffset = 0;}
}

void SSClock::m4Beat(bool outPhase){
	if (raise4NoteEvent != NULL) { raise4NoteEvent(outPhase); }
}
void SSClock::m8Beat(bool outPhase){
	if (raise8NoteEvent != NULL) { raise8NoteEvent(outPhase); }
}
void SSClock::m16Beat(bool outPhase){
	if (raise16NoteEvent != NULL) { raise16NoteEvent(outPhase); }
}
void SSClock::m32Beat(bool outPhase){
	if (raise32NoteEvent != NULL) { raise32NoteEvent(outPhase); }
}
