
byte mChordCurrentRootNote = 0xFF;
byte mChordCurrentRootVel = 0;
bool mChordLastHalfNote = false;
bool mChordLastRecorded = false;
byte mChordTrack = 0xFF;

// handle midi input

void ssChord_handleMidiNoteOn(KeyInputState kis){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();

  turnOffCurrentChord();

  if (rbtSettings.chord == CHORDCUSTOM){
    buildCustomChord(kis.note, true); 
  } else {
    mChordCurrentRootNote = kis.note;
    mChordCurrentRootVel = kis.velocity;
  }

  if (!_inPlay || rbtSettings.noteType == 8){ playChord(); }
}
void ssChord_handleMidiNoteOff(KeyInputState kis){
  RobotSettings rbtSettings = ssSettings_getRobotSettings();

  if (!rbtSettings.keyLatch) {
    turnOffCurrentChord(); 
    if (kis.note == mChordCurrentRootNote) { 
      mChordCurrentRootNote = 0xFF;
      mChordCurrentRootVel = 0;
    } else {
      buildCustomChord(kis.note,false);
    }
  }
}
void buildCustomChord(byte note, bool noteOn){
  KeyInputState kis;
  byte chordCount = 0;
  byte interval = 0;
  mChordCurrentRootNote = 0xFF;
  mChordCurrentRootVel = 0;
  for (byte i=0;i<128;i++){
    kis = ssMidiHelper_getKeyInputNoteState(i);
    if (kis.handler == CHORD && (noteOn || (i != note)) && chordCount < MAXNOTESINCHORD){         // the i!=note||noteOn is because at this point KeyInputNoteState has not been updated yet. so don't include the released note in the scale
      if (chordCount == 0) {
        mChordCurrentRootNote = i;
        mChordCurrentRootVel = kis.velocity;
        if (ssSettings_getRobotSettings().chord == CHORDCUSTOM){ chordIntervals[CHORDCUSTOM][chordCount + 1] = 0; }
      } else {
        interval = (i - mChordCurrentRootNote);       
        if (ssSettings_getRobotSettings().chord == CHORDCUSTOM){ chordIntervals[CHORDCUSTOM][chordCount + 1] = interval; }
      }
      chordCount++;
    }
  }
  if (ssSettings_getRobotSettings().chord == CHORDCUSTOM){
    chordIntervals[CHORDCUSTOM][0] = chordCount;
  }
}
void ssChord_playbackStep(byte bank, byte step, bool in32OutPhase){
  RobotSettings rsSettings = ssSettings_getRobotSettings();
  bool halfNote;
  if (_activeRobot != 2) return;
  if (mChordCurrentRootNote == 0xFF) { return; }
  if (rsSettings.noteType == 6){ return; }                                                   // Rhythm Off
  
  if (rsSettings.noteType == 5){                                                             // if in Rhythm13 then do nothing, halfNote was set by accent of previous step, else use setting
    halfNote = mChordLastHalfNote;
  } else {
    halfNote = rsSettings.noteLength;                                                        // halfNote: true == stacato(1) or false == legato(0)  
  }
  byte noteLenSteps = 1 << (4 - rsSettings.noteType);                                        // noteLenSteps 1/16 = B1 = 1; 1/8 = B10 = 2; 1/4 = B100 = 4; 1/2 = B1000 = 8   

  // turn off previous note                                                                                            
  if (in32OutPhase){                                                                          // this handles stacato 1/16 notes by using 32 note clock (in32OutPhase)
    if (halfNote && (rsSettings.noteType == 4 || rsSettings.noteType == 5)) {               // if playing 1/16 notes or Rhythm13 and stacato then we cut the note off on the out of phase 32 note
      turnOffCurrentChord(in32OutPhase);
    }
    return;                                                                                  // this is the only thing we do outPhase
  } 
  if (halfNote && (noteLenSteps > 1) && (step % noteLenSteps == noteLenSteps/2)) {           // if non- 1/16 note stacato and we are half way though the note length; turn off note 
    turnOffCurrentChord();
    return;                                                                                  // only play arp notes on note type (in arp settings), we are only 1/2 way there
  } 

  if (rsSettings.noteType == 5){     // Rhythm 13
    TrigEvent te = ssTrigData.getTrigEvent(_currentBank, 12, _currentStep);              // get current step trigger data for current bank, drum track 13
    if (!te.trigger)  {                                                                       // not a trigger hit, don't play a trigger, return
      return; 
    } 
    mChordLastHalfNote = te.accent;                                                          // use accent to determine legato (no accent) or stacato (accent)    
  } else {
    if (step % noteLenSteps != 0) {  
      return;                                                                                 // return on any other "wrong" step - only play arp notes on note type (in arp settings)
    }    
  }

  turnOffCurrentChord();                                                                    // if in legato, and we've gotten this far we are on the next step, turn of previous note before playing next
  playChord();  
}
void playChord(){
  if (mChordCurrentRootNote > 127) { return; }
  if (!ssMuteSolo_trackFilter(_currentBank, mChordTrack)) { return; }

  //Serial.print("root:");Serial.print(mChordCurrentRootNote);Serial.print("::");
  byte curChord = ssSettings_getRobotSettings().chord;
  
  for (byte n=0;n<chordIntervals[curChord][0];n++){
    int note = mChordCurrentRootNote + chordIntervals[curChord][n + 1];
    if (note >= 0 && note < 128) {
      //Serial.print(note);Serial.print(",");
      ssMidiHelper_sendTrackNote(mChordTrack,note, mChordCurrentRootVel, ON, SEQ);  
      if (_inRec && _inPlay && ssChord_onChordTrack()) {
        ssNoteData.addEvent(_currentStep*2,_currentBank,mChordTrack,1,note,mChordCurrentRootVel, false);
        mChordLastRecorded = true;
        ssFileHelper_makeFileDirty(45);
      } 
    } 
  }
  //Serial.println();
}

void turnOffCurrentChord(){
  turnOffCurrentChord(false);  
}
void turnOffCurrentChord(bool recordOnly){
  bool tmp = mChordLastRecorded;
  if (mChordCurrentRootNote == 0xFF && !mChordLastRecorded){ return; }
  byte curChord = ssSettings_getRobotSettings().chord;
  for (byte n=0;n<chordIntervals[curChord][0];n++){
    int note = mChordCurrentRootNote + chordIntervals[curChord][n + 1];
    if (note >= 0 && note < 128) {
      if (!recordOnly) { ssMidiHelper_sendTrackNote(mChordTrack, note, 0, OFF, SEQ);  }
      if (mChordLastRecorded) {
        ssNoteData.addEvent(_currentStep*2,_currentBank,mChordTrack,2,note,0, false);
        ssFileHelper_makeFileDirty(46);
        tmp = false;
      }  
    }
  }
  mChordLastRecorded = tmp;
}

void ssChord_setChordTrack(byte track){
  mChordTrack = track;
}
byte ssChord_getChordTrack(){
  return mChordTrack;
}
void ssChord_begin(){

}
void ssChord_makeActiveRobot(){
  if (_activeRobot != 2){             // if not already active robot
    mChordTrack =  _currentNoteTrack;
    _activeRobot = 2;
    RobotSettings rsSettings = ssSettings_getRobotSettings();
    rsSettings.keyLatch = false;
    rsSettings.noteType = 8;
    ssSettings_setRobotSettings(rsSettings);
  }  
}
void ssChord_chordModeOff(){
  turnOffCurrentChord();
  mChordTrack = 0xFF;
  _activeRobot = 0xFF;
}

bool ssChord_onChordTrack(){
  return !_inTrigger && (mChordTrack == _currentNoteTrack) && _activeRobot == 2;;
}


void ssChord_handleStop(){
  turnOffCurrentChord();
  mChordCurrentRootNote = 0xFF;
  mChordCurrentRootVel = 0;
}

void ssChord_handlePlay(bool inPlay){
  if (!inPlay){                           // if paused
    turnOffCurrentChord();   
  }
}

void ssChord_handleRec(bool inRec){
  if (!inRec){
    turnOffCurrentChord(true);  
  }
}
