
byte mArpArray[36];
byte mArpNoteCount = 0;
byte mArpKeyCount = 0;
int  mArpIndex = 0;
bool mArpUpDirection = true;
bool mArpLastHalfNote = false; 
bool mArpDoubleNotePhase = false;
byte mArpNoteToDouble = 0xFF;
byte mArpTrack = 0xFF;
byte mArpCurrentNote = 0xFF;
byte mArpNoteVelocity = 0xFF;
bool mArpCurrentNoteRecorded = false;
byte mArpTransposeNote = 0xFF;

// handle midi input

void ssArp_handleMidiNoteOn(KeyInputState kis){
  RobotSettings rsSettings = ssSettings_getRobotSettings();

  if (rsSettings.keyLatch && rsSettings.transpose){
    if (mArpNoteCount > 0) { mArpTransposeNote = kis.note; }
  } else {
    buildArpArray(kis, true);                  // everytime a note is added on the keyboard rebuild ArpArray
  }
}
void ssArp_handleMidiNoteOff(KeyInputState kis){
  RobotSettings rsSettings = ssSettings_getRobotSettings();
  
  if (!rsSettings.keyLatch) {
    turnOffArpCurrentNote();
    buildArpArray(kis,false); 
  } 
}
void ssArp_playbackStep(byte bank, byte step, bool in32OutPhase){
  RobotSettings rsSettings = ssSettings_getRobotSettings();
  bool halfNote;

  if (_activeRobot != 0) { return; }
  if (mArpNoteCount == 0) { mArpDoubleNotePhase = false; return; }                               // no keys down or latched; nothing to do
  
  if (rsSettings.noteType == 6){ return; }                                                   // Rhythm Off
  if (rsSettings.noteType == 5){                                                             // if in Rhythm13 then do nothing, halfNote was set by accent of previous step, else use setting
    halfNote = mArpLastHalfNote;
  } else {
    halfNote = rsSettings.noteLength;                                                        // halfNote: true == stacato(1) or false == legato(0)  
  }
  byte noteLenSteps = 1 << (4 - rsSettings.noteType);                                        // noteLenSteps 1/16 = B1 = 1; 1/8 = B10 = 2; 1/4 = B100 = 4; 1/2 = B1000 = 8   
                                                                                              // rsSettings.noteType: 1 = 1/2. 2 = 1/4; 3 = 1/8; 4 = 1/16

  // turn off previous note                                                                                            
  if (in32OutPhase){                                                                          // this handles stacato 1/16 notes by using 32 note clock (in32OutPhase)
    if (halfNote && (rsSettings.noteType == 4 || rsSettings.noteType == 5)) {                 // if playing 1/16 notes or Rhythm13 and stacato then we cut the note off on the out of phase 32 note
      turnOffArpCurrentNote(in32OutPhase);
    }
    return;                                                                                  // this is the only thing we do outPhase
  } 
  if (halfNote && (noteLenSteps > 1) && (step % noteLenSteps == noteLenSteps/2)) {           // if non- 1/16 note stacato and we are half way though the note length; turn off note 
    turnOffArpCurrentNote();
    return;                                                                                  // only play arp notes on note type (in arp settings), we are only 1/2 way there
  } 

  if (rsSettings.noteType == 5){     // Rhythm 13
    TrigEvent te = ssTrigData.getTrigEvent(_currentBank, 12, _currentStep);                   // get current step trigger data for current bank, drum track 12
    if (!te.trigger)  {                                                                       // not a trigger hit, don't play a trigger, return
      return; 
    } 
    mArpLastHalfNote = !te.accent;                                                                     // use accent to determine legato (no accent) or stacato (accent)    
  } else {
    if (step % noteLenSteps != 0) {  
      return;                                                                                 // return on any other "wrong" step - only play arp notes on note type (in arp settings)
    }    
  }

  turnOffArpCurrentNote();                                                                    // if in legato, and we've gotten this far we are on the next step, turn of previous note before playing next

  if (rsSettings.doubleNote && mArpDoubleNotePhase) {
    playArpNote(mArpNoteToDouble, step);    
  } else {
    byte note = getArpNextNote();
    if (rsSettings.keyLatch && mArpTransposeNote != 0xFF){
      note = transposeArpNote(note, getArpRootNote(), mArpTransposeNote);   
    }
    playArpNote(note, step);  
    mArpNoteToDouble = note;
  }
  mArpDoubleNotePhase = !mArpDoubleNotePhase;
  
}
void buildArpArray(KeyInputState kis, bool noteOn){
  RobotSettings rsSettings = ssSettings_getRobotSettings();

  if (noteOn) { mArpNoteVelocity = 0xFF; }                            // reset velocity; last noteOn sets velocity for entire ARP
  mArpNoteCount = 0;
  KeyInputState tKis;
  for (byte i=0;i<128;i++){
    tKis = ssMidiHelper_getKeyInputNoteState(i);
    if (tKis.handler == ARP && (noteOn || (i != kis.note))){         // the i!=note||noteOn is because at this point KeyInputNoteState has not been updated yet. so don't include the released note in the scale
      mArpArray[mArpNoteCount] = i;
      mArpNoteCount++;
      if (noteOn && mArpNoteVelocity == 0xFF){ mArpNoteVelocity = kis.velocity; }    // first note On sets the velocity
    }
  }
  mArpKeyCount = mArpNoteCount;                             // keyCount is the number of held keys
  if (rsSettings.octaveRange > 1){                          // if add one octave or two octave settings, add the first octave
    for (byte i=0;i<mArpKeyCount;i++){                           // go through the keyed notes
      if (mArpArray[i] + 12 < 128){                          // don't exceed midi note limit
        mArpArray[mArpNoteCount] = mArpArray[i] + 12;        // add octave notes
        mArpNoteCount++;
      }
    }
  }
  if (rsSettings.octaveRange == 3){                          // if two octave settings, add the second octave
    for (byte i=0;i<mArpKeyCount;i++){
      if (mArpArray[i] + 24 < 128){
        mArpArray[mArpNoteCount] = mArpArray[i] + 24;
        mArpNoteCount++;
      }
    }
  }
  if (rsSettings.direction == ROBOTDOWN) { mArpIndex = mArpNoteCount - 1; } else { mArpIndex = 0; }              // start playback at the top (down) or from the bottom (up, up/down)
}

byte transposeArpNote(byte note, byte rootNote, byte targetRoot){
  if (rootNote != 0xFF){
    int interval = targetRoot - rootNote;
    int newNote = note + interval;
    while (newNote < 0) { newNote += 12; }
    while (newNote > 127) { newNote -= 12; }
    return newNote;
  } else {
    return rootNote;
  }
}
byte getArpRootNote(){
  if (mArpNoteCount > 0){
    return mArpArray[0];
  } else {
    return 0xFF;
  }
}
byte getArpNextNote(){
  RobotSettings rsSettings = ssSettings_getRobotSettings();
  byte rtnNote = 0xFF;
  
  switch (rsSettings.direction) {                                                            // Arp direction
    case ROBOTRANDOM:
      rtnNote = mArpArray[random(mArpNoteCount)];                                             // picka random note out of the choices
      break;
    case ROBOTRNDWEIGHTED:
      if (random(100) < 33){                                                                  // 33% chance of playing root
        byte m = random(rsSettings.octaveRange);                                             // equal chance of playing root octaves
        rtnNote = mArpArray[m * mArpKeyCount];                                                // this should weight octaves
      } else {
        rtnNote = mArpArray[random(mArpNoteCount)];      
      }
      break;
    case ROBOTUP:
      rtnNote = mArpArray[mArpIndex];
      mArpIndex++;
      if (mArpIndex >= mArpNoteCount) { mArpIndex = 0; }
      break;
    case ROBOTDOWN:
      rtnNote = mArpArray[mArpIndex];
      if (mArpIndex <= 0) { mArpIndex = mArpNoteCount; }
      mArpIndex--;
      break;
    case ROBOTEXCLUDE:
      // MODE = scale up/down
      rtnNote = mArpArray[mArpIndex];
      if (mArpUpDirection){
        if (mArpIndex >= mArpNoteCount - 1) { mArpIndex--; mArpUpDirection = false;} else { mArpIndex++; }         
      } else {
        if (mArpIndex <= 0) { mArpIndex++; mArpUpDirection = true;} else { mArpIndex--; }        
      }
      break;
    case ROBOTINCLUDE:
      rtnNote = mArpArray[mArpIndex];
      if (mArpUpDirection){
        if (mArpIndex >= mArpNoteCount - 1) { mArpUpDirection = false; } else { mArpIndex++; }         
      } else {
        if (mArpIndex <= 0) { mArpUpDirection = true;} else { mArpIndex--; }       
      }
      break;       
  }
  return rtnNote;
}

void playArpNote(byte note, int step){
  if (note > 127 || mArpNoteVelocity > 127) { return; }
  if (!ssMuteSolo_trackFilter(_currentBank, mArpTrack)) { return; }
  ssMidiHelper_sendTrackNote(mArpTrack,  note, mArpNoteVelocity, ON, SEQ);
  mArpCurrentNote = note;
                                           
  if (_inRec && ssArp_onArpTrack()) {
    ssNoteData.addEvent(step*2,_currentBank,mArpTrack,1,note,mArpNoteVelocity, false);
    mArpCurrentNoteRecorded = true; 
    ssFileHelper_makeFileDirty(43);
  }
}

void turnOffArpCurrentNote(){
  turnOffArpCurrentNote(false);  
}
void turnOffArpCurrentNote(bool outPhase32note){
  if (mArpCurrentNote != 0xFF){
    ssMidiHelper_sendTrackNote(mArpTrack, mArpCurrentNote, 0, OFF, SEQ);
    closeRecordedArpNote(outPhase32note);
    mArpCurrentNote = 0xFF;  
  }
}
void closeRecordedArpNote(){
  closeRecordedArpNote(false);  
}
void closeRecordedArpNote(bool outPhase32note){
  if (mArpCurrentNoteRecorded) {
    int step = _currentStep*2;
    if (outPhase32note) { step++; }
    ssNoteData.addEvent(step,_currentBank,mArpTrack,2,mArpCurrentNote,0, false); 
    mArpCurrentNoteRecorded = false;
    ssFileHelper_makeFileDirty(44);
  }  
}
void ssArp_setArpTrack(byte track){
  mArpTrack = track;
}
byte ssArp_getArpTrack(){
  return mArpTrack;
}
void ssArp_begin(){
  for (byte i=0;i<30;i++){
    mArpArray[i] = 0xFF;  
  }
}
void ssArp_makeActiveRobot(){
  if (_activeRobot != 0){             // if not already active robot
    mArpTrack =  _currentNoteTrack;
    _activeRobot = 0;
    RobotSettings rsSettings = ssSettings_getRobotSettings();
    rsSettings.keyLatch = false;
    rsSettings.noteType = 4;
    rsSettings.transpose = 0;
    ssSettings_setRobotSettings(rsSettings);    
  }  
}
void ssArp_arpModeOff(){
  turnOffArpCurrentNote();
  mArpTrack = 0xFF;
  mArpNoteCount = 0;
  mArpTransposeNote = 0xFF;
  _activeRobot = 0xFF;
}

bool ssArp_onArpTrack(){
  return !_inTrigger && (mArpTrack == _currentNoteTrack) && (_activeRobot == 0);
}

void ssArp_handleStop(){
  turnOffArpCurrentNote();
  mArpIndex = 0;
  mArpNoteCount = 0;
  mArpTransposeNote = 0xFF;
}

void ssArp_handlePlay(bool inPlay){
  if (!inPlay){                           // if paused
    turnOffArpCurrentNote();   
  }
}

void ssArp_handleRec(bool inRec){
  if (!inRec){
    closeRecordedArpNote();  
  }
}
